#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "HYParticleFilter.h"
#include "PFBundleAdjust.h"


BundleAdjustFilter::BundleAdjustFilter(int np,float rr,float mn,
				       float txc,float txr,
				       float tyc,float tyr,
				       float tzc,float tzr,
				       float rxc,float rxr,
				       float ryc,float ryr,
				       float rzc,float rzr)
  : HYParticleFilter(6,np,rr){
  txcenter=txc;
  txrange=txr;
  tycenter=tyc;
  tyrange=tyr;
  tzcenter=tzc;
  tzrange=tzr;
  rxcenter=rxc;
  rxrange=rxr;
  rycenter=ryc;
  ryrange=ryr;
  rzcenter=rzc;
  rzrange=rzr;

  npoints_max=1000;
  points3d=new float[npoints_max*3];
  points2d=new float[npoints_max*2];

  mnoise=mn;
}

BundleAdjustFilter::~BundleAdjustFilter(){
  delete[] points3d;
  delete[] points2d;
}

void BundleAdjustFilter::predict(){
  /*
  int i;
  float s;
  for(i=0;i<dstate*nparticles;i++){
    s=stateTable[i];

    if(s>0.5){
      stateTable[i]=0.5;
    }else if(s<-0.5){
      stateTable[i]=-0.5;
    }
  }
  */
}
float BundleAdjustFilter::likelihood(float *state){
  //float val=0.0;
  float val=1.0;
  float px,py,pz,scpx,scpy;
  float xxx,yyy,zzz;
  float erx,ery;

  int i;

  stateToCoords(state);

  for(i=0;i<npoints;i++){
    px=points3d[3*i];
    py=points3d[3*i+1];
    pz=points3d[3*i+2];
    scpx=points2d[2*i];
    scpy=points2d[2*i+1];

    /*
    xxx = focal * (tx + pz * sinry + cosry * (px * cosrz - py * sinrz));
    yyy = focal * (ty - pz * cosry * sinrx + px * cosrz * sinrx * sinry - 
		   py * sinrx * sinry * sinrz + cosrx * (py * cosrz + px * sinrz));
    zzz = tz + py * cosrz * sinrx + px * sinrx * sinrz + 
      cosrx * (pz * cosry + sinry * (-px * cosrz + py * sinrz));
    */
    xxx = focal * (tx + px * cosry * cosrz + py * cosrz * sinrx * sinry + 
		   pz * sinrx * sinrz + cosrx * (pz * cosrz * sinry - py * sinrz));
    yyy = focal * (ty - pz * cosrz * sinrx + px * cosry * sinrz + 
		   py * sinrx * sinry * sinrz + cosrx * (py * cosrz + pz * sinry * sinrz));
    zzz = tz + pz * cosrx * cosry + py * cosry * sinrx - px * sinry;

    erx=scpx-(xxx/zzz);
    ery=scpy-(yyy/zzz);
 
    //val+=exp(mnoise*(erx*erx+ery*ery));
    val*=(1.0/(1.0+(erx*erx+ery*ery)));

  }
  return val;
}
void BundleAdjustFilter::stateToCoords(float *state){
  tx=txcenter+state[0]*txrange;
  ty=tycenter+state[1]*tyrange;
  tz=tzcenter+state[2]*tzrange;
  rx=rxcenter+state[3]*rxrange;
  ry=rycenter+state[4]*ryrange;
  rz=rzcenter+state[5]*rzrange;

  sinrx=sin(rx);
  cosrx=cos(rx);
  sinry=sin(ry);
  cosry=cos(ry);
  sinrz=sin(rz);
  cosrz=cos(rz);
}
void BundleAdjustFilter::setPoints(float *pts3d,float *pts2d,int num){
  npoints=num;
  memcpy(points3d,pts3d,sizeof(float)*num*3);
  memcpy(points2d,pts2d,sizeof(float)*num*2);
}
void BundleAdjustFilter::setCameraParams(float ff){
  focal=ff;
}

void BundleAdjustFilter::getCoords(float *vv){
  vv[0]=txcenter+state[0]*txrange;
  vv[1]=tycenter+state[1]*tyrange;
  vv[2]=tzcenter+state[2]*tzrange;
  vv[3]=rxcenter+state[3]*rxrange;
  vv[4]=rycenter+state[4]*ryrange;
  vv[5]=rzcenter+state[5]*rzrange;
}
  
///////////////////////////////////////

VectorBundleAdjustFilter::VectorBundleAdjustFilter(int np,float rr,float mn,
				       float tc,float tr,
				       float rxc,float rxr,
				       float ryc,float ryr,
				       float rzc,float rzr)
  : HYParticleFilter(4,np,rr){
  tcenter=tc;
  trange=tr;
  rxcenter=rxc;
  rxrange=rxr;
  rycenter=ryc;
  ryrange=ryr;
  rzcenter=rzc;
  rzrange=rzr;

  npoints_max=1000;
  points3d=new float[npoints_max*3];
  points2d=new float[npoints_max*2];

  vec=new float[3];
  vec[0]=0.0;
  vec[1]=0.0;
  vec[2]=1.0;

  mnoise=mn;
}

VectorBundleAdjustFilter::~VectorBundleAdjustFilter(){
  delete[] points3d;
  delete[] points2d;
}

void VectorBundleAdjustFilter::predict(){
  /*
  int i;
  float s;
  for(i=0;i<dstate*nparticles;i++){
    s=stateTable[i];

    if(s>0.5){
      stateTable[i]=0.5;
    }else if(s<-0.5){
      stateTable[i]=-0.5;
    }
  }
  */
}
float VectorBundleAdjustFilter::likelihood(float *state){
  //float val=0.0;
  float val=1.0;
  float px,py,pz,scpx,scpy;
  float xxx,yyy,zzz;
  float erx,ery;

  int i;

  stateToCoords(state);

  for(i=0;i<npoints;i++){
    px=points3d[3*i];
    py=points3d[3*i+1];
    pz=points3d[3*i+2];
    scpx=points2d[2*i];
    scpy=points2d[2*i+1];

    /*
    xxx = focal * (tx + pz * sinry + cosry * (px * cosrz - py * sinrz));
    yyy = focal * (ty - pz * cosry * sinrx + px * cosrz * sinrx * sinry - 
		   py * sinrx * sinry * sinrz + cosrx * (py * cosrz + px * sinrz));
    zzz = tz + py * cosrz * sinrx + px * sinrx * sinrz + 
      cosrx * (pz * cosry + sinry * (-px * cosrz + py * sinrz));
    */
    xxx = focal * (tx + px * cosry * cosrz + py * cosrz * sinrx * sinry + 
		   pz * sinrx * sinrz + cosrx * (pz * cosrz * sinry - py * sinrz));
    yyy = focal * (ty - pz * cosrz * sinrx + px * cosry * sinrz + 
		   py * sinrx * sinry * sinrz + cosrx * (py * cosrz + pz * sinry * sinrz));
    zzz = tz + pz * cosrx * cosry + py * cosry * sinrx - px * sinry;

    erx=scpx-(xxx/zzz);
    ery=scpy-(yyy/zzz);
 
    //val*=exp(mnoise*(erx*erx+ery*ery));
    val*=(1.0/(1.0+(erx*erx+ery*ery)));

  }
  return val;
}
void VectorBundleAdjustFilter::stateToCoords(float *state){
  float tt;
  tt=tcenter+state[0]*trange;
  
  tx=vec[0]*tt;
  ty=vec[1]*tt;
  tz=vec[2]*tt;

  rx=rxcenter+state[1]*rxrange;
  ry=rycenter+state[2]*ryrange;
  rz=rzcenter+state[3]*rzrange;

  sinrx=sin(rx);
  cosrx=cos(rx);
  sinry=sin(ry);
  cosry=cos(ry);
  sinrz=sin(rz);
  cosrz=cos(rz);
}
void VectorBundleAdjustFilter::setPoints(float *pts3d,float *pts2d,int num){
  npoints=num;
  memcpy(points3d,pts3d,sizeof(float)*num*3);
  memcpy(points2d,pts2d,sizeof(float)*num*2);
}
void VectorBundleAdjustFilter::setCameraParams(float ff){
  focal=ff;
}

void VectorBundleAdjustFilter::getCoords(float *vv){
  float tt;
  tt=tcenter+state[0]*trange;
  vv[0]=vec[0]*tt;
  vv[1]=vec[1]*tt;
  vv[2]=vec[2]*tt;
  vv[3]=rxcenter+state[1]*rxrange;
  vv[4]=rycenter+state[2]*ryrange;
  vv[5]=rzcenter+state[3]*rzrange;
}
  
