#ifndef __SURFCONVERTER_H__
#define __SURFCONVERTER_H__

// from OpenCV1.1-pre1/samples/find_obj.cpp
#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>

#include <stdio.h>
#include <stdlib.h>

#include <iostream>
#include <vector>
#include <string>
#include <fstream>

#ifdef _MSC_VER
#include <windows.h>
#include <mmsystem.h>
#endif

#include "ImageProcs.h"
#include "LSHTable.h"

using namespace std;

double
compareSURFDescriptors( const float* d1, const float* d2, double best, int length );

int
naiveNearestNeighbor( const float* vec, int laplacian,
                      const CvSeq* model_keypoints,
                      const CvSeq* model_descriptors );

int
naiveNearestNeighbor2( const float* vec, const CvMat* model_descriptors );

void
findPairs( const CvSeq* objectKeypoints, const CvSeq* objectDescriptors,
           const CvSeq* imageKeypoints, const CvSeq* imageDescriptors, vector<int>& ptpairs );

void
findPairs2( const CvMat* desc_pca_mat_ref_pl, const CvMat* desc_pca_mat_ref_nl, 
	    const CvMat* desc_pca_mat_ser_pl, const CvMat* desc_pca_mat_ser_nl, 
	    vector<int>& index_list_ref_pl, vector<int>& index_list_ref_nl,
	    vector<int>& index_list_ser_pl, vector<int>& index_list_ser_nl,
	    vector<int>& ptpairs );

void
findPairs3( LSHTable* lsht_pl, LSHTable* lsht_nl,
	    const CvMat* desc_pca_mat_ser_pl, const CvMat* desc_pca_mat_ser_nl, 
	    vector<int>& index_list_ser_pl, vector<int>& index_list_ser_nl,
	    vector<int>& ptpairs );

// using FLANN from OpenCV2.0 sample code
void
flannFindPairs( const CvSeq*, const CvSeq* objectDescriptors,
                const CvSeq*, const CvSeq* imageDescriptors, vector<int>& ptpairs );
void
flannFindPairs2( cv::flann::Index *ann_index_pl,
		 cv::flann::Index *ann_index_nl,
		 CvMat* desc_pca_mat_ser_pl, CvMat* desc_pca_mat_ser_nl, 
		 vector<int>& index_list_ref_pl, vector<int>& index_list_ref_nl,
		 vector<int>& index_list_ser_pl, vector<int>& index_list_ser_nl,
		 vector<int>& ptpairs);
//

/* a rough implementation for object location */
int
locatePlanarObject( const CvSeq* objectKeypoints, const CvSeq* objectDescriptors,
                    const CvSeq* imageKeypoints, const CvSeq* imageDescriptors,
                    const CvPoint src_corners[4], CvPoint dst_corners[4] );

int
locatePlanarObject2( const int n, const float *src_points, const float *dst_points,
		     const float *src_corners, float *dst_corners );


class SURFConverter{
 private:
  CvSeq *refKeypoints, *refDescriptors;
  CvSeq *serKeypoints, *serDescriptors;
  CvSURFParams surfparams;
  CvMemStorage *storage_ref,*storage_ser;
  IplImage *refimage,*serimage;
  int refwidth,refheight;
  int serwidth,serheight;

  CvMat *average_pl,*eigenval_pl,*eigenvec_pl;
  CvMat *average_nl,*eigenval_nl,*eigenvec_nl;

  vector<int> index_list_ref_pl,index_list_ref_nl;
  vector<int> index_list_ser_pl,index_list_ser_nl;

  CvMat *desc_mat_ref_pl,*desc_mat_ref_nl;
  CvMat *desc_pca_mat_ref_pl,*desc_pca_mat_ref_nl;
  CvMat *desc_mat_ser_pl,*desc_mat_ser_nl;
  CvMat *desc_pca_mat_ser_pl,*desc_pca_mat_ser_nl;

  
  // more references
  vector<IplImage *> refimagelist;
  vector<int> refwidthlist,refheightlist;
  CvSeq *refKey2,*refDesc2;
  CvMemStorage *storage_ref2;
  vector<float> key_reflist;
  vector<int> index_offset_reflist;
  vector<int> index_list_reflist_pl,index_list_reflist_nl;
  CvMat *desc_mat_reflist_pl,*desc_mat_reflist_nl;
  CvMat *desc_pca_mat_reflist_pl,*desc_pca_mat_reflist_nl;

  // for real size
  vector<float> refwidthlistmm,refheightlistmm;

  // LSH
  LSHTable *lsht_pl,*lsht_nl;
  LSHTable *lsht_list_pl,*lsht_list_nl;
  vector<int> hashlist_ref_pl,hashlist_ref_nl;
  vector<int> hashlist_reflist_pl,hashlist_reflist_nl;

  // ANN
  cv::flann::Index *ann_index_ref_pl,*ann_index_ref_nl;

  // LSH in opencv
  CvLSH *cv_lsh_pl,*cv_lsh_nl;

 public:
  SURFConverter();
  ~SURFConverter();

  int getRefWidth(){return refwidth;}
  int getRefHeight(){return refheight;}
  int getSerWidth(){return serwidth;}
  int getSerHeight(){return serheight;}

  void setRefImage(int width,int height,unsigned char *buf);
  void setRefImage(IplImage *img);
  void convertRef();
  void convertPCARef();

  void setSerImage(int width,int height,unsigned char *buf);
  void setSerImage(IplImage *img);
  void convertSer();
  void convertPCASer();

  void pushRefImageList(IplImage *img);
  void pushRefImageList(IplImage *img,float widthmm,float heightmm);
  void clearRefImageList();
  IplImage *getRefImageListOf(int idx);

  vector <IplImage *> &getRefImageList(){return refimagelist;}
  int getRefWidthOf(int idx){return refwidthlist[idx];}
  int getRefHeightOf(int idx){return refheightlist[idx];}
  float getRefWidthmmOf(int idx){return refwidthlistmm[idx];}
  float getRefHeightmmOf(int idx){return refheightlistmm[idx];}
  void convertRefList();
  //void convertPCARefList();

  int matching(float *refpoints,float *serpoints);
  int matchingANN(float *refpoints,float *serpoints);
  int matchingAndLocate(float *param);
  int matchingPCA(float *refpoints,float *serpoints);
  int matchingPCAAndLocate(float *param);

  int matchingPCALSH(float *refpoints,float *serpoints);
  int matchingList(vector<float> &refpoints,vector<float> &serpoints);
  int matchingList(vector<float> &refpoints,vector<float> &serpoints,int thres);
  int matchingListLSH(vector<float> &refpoints,vector<float> &serpoints);
  int matchingListLSH(vector<float> &refpoints,vector<float> &serpoints,int thres);
  int matchingListANN(vector<float> &refpoints,vector<float> &serpoints);
  int matchingListANN(vector<float> &refpoints,vector<float> &serpoints,int thres);
  int matchingListCvLSH(vector<float> &refpoints,vector<float> &serpoints);
  int matchingListCvLSH(vector<float> &refpoints,vector<float> &serpoints,int thres);

  // for perfcheck
  void convertRefListEX(string &fname,int num,int usedim);
  int matchingListLSHEX(string &fname,int num,vector<float> &refpoints,vector<float> &serpoints);

};


////////////////////////////////////////////////
void convertTo3DPoints(int npoints,float iwidth,float iheight,float *points2d,
		       float owidth,float oheight,float *points3d);

/////////////////////////////////

#endif
