#include "VVDObject.h"
#include "VVDFileManager.h"

using namespace std;

void InvertEndian(char *ibuf,void *obuf,int size){
  for(int i=0;i<size;i++)
    ((char *)obuf)[i]=ibuf[size-1-i];
}

int CheckVVD(const char *filename){
  ifstream fin(filename,ios::in | ios::binary);

  if(!fin){
    cerr << "file not found: " << filename << endl;
    return 1;
  }

  size_t filesize = (size_t)fin.seekg(0, ios::end).tellg();
  fin.seekg(0, ios::beg);
  cout << "file size: " << filesize << endl;

  int ii,jj;
  long li;
  double dd;
  char cbuf[512];
  vector<int> texihist;
  
  // check header
  fin.read(cbuf,16);
  cbuf[16]='\0';
  if(string(cbuf)!="VIVID"){
    cerr << filename << ": is not VVD file." << endl;
    return 1;
  }
  cout << "Device Name: " << cbuf << endl; 

  fin.read(cbuf,16);
  cbuf[16]='\0';
  if(string(cbuf)!="3.01"){
    cerr << filename << ": version number missmatch." << endl;
    return 1;
  }
  cout << "Version: " << cbuf << endl; 

  fin.read(cbuf,32);
  cbuf[32]='\0';
  cout << "Model Name: " << cbuf << endl; 

  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << "Num of child(ren) node(s): " << ii << endl;

  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << "Data Type: " << ii << endl;

  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << "Offset of image: " << ii << endl;
  int imgofs=ii;

  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << "Num of image(s): " << ii << endl;
  texihist.resize(ii+1);
  for(int i=0;i<ii+1;i++)
    texihist[i]=0;

  //skip 48 bytes;
  fin.seekg(48,ios::cur);

  // node type : always 1
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);

  if(ii!=1){
    cerr << filename << ": unknown node type " << ii << endl;
    return 1;
  }

  // vertices:
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << " Num of vertices: " << ii << endl;
  int nverts=ii;
  // skip ii * 24 bytes;
  fin.seekg(24*ii,ios::cur);

  // faces:
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << " Num of faces: " << ii << endl;

  // face may be constructed by 3 or 4 vertices
  int nfaces=ii;
  int bfaces=0;
  for(int i=0;i<nfaces;i++){
    fin.read(cbuf,4);
    bfaces+=4;
    InvertEndian(cbuf,&ii,4);
    fin.seekg(4*ii,ios::cur);
    bfaces+=ii*4;
  }

  // Texture coords:
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << " Num of texcoords: " << ii << endl;
  int ntc=ii;
  int btc=0;
  double xx,yy;
  double tc_x_min=640.0,tc_x_max=0.0,tc_y_min=480.0,tc_y_max=0.0;
  for(int i=0;i<ntc;i++){
    fin.read(cbuf,4);
    btc+=4;
    InvertEndian(cbuf,&ii,4);
    //fin.seekg(16*ii,ios::cur);
    for(int j=0;j<ii;j++){
      fin.read(cbuf,8);
      InvertEndian(cbuf,&xx,8);
      fin.read(cbuf,8);
      InvertEndian(cbuf,&yy,8);
      
      if(tc_x_min > xx) tc_x_min=xx;
      if(tc_x_max < xx) tc_x_max=xx;
      if(tc_y_min > yy) tc_y_min=yy;
      if(tc_y_max < yy) tc_y_max=yy;
    }

    btc+=16*ii;
  }
  cout << "  min x y: " << tc_x_min << ", " << tc_y_min << endl;
  cout << "  max x y: " << tc_x_max << ", " << tc_y_max << endl;

  // Texture indexes:
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << " Num of texindexes: " << ii << endl;
  //fin.seekg(4*ii,ios::cur);
  int nti=ii;
  for(int k=0;k<=(nti/10000);k++){
    for(int i=k*10000;i<(((k+1)*10000<nti)?(k+1)*10000:nti);i++){
      fin.read(cbuf,4);
      InvertEndian(cbuf,&ii,4);
      if(ii>=0 && ii<(texihist.size()-1)){
	texihist[ii]++;
      }else{
	cout << "   unknown index: " << ii << endl;
	texihist[texihist.size()-1]++;
      }
    }
    cout << "  texi: ";
    for(int i=0;i<texihist.size();i++){
      cout << texihist[i] << " ";
    }
    cout << endl;
  }

  // Selected Points::
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << " Num of selected points: " << ii << endl;
  fin.seekg(4*ii,ios::cur);
  int nsp=ii;

  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << " Num of unselected points: " << ii << endl;
  fin.seekg(4*ii,ios::cur);
  int usp=ii;


  // total size
  int totals=(4+nverts*24 + 4+bfaces + 4+btc + 4+nti*4 + 4+nsp*4 + 4+usp*4 +132);
  cout << "object: total size = " << totals << endl;
  fin.seekg(imgofs-totals,ios::cur);

  // images
  // num of image?
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << " Num of images: " << ii << endl;
  int nimg=ii;

  int iw,ih,iw2,ih2;
  double viewpoint[3],viewvector[3],upvector[3];
  double focal,pitchx,pitchy,centerx,centery;
  char ofname[256];
  for(int i=0;i<nimg;i++){
    fin.read(cbuf,4);
    InvertEndian(cbuf,&ii,4);
    iw=ii;
    fin.read(cbuf,4);
    InvertEndian(cbuf,&ii,4);
    ih=ii;

    cout << " Image[" << i << "]" <<endl;
    cout << "  Image size: " << iw << " x " << ih << endl;

    // image buffer
    fin.seekg(iw*ih*4,ios::cur);

    fin.seekg(124,ios::cur);
  }

  return 0;
}



int ReadVVD(const char *filename,VVDObject *vvd){
  ifstream fin(filename,ios::in | ios::binary);

  if(!fin){
    cerr << "file not found: " << filename << endl;
    return 1;
  }

  int ii,jj;
  long li;
  double dd;
  int f0,f1,f2,f3;
  double x0,y0,x1,y1,x2,y2,x3,y3;
  char cbuf[512];

  vector<float> vertices;
  vector<int> faces;
  vector<float> texcoords;
  vector<int> texindexes;
  
  vector<unsigned char> istri;
  
  // check header
  fin.read(cbuf,16);
  cbuf[16]='\0';
  if(string(cbuf)!="VIVID"){
    cerr << filename << ": is not VVD file." << endl;
    return 1;
  }

  fin.read(cbuf,16);
  cbuf[16]='\0';
  if(string(cbuf)!="3.01"){
    cerr << filename << ": version number missmatch." << endl;
    return 1;
  }

  fin.read(cbuf,32); // model name
  cbuf[32]='\0';

  //fin.read(cbuf,4);
  //fin.read(cbuf,4);
  fin.seekg(8,ios::cur);

  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  int imgofs=ii;

  //fin.read(cbuf,4);
  //skip 48 bytes;
  //fin.seekg(48,ios::cur);
  fin.seekg(52,ios::cur);

  // node type : always 1
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);

  if(ii!=1){
    cerr << filename << ": unknown node type " << ii << endl;
    return 1;
  }

  // vertices:
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << " Num of vertices: " << ii << endl;
  int nverts=ii;
  // skip ii * 24 bytes;
  //fin.seekg(24*ii,ios::cur);
  for(int i=0;i<nverts*3;i++){
    fin.read(cbuf,8);
    InvertEndian(cbuf,&dd,8);
    vertices.push_back((float)dd);
  }

  // faces:
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << " Num of faces: " << ii << endl;

  // face may be constructed by 3 or 4 vertices
  int nfaces=ii;
  int bfaces=0;
  istri.resize(nfaces);
  for(int i=0;i<nfaces;i++){
    fin.read(cbuf,4);
    bfaces+=4;
    InvertEndian(cbuf,&ii,4);
    switch(ii){
    case 3:
      for(int j=0;j<3;j++){
	fin.read(cbuf,4);
	InvertEndian(cbuf,&jj,4);
	faces.push_back(jj);
      }
      istri[i]=1;
      break;
    case 4:// triangulate
      fin.read(cbuf,4);
      InvertEndian(cbuf,&f0,4);
      fin.read(cbuf,4);
      InvertEndian(cbuf,&f1,4);
      fin.read(cbuf,4);
      InvertEndian(cbuf,&f2,4);
      fin.read(cbuf,4);
      InvertEndian(cbuf,&f3,4);

      faces.push_back(f0);
      faces.push_back(f1);
      faces.push_back(f2);

      faces.push_back(f2);
      faces.push_back(f3);
      faces.push_back(f0);

      istri[i]=2;
      break;
    }
    //fin.seekg(4*ii,ios::cur);
    bfaces+=ii*4;
  }

  // Texture coords:
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << " Num of texcoords: " << ii << endl;
  int ntc=ii;
  int btc=0;
  for(int i=0;i<ntc;i++){
    fin.read(cbuf,4);
    btc+=4;
    InvertEndian(cbuf,&ii,4);
    switch(ii){
    case 3:
      for(int j=0;j<6;j++){
	fin.read(cbuf,8);
	InvertEndian(cbuf,&dd,8);
	texcoords.push_back((float)dd);
      }
      break;
    case 4:// triangulate
      fin.read(cbuf,8);
      InvertEndian(cbuf,&x0,8);
      fin.read(cbuf,8);
      InvertEndian(cbuf,&y0,8);
      fin.read(cbuf,8);
      InvertEndian(cbuf,&x1,8);
      fin.read(cbuf,8);
      InvertEndian(cbuf,&y1,8);
      fin.read(cbuf,8);
      InvertEndian(cbuf,&x2,8);
      fin.read(cbuf,8);
      InvertEndian(cbuf,&y2,8);
      fin.read(cbuf,8);
      InvertEndian(cbuf,&x3,8);
      fin.read(cbuf,8);
      InvertEndian(cbuf,&y3,8);

      texcoords.push_back((float)x0); texcoords.push_back((float)y0);
      texcoords.push_back((float)x1); texcoords.push_back((float)y1);
      texcoords.push_back((float)x2); texcoords.push_back((float)y2);

      texcoords.push_back((float)x2); texcoords.push_back((float)y2);
      texcoords.push_back((float)x3); texcoords.push_back((float)y3);
      texcoords.push_back((float)x0); texcoords.push_back((float)y0);
      
      break;
    }
    //fin.seekg(16*ii,ios::cur);
    btc+=16*ii;
  }

  // Texture indexes:
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  //cout << " Num of texindexes: " << ii << endl;
  //fin.seekg(4*ii,ios::cur);
  int nti=ii;
  for(int i=0;i<nti;i++){
    fin.read(cbuf,4);
    InvertEndian(cbuf,&ii,4);
    for(int j=0;j<istri[i];j++){
      texindexes.push_back(ii);
    }
  }

  // Selected Points::
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  //cout << " Num of selected points: " << ii << endl;
  fin.seekg(4*ii,ios::cur);
  int nsp=ii;

  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  //cout << " Num of unselected points: " << ii << endl;
  fin.seekg(4*ii,ios::cur);
  int usp=ii;



  // copy to VVDObject
  vvd->setVertices(vertices);
  vvd->setFaces(faces);
  vvd->setTexCoords(texcoords);
  vvd->setTexIndexes(texindexes);




  // total size
  int totals=(4+nverts*24 + 4+bfaces + 4+btc + 4+nti*4 + 4+nsp*4 + 4+usp*4 +132);
  //cout << "object: total size = " << totals << endl;
  fin.seekg(imgofs-totals,ios::cur);

  // images
  // num of image?
  fin.read(cbuf,4);
  InvertEndian(cbuf,&ii,4);
  cout << " Num of images: " << ii << endl;
  int nimg=ii;




  // create image list
  vvd->createVVDImageList(nimg);




  int iw,ih,iw2,ih2;
  double viewpoint[3],viewvector[3],upvector[3];
  double focal,pitchx,pitchy,centerx,centery;
  char ofname[256];
  vector <unsigned char> imgbuf;
  for(int i=0;i<nimg;i++){
    fin.read(cbuf,4);
    InvertEndian(cbuf,&ii,4);
    iw=ii;
    fin.read(cbuf,4);
    InvertEndian(cbuf,&ii,4);
    ih=ii;

    cout << " Image[" << i << "]" <<endl;
    cout << "  Image size: " << iw << " x " << ih << endl;

    imgbuf.resize(iw*ih*3);

    // image data: iw*ih*4;
    /*
    {
      sprintf(ofname,"test_%d.ppm",i);
      ofstream fout(ofname,ios::out | ios::binary);

      fout.write("P6\n",3);
      fout.write("640 480\n",8);
      fout.write("255\n",4);

      for(int j=0;j<640*480;j++){
	fin.read(cbuf,4);
	fout.write(cbuf,3);
      }

    }
    */
    //fin.seekg(iw*ih*4,ios::cur);

    for(int j=0;j<640*480;j++){
      fin.read(cbuf,4);
      memcpy(&imgbuf[j*3],cbuf,3);
    }

    vvd->setImage(i,iw,ih,&imgbuf[0]);

    fin.seekg(124,ios::cur);
  }

  return 0;
}
