/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.commands;

import org.eclipse.gef.commands.Command;

import org.maskat.core.layout.Grid;
import org.maskat.core.layout.GridHeader;

public class AddGridHeaderCommand extends Command {
	
	Grid grid;

	GridHeader header;

	public AddGridHeaderCommand(Grid grid, GridHeader header) {
		this.grid = grid;
		this.header = header;
	}

	public void execute() {
		grid.addChild(header);
	}

	public void undo() {
		grid.removeChild(header);
	}

	public boolean canUndo() {
		return true;
	}
}
