/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;

import org.maskat.core.layout.TabFolder;
import org.maskat.core.layout.TabItem;
import org.maskat.ui.editors.layout.editpolicies.ComponentXYLayoutEditPolicy;
import org.maskat.ui.editors.layout.editpolicies.DataBindingEditPolicy;
import org.maskat.ui.editors.layout.editpolicies.FeedBackComponentEditPolicy;
import org.maskat.ui.editors.layout.editpolicies.LabelDirectEditPolicy;
import org.maskat.ui.editors.layout.editpolicies.TabEditPolicy;
import org.maskat.ui.editors.layout.figures.TabFigure;
import org.maskat.ui.editors.layout.models.TabDef;

/**
 * TabFolderコンポーネントのタブボタン
 */
public class TabEditPart extends ComponentEditPart
	implements LabelDirectEditable {

	public static final int minimalTabDisplayWidth = 10;

	public void activate() {
		super.activate();
//		((TabDef) getModel()).addPropertyChangeListener(this);
		TabItem model = (TabItem) ((TabDef) getModel()).getModel();
		model.addPropertyChangeListener(this);
//		((TabDef) getModel()).getModel().addPropertyChangeListener(this);
	}

	public void deactivate() {
//		((TabDef) getModel()).removePropertyChangeListener(this);
		//((TabDef) getModel()).getTabItem().removePropertyChangeListener(this);
		TabItem model = (TabItem) ((TabDef) getModel()).getModel();
		model.removePropertyChangeListener(this);
		super.deactivate();
	}	
	
	protected IFigure createFigure() {
		final TabDef tab = (TabDef) getModel();
//		final TabItem tab = (TabItem) getModel();
		Figure figure = new TabFigure(tab.getName(), tab.getTitle());
		figure.addMouseListener(new MouseListener.Stub() {
			public void mousePressed(MouseEvent me) {
				TabFolderEditPart tabFolder = (TabFolderEditPart) TabEditPart.this
						.getParent();
				tabFolder.switchToPage(tab.getName());
			}
		});
		return figure;
	}

	protected void createEditPolicies() {
		int style = FeedBackComponentEditPolicy.getStyle(this);
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new TabEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new ComponentXYLayoutEditPolicy(style));
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new LabelDirectEditPolicy());
		installEditPolicy("Snap Feedback", new SnapFeedbackPolicy());
		installEditPolicy(DataBindingEditPolicy.ROLE, new DataBindingEditPolicy());
	}

	protected void refreshVisuals() {
		TabDef tab = (TabDef) getModel();
//		TabItem tab = (TabItem) getModel();
		TabFolder tabFolderDef = (TabFolder) tab.getParent();
		selfLayout(String.valueOf(tabFolderDef.getWidthTabName()));
	}

	public void selfLayout(String widthTabName) {
		TabDef tab = (TabDef) getModel();
//		TabItem tab = (TabItem) getModel();
		TabFolder tabFolderDef = (TabFolder) tab.getParent();
		int idx = tabFolderDef.getTabIdxByName(tab.getName());
		
		// parentに定義順番によって、位置を計算
		int tabWidth = toTabDisplayWidth(widthTabName);
		Rectangle constraint = new Rectangle(idx * tabWidth, 0, tabWidth, 15);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);

	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("title".equals(evt.getPropertyName())) {
			TabFigure tabFig = (TabFigure) getFigure();
			tabFig.setText((String) evt.getNewValue());
		}
		super.propertyChange(evt);
	}

	/**
	 * タブタイトル表示用の幅を返す（minimalTabDisplayWidth以下であれば、minimalTabDisplayWidthを返す）
	 * つまり、タブタイトルの表示幅最小限を限定
	 * 
	 * @param widthTabName
	 * @return
	 */
	public static int toTabDisplayWidth(String widthTabName) {
		try {
			int width = Integer.parseInt(widthTabName);
			return Math.max(width, minimalTabDisplayWidth);
		} catch (NumberFormatException e) {
			return minimalTabDisplayWidth;
		}
	}

	public static int toTabDisplayWidth(int widthTabName) {
		return Math.max(widthTabName, minimalTabDisplayWidth);
	}

	public String getLabel() {
		return ((TabDef) getModel()).getTitle();
//		return ((TabItem) getModel()).getTitle();
	}

	public void setLabel(String text) {
		((TabDef) getModel()).setTitle(text);
//		((TabItem) getModel()).setTitle(text);
	}
}
