/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.Grid;
import org.maskat.ui.views.properties.descriptor.BooleanComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.ComboBoxLabelConstants;
import org.maskat.ui.views.properties.descriptor.MaskatComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class GridPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";
	
	public static final String PROP_TOP = "_prop_top_";
	
	public static final String PROP_LEFT = "_prop_left_";
	
	public static final String PROP_HEIGHT = "_prop_height_";
	
	public static final String PROP_ACTIFCLIC = "_prop_actifClic_";
	
	public static final String PROP_AUTORESIZABLEH = "_prop_autoResizableH_";
	
	public static final String PROP_AUTORESIZABLEW = "_prop_autoResizableW_";
	
	public static final String PROP_AUTORESIZECONTENU = "_prop_autoResizeContenu_";
	
	public static final String PROP_AUTORESIZEPARENT = "_prop_autoResizeParent_";
	
	public static final String PROP_BNAVIG = "_prop_bNavig_";
	
	public static final String PROP_BOOLPRINT = "_prop_boolPrint_";
	
	public static final String PROP_CELLACTIVE = "_prop_cellActive_";
	
	public static final String PROP_DRAGGABLE = "_prop_draggable_";
	
	public static final String PROP_LINEHEIGHT = "_prop_lineHeight_";
	
	public static final String PROP_MULTISELECT = "_prop_multiSelect_";
	
	public static final String PROP_POSITION = "_prop_position_";
	
	public static final String PROP_RANG = "_prop_rang_";
	
	public static final String PROP_SORTABLE = "_prop_sortable_";
	
	public static final String PROP_SORTCOL = "_prop_sortCol_";
	
	public static final String PROP_SORTTYPE = "_prop_sortType_";
	
	public static final String PROP_SWITCHABLE = "_prop_switchable_";
	
	public static final String PROP_TABINDEX = "_prop_tabIndex_";
	
	public static final String PROP_WIDTH = "_prop_width_";
	
	public static final String PROP_WIDTHLASTCELL = "_prop_widthLastCell_";
	
	public static final String PROP_WRITABLE = "_prop_writable_";
	
	public static final String PROP_PRINTTITLE = "_prop_printTitle_";
	
	public static final String PROP_ONCELLEDIT = "_prop_onCellEdit_";

	public GridPropertySource(Grid grid) {
		super(grid);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				  new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				  new MaskatTextPropertyDescriptor(PROP_HEIGHT, "height"),
//				  new MaskatTextPropertyDescriptor(PROP_WIDTH, "width"),
				  new MaskatTextPropertyDescriptor(PROP_TABINDEX, "tabIndex"),
				  new BooleanComboBoxPropertyDescriptor(PROP_ACTIFCLIC, "actifClic"),
//				  new MaskatTextPropertyDescriptor(PROP_AUTORESIZABLEH, "autoResizableH"),
//				  new MaskatTextPropertyDescriptor(PROP_AUTORESIZABLEW, "autoResizableW"),
//				  new MaskatTextPropertyDescriptor(PROP_AUTORESIZECONTENU, "autoResizeContenu"),
//				  new MaskatTextPropertyDescriptor(PROP_AUTORESIZEPARENT, "autoResizeParent"),
				  new BooleanComboBoxPropertyDescriptor(PROP_BNAVIG, "bNavig"),
				  new BooleanComboBoxPropertyDescriptor(PROP_BOOLPRINT, "boolPrint"),
				  new BooleanComboBoxPropertyDescriptor(PROP_CELLACTIVE, "cellActive"),
				  new BooleanComboBoxPropertyDescriptor(PROP_DRAGGABLE, "draggable"),
				  new MaskatTextPropertyDescriptor(PROP_LINEHEIGHT, "lineHeight"),
				  new BooleanComboBoxPropertyDescriptor(PROP_MULTISELECT, "multiSelect"),
//				  new MaskatTextPropertyDescriptor(PROP_PRINTTITLE, "printTitle"),
//				  new MaskatComboBoxPropertyDescriptor(PROP_POSITION, "position", ComboBoxLabelConstants.POSITION),
				  new MaskatTextPropertyDescriptor(PROP_RANG, "rang"),
				  new BooleanComboBoxPropertyDescriptor(PROP_SORTABLE, "sortable"),
				  new MaskatTextPropertyDescriptor(PROP_SORTCOL, "sortCol"),
				  new MaskatComboBoxPropertyDescriptor(PROP_SORTTYPE, "sortType", ComboBoxLabelConstants.GRID_SORTTYLE),
				  new BooleanComboBoxPropertyDescriptor(PROP_SWITCHABLE, "switchable"),
				  new MaskatTextPropertyDescriptor(PROP_WIDTHLASTCELL, "widthLastCell"),
				  new MaskatTextPropertyDescriptor(PROP_ONCELLEDIT, "onCellEdit"),
				  new BooleanComboBoxPropertyDescriptor(PROP_WRITABLE, "writable")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    propMap.put(PROP_TOP, "top");
	    propMap.put(PROP_LEFT, "left");
	    propMap.put(PROP_HEIGHT, "height");
	    propMap.put(PROP_ACTIFCLIC, "actifClic");
//	    propMap.put(PROP_AUTORESIZABLEH, "autoResizableH");
//	    propMap.put(PROP_AUTORESIZABLEW, "autoResizableW");
//	    propMap.put(PROP_AUTORESIZECONTENU, "autoResizeContenu");
//	    propMap.put(PROP_AUTORESIZEPARENT, "autoResizeParent");
	    propMap.put(PROP_BNAVIG, "bNavig");
	    propMap.put(PROP_BOOLPRINT, "boolPrint");
	    propMap.put(PROP_CELLACTIVE, "cellActive");
	    propMap.put(PROP_DRAGGABLE, "draggable");
	    propMap.put(PROP_LINEHEIGHT, "lineHeight");
	    propMap.put(PROP_MULTISELECT, "multiSelect");
//	    propMap.put(PROP_POSITION, "position");
	    propMap.put(PROP_RANG, "rang");
	    propMap.put(PROP_SORTABLE, "sortable");
	    propMap.put(PROP_SORTCOL, "sortCol");
	    propMap.put(PROP_SORTTYPE, "sortType");
	    propMap.put(PROP_SWITCHABLE, "switchable");
	    propMap.put(PROP_TABINDEX, "tabIndex");
//	    propMap.put(PROP_WIDTH, "width");
	    propMap.put(PROP_WIDTHLASTCELL, "widthLastCell");
	    propMap.put(PROP_ONCELLEDIT, "onCellEdit");
	    propMap.put(PROP_WRITABLE, "writable");
	    //	    propMap.put(PROP_PRINTTITLE, "printTitle");

	}
}
