/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.TabFolder;
import org.maskat.ui.views.properties.descriptor.BooleanComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.ComboBoxLabelConstants;
import org.maskat.ui.views.properties.descriptor.MaskatComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class TabFolderPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";
	
	public static final String PROP_LEFT = "_prop_left_";
	
	public static final String PROP_TOP = "_prop_top_";
	
	public static final String PROP_WIDTH = "_prop_width_";
	
	public static final String PROP_HEIGHT = "_prop_height_";
	
	public static final String PROP_AUTOREDIMTAB = "_prop_autoRedimTab_";
	
	public static final String PROP_AUTORESIZABLEH = "_prop_autoResizableH_";
	
	public static final String PROP_AUTORESIZABLEW = "_prop_autoResizableW_";
	
	public static final String PROP_AUTORESIZEPARENT = "_prop_autoResizeParent_";

	public static final String PROP_AUTORESIZECONTENU = "_prop_autoResizeContenu_";
	
	public static final String PROP_DRAGGABLE = "_prop_draggable_";
	
	public static final String PROP_DRAGGABLEITEM = "_prop_draggableItem_";
	
	public static final String PROP_ENABLE = "_prop_enable_";
	
	public static final String PROP_ISCLOSABLE = "_prop_isClosable_";
	
	public static final String PROP_NOACTIVETAB = "_prop_noActiveTab_";
	
	public static final String PROP_ORIENTATION = "_prop_orientation_";
	
	public static final String PROP_POSITION = "_prop_position_";
	
	public static final String PROP_TABINDEX = "_prop_tabIndex_";
	
	public static final String PROP_WIDTHTABNAME = "_prop_widthTabName_";

	public TabFolderPropertySource(TabFolder tabFolder) {
		super(tabFolder);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				  new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				  new MaskatTextPropertyDescriptor(PROP_WIDTH, "width"),
				  new MaskatTextPropertyDescriptor(PROP_HEIGHT, "height"),
				  new MaskatTextPropertyDescriptor(PROP_TABINDEX, "tabIndex"),
//				  new MaskatTextPropertyDescriptor(PROP_ENABLE, "enable"),
				  new BooleanComboBoxPropertyDescriptor(PROP_AUTORESIZABLEH, "autoResizableH"),
				  new BooleanComboBoxPropertyDescriptor(PROP_AUTORESIZABLEW, "autoResizableW"),
//				  new MaskatTextPropertyDescriptor(PROP_AUTORESIZEPARENT, "autoResizeParent"),
//				  new MaskatTextPropertyDescriptor(PROP_AUTORESIZECONTENU, "autoResizeContenu"),
				  new BooleanComboBoxPropertyDescriptor(PROP_DRAGGABLE, "draggable"),
				  new BooleanComboBoxPropertyDescriptor(PROP_DRAGGABLEITEM, "draggableItem"),
				  new BooleanComboBoxPropertyDescriptor(PROP_ISCLOSABLE, "isClosable"),
				  new MaskatTextPropertyDescriptor(PROP_NOACTIVETAB, "noActiveTab"),
				  new MaskatComboBoxPropertyDescriptor(PROP_ORIENTATION, "orientation", ComboBoxLabelConstants.TABFOLDER_ORIENTATION),
//				  new MaskatComboBoxPropertyDescriptor(PROP_POSITION, "position", ComboBoxLabelConstants.POSITION),
				  new BooleanComboBoxPropertyDescriptor(PROP_AUTOREDIMTAB, "autoRedimTab"),
				  new MaskatTextPropertyDescriptor(PROP_WIDTHTABNAME, "widthTabName")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    propMap.put(PROP_LEFT, "left");
	    propMap.put(PROP_TOP, "top");
	    propMap.put(PROP_WIDTH, "width");
	    propMap.put(PROP_HEIGHT, "height");
	    propMap.put(PROP_AUTOREDIMTAB, "autoRedimTab");
//	    propMap.put(PROP_AUTORESIZABLEH, "autoResizableH");
//	    propMap.put(PROP_AUTORESIZABLEW, "autoResizableW");
//	    propMap.put(PROP_AUTORESIZEPARENT, "autoResizeParent");
//	    propMap.put(PROP_AUTORESIZECONTENU, "autoResizeContenu");
	    propMap.put(PROP_DRAGGABLE, "draggable");
	    propMap.put(PROP_DRAGGABLEITEM, "draggableItem");
//	    propMap.put(PROP_ENABLE, "enable");
	    propMap.put(PROP_ISCLOSABLE, "isClosable");
	    propMap.put(PROP_NOACTIVETAB, "noActiveTab");
	    propMap.put(PROP_ORIENTATION, "orientation");
//	    propMap.put(PROP_POSITION, "position");
	    propMap.put(PROP_TABINDEX, "tabIndex");
	    propMap.put(PROP_WIDTHTABNAME, "widthTabName");

	}
}
