/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.descriptor;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * テキストプロパティディスクリプタ、nullの値は許容するようになる
 */
public class MaskatTextPropertyDescriptor extends TextPropertyDescriptor {
	
	public MaskatTextPropertyDescriptor(Object id, String displayName) {
		super(id, displayName);
		setCategory(Category.getCategory(displayName));
	}
	
	public CellEditor createPropertyEditor(Composite parent) {
		CellEditor editor = new MaskatTextCellEditor(parent);
		if (getValidator() != null) {
			editor.setValidator(getValidator());
		}
		return editor;
	}

	private static class MaskatTextCellEditor extends TextCellEditor {
		public MaskatTextCellEditor(Composite parent) {
			super(parent);
		}

		protected void doSetValue(Object value) {
			if (value == null) {
				// nullであれば、空白文字列をエディターに表示
				value = "";
			}
			super.doSetValue(String.valueOf(value));
		}

		protected Object doGetValue() {
			Object value = super.doGetValue();
			if ("".equals(value)) {
				// エディターの値は空白の文字列であれば、nullとして扱う
				return null;
			}
			return value;
		}
	}
}
