/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.tabbed.masterdetails;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import org.maskat.core.event.Target;
import org.maskat.ui.Messages;
import org.maskat.ui.views.properties.tabbed.beanwrapper.TargetChildNode;
import org.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

public class TargetChildNodeDetailsPage extends AbstractMaskatDetailsPage {

	private static final String SECTION_TEXT = Messages
			.getString("targetChildNodeDetails.sectionText"); //$NON-NLS-1$

	private static final String DESCRIPTION = Messages
			.getString("targetChildNodeDetails.description"); //$NON-NLS-1$

	// private Section inKeySection;
	private Text nodeNameText;

	private Target target;

	TargetChildNodeDetailsPage(TreeViewer masterBlockTreeViewer) {
		this.masterBlockTreeViewer = masterBlockTreeViewer;
	}

	public void createContents(Composite parent) {
		TableWrapLayout layout = new TableWrapLayout();
		layout.topMargin = 0;
		layout.leftMargin = 5;
		layout.rightMargin = 5;
		layout.bottomMargin = 5;
		parent.setLayout(layout);

		FormToolkit toolkit = managedForm.getToolkit();

		Section inKeySection = toolkit.createSection(parent,
				ExpandableComposite.TITLE_BAR | Section.DESCRIPTION);
		inKeySection.setText(SECTION_TEXT);
		inKeySection.setDescription(DESCRIPTION);
		TableWrapData tableWrapData = new TableWrapData(TableWrapData.FILL,
				TableWrapData.TOP);
		tableWrapData.grabHorizontal = true;
		inKeySection.setLayoutData(tableWrapData);

		Composite inKeyComposite = toolkit.createComposite(inKeySection);

		inKeyComposite.setLayout(new GridLayout(3, false));

		toolkit.createLabel(inKeyComposite, Messages
				.getString("targetChildNodeDetails.nodeNameLabel")); //$NON-NLS-1$
		toolkit.createLabel(inKeyComposite, ":");
		nodeNameText = toolkit.createText(inKeyComposite, "", SWT.SINGLE
				| SWT.BORDER);
		nodeNameText.setLayoutData(new GridData(SWT.FILL, 0, true, false));

		nodeNameText.addKeyListener(new KeyAdapter() {

			private int oldCaretPosition;

			public void keyReleased(KeyEvent e) {
				if (!nodeNameText.equals("")) {
					if (target.getInkey() == null
							|| !target.getInkey()
									.equals(nodeNameText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								TargetChildNode.class, target, "inkey",
								nodeNameText.getText());
					}
				} else {
					if (target.getInkey() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								TargetChildNode.class, target, "inkey", null);
					}
				}
				oldCaretPosition = nodeNameText.getCaretPosition();
				updateTreeViewer();
				nodeNameText.setSelection(oldCaretPosition);
			}
		});

		nodeNameText.addFocusListener(new FocusAdapter() {

			public void focusLost(FocusEvent e) {
				if (!nodeNameText.equals("")) {
					if (target.getInkey() == null
							|| !target.getInkey()
									.equals(nodeNameText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								TargetChildNode.class, target, "inkey",
								nodeNameText.getText());
						updateTreeViewer();
					}
				} else {
					if (target.getInkey() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								TargetChildNode.class, target, "inkey", null);
						updateTreeViewer();
					}
				}
			}
		});

		inKeySection.setClient(inKeyComposite);
	}

	public void update() {
		if (target.getInkey() != null) {
			nodeNameText.setText(target.getInkey());
		} else {
			nodeNameText.setText("");
		}
	}

	public void setTarget(Target target) {
		this.target = target;
	}

	protected void initializeInterface() {
		update();
		setDirtyFlag(false);
	}

	private void updateTreeViewer() {
		ITreeNode treeNode = EventPropertiesMasterDetailsBlock.getTreeNode(
				target, TargetChildNode.class);
		if (treeNode != null) {
			masterBlockTreeViewer.update(treeNode, null);
			masterBlockTreeViewer.setSelection(
					new StructuredSelection(treeNode), true);
		}
	}

}
