﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace mdc5linker
{
    public partial class imageselecter : Form
    {
        Interface.Konfig m_config;
        readonly Dictionary<string, int> m_capacity_dictionary;
        MenuItem[] rom_submenu_make(int config_romcapacity, out Dictionary<string, int> d)
        {
            string [] capacity = {
                "&Auto", "&512Kbit", 
                "&1Mbit", "&2Mbit", "&4Mbit", "&8Mbit"
            };
            MenuItem [] item = new MenuItem[capacity.Length];
            d = new Dictionary<string,int>();
            for(int i = 0; i < capacity.Length; i++){
                item[i] = new MenuItem(capacity[i], new EventHandler(romcapacity_Click));
                item[i].RadioCheck = true;
            }
            d[capacity[0]] = 0;
            int found_index = 0;
            int val = 0x10000;
            for(int i = 1; i < capacity.Length; i++){
                d[capacity[i]] = val;
                if(config_romcapacity == val){
                    found_index = i;
                }
                val *= 2;
            }
            item[found_index].Checked = true;
            return item;
        }
        MainMenu main_menu_make(int config_romcapacity, out Dictionary<string, int> d)
        {
            MenuItem file_config = new MenuItem("&Config", new EventHandler(for_candidate_Click));
            MenuItem file_rescan = new MenuItem("&Rescan", new EventHandler(list_reset));
            MenuItem file_hashlist = new MenuItem("&Hashlist output", new EventHandler(hashlist_output));
            MenuItem file_exit = new MenuItem("E&xit", new EventHandler(to_Dispose));
            MenuItem file = new MenuItem("&File", new MenuItem[]{/*file_config,*/ file_rescan, file_hashlist, file_exit});
            MenuItem rom_capacity = new MenuItem("&ROM capacity", rom_submenu_make(config_romcapacity, out d));
            MenuItem help_keyassign = new MenuItem("&Key Assign", new EventHandler(show_keyassign));
            MenuItem help = new MenuItem("&Help", new MenuItem[]{help_keyassign});
            return new MainMenu(new MenuItem[]{file, rom_capacity, help});
        }
        public imageselecter(Interface.Konfig c)
        {
            m_config = c;
            InitializeComponent();
            candidate.KeyPress += new KeyPressEventHandler(this.candidate_KeyPress);
            candidate.DoubleClick += new EventHandler(this.candidate_DoubleClick);
            selected_image.KeyDown += new KeyEventHandler(this.selected_image_KeyDown);
            this.MaximizeBox = false;
            this.DesktopLocation = c.WindowPostion;
            this.Menu = main_menu_make(m_config.RomCapacity, out m_capacity_dictionary);
            this.check_bin.Checked = m_config.OutputBin;
            this.check_nes.Checked = m_config.OutputNes;
            for_candidate.Text = "変換可能イメージ";
            for_selectedimage.Text = "選択されたイメージ";
            log.Text = ToMain.VERSION;
            log.Font = new Font(c.LogFont, log.Font.Size);
            list_reset(this, null);
        }
        public void list_reset(object sender, EventArgs e)
        {
            candidate.Reset();
            selected_image.Reset();
            output_name.Text = "";
            Interface.Scanner s = new Interface.Scanner();
            log.Subscribe(s);
            if(s.DiskimageFind(m_config.PathGet("diskimage.in"), false) == true){
                mdc5.Script [] script_list;
                if(s.ScriptFind(m_config.PathGet("diskscript.in"), out script_list) == true){
                    candidate.ScriptSet(script_list);
                }
            }
        }
        void dispose()
        {
            m_config.WindowPostion = this.DesktopLocation;
            m_config.OutputBin = this.check_bin.Checked;
            m_config.OutputNes = this.check_nes.Checked;
            m_config.FileSave();
        }

        private void candidate_KeyPress(object sender, EventArgs e)
        {
            KeyPressEventArgs key = (KeyPressEventArgs) e;
            if(key.KeyChar == '\r'){
                selected_image_add(sender);
            }
        }
        private void candidate_DoubleClick(object sender, EventArgs e)
        {
            //MouseEventArgs mouse = (MouseEventArgs) e;
            selected_image_add(sender);
        }

        private void selected_image_add(object sender)
        {
            Candinate c = (Candinate) sender;
            if(c.SelectedIndex != -1){
                mdc5.Script sc = candidate.ScriptGet(c.SelectedIndex);
                selected_image.ScriptAdd(sc);
                output_name.Text = selected_image.OutputNameGet();
            }
            if(selected_image.Count != 0){
                link_button.Enabled = true;
            }
        }

        private void selected_image_KeyDown(object sender, EventArgs e)
        {
            if(selected_image.ToKeyDown((KeyEventArgs) e) == true){
                output_name.Text = selected_image.OutputNameGet();
            }
            if (selected_image.Count == 0){
                link_button.Enabled = false;
            }
        }

        private void for_candidate_Click(object sender, EventArgs e)
        {
            log.Append("未実装");
            for_candidate.Focus();
        }
        private void hashlist_output(object sender, EventArgs e)
        {
            Interface.Scanner s = new Interface.Scanner();
            log.Subscribe(s);
            s.HashlistFileOut(m_config.PathGet("diskimage.in"), m_config.PathGet("diskscript.in") + "/hashlist.txt");
        }

        void romcapacity_Click(object sender, EventArgs e)
        {
            MenuItem m = (MenuItem) sender;
            for(int i = 0; i < m.Parent.MenuItems.Count; i++){
                m.Parent.MenuItems[i].Checked = false;
            }
            m.Checked = true;
            m_config.RomCapacity = m_capacity_dictionary[m.Text];
        }
        void show_keyassign(object sender, EventArgs e)
        {
            log.Append("left list:");
            log.Append("\t[Enter] append left list");
            log.Append("right list:");
            log.Append("\t[Delete] delete");
            log.Append("\t[Shift+Up] or [Shift+Down] change list order");
        }
        private void to_Dispose(object sender, EventArgs e)
        {
            this.Dispose(true);
        }
        private void link_button_Click(object sender, EventArgs e)
        {
            link_button.Enabled = false;
            mdc5.GameImage m = new mdc5.GameImage();
            log.Subscribe(m);
            m.BatchLink(
                    m_config, selected_image.ScriptGet(),
                    output_name.Text, check_bin.Checked, check_nes.Checked, true
            );
            link_button.Enabled = true;
        }
    }
}
