﻿using System;
using System.Text;
using System.Diagnostics;

namespace imagefile{
	class Nes{
		static readonly byte [] HEADER = {
			(byte)'N', (byte)'E', (byte)'S', 0x1a, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0
		};
		byte [] m_cpu_rom, m_ppu_rom;
		int m_cpu_ram_size;
		mapper m_mappernum;
		public enum mapper : byte{
			NROM = 0, SxROM, UxROM, CxROM, TxROM, ExROM,
			MAX
		};
		const int MBIT = 0x20000;
/*		public Nes(){
		}*/
		static readonly int [] CPU_ROMSIZE = {
			0x4000, 0x8000, 0x10000,
			1 * MBIT, 2 * MBIT, 4 * MBIT, 8 * MBIT
		};
		static readonly int [] PPU_ROMSIZE = {
			0, 0x2000, 0x4000, 0x8000, 0x10000,
			1 * MBIT, 2 * MBIT, 4 * MBIT, 8 * MBIT
		};
		bool rom_set(int [] oksize, byte [] input, out byte [] output){
			foreach(int t in oksize){
				if(t == input.Length){
					//output = new byte [t];
					//input.CopyTo(output, 0);
					output = input;
					return true;
				}
			}
			output = new byte [0];
			return false;
		}
		static readonly int [] CPU_RAMSIZE = {
			0, 
			0x2000, //6264x1:[ST]NROM, TSROM, [STE][KL]ROM
			0x4000*2, //6264x2:SOROM, ETROM
			0x8000, //62256x1: SXROM, EWROM
			//0x8000 + 0x2000, //ETROM for MDC5 personal NES ヘッダ規定外なのでエミュレータ上では debug を使う
			0x8000*2 //62256x2: ETROM for MDC5 debug
		};
		bool ram_set(int [] oksize, int input, out int output){
			foreach(int t in oksize){
				if(t == input){
					output = t;
					return true;
				}
			}
			output = 0;
			return false;
		}
		public bool ImageSet(byte [] cpu_rom, int cpu_ram_size, byte [] ppu_rom, mapper mappernum)
		{
			if(rom_set(CPU_ROMSIZE, cpu_rom, out m_cpu_rom) == false){
				return false;
			}
			if(ram_set(CPU_RAMSIZE, cpu_ram_size, out m_cpu_ram_size) == false){
				return false;
			}
			if(rom_set(PPU_ROMSIZE, ppu_rom, out m_ppu_rom) == false){
				return false;
			}
			if(mappernum >= mapper.MAX){
				return false;
			}
			m_mappernum = mappernum;
			return true;
		}
		int header_get(int cpu_rom_size, int cpu_ram_size, int ppu_rom_size, int mappernum, out byte [] header){
			header = HEADER;
			header[4] = (byte) (cpu_rom_size / 0x4000);
			header[5] = (byte) (ppu_rom_size / 0x2000);
			/*if(cpu_ram_size != 0){
				//battery-backup flag set
				//これは RAMSIZE とは直結しないのだが、便宜上これで.
				header[6] = 2;
			}else{
				header[6] = 0;
			}*/
			header[6] = 0;
			header[6] |= (byte) (mappernum << 4); //byte 型での shift 演算を受け付けないので mappernum の型を int にした
			header[8] = (byte) (cpu_ram_size / 0x2000);
			return header.Length + cpu_rom_size + ppu_rom_size;
		}
		public byte [] ImageGet(){
			byte [] header;
			int imagesize = header_get(
				m_cpu_rom.Length, m_cpu_ram_size, m_ppu_rom.Length, 
				(int) m_mappernum, out header
			);
			byte [] image = new byte[imagesize];
			int offset = 0;
			
			header.CopyTo(image, offset);
			offset += header.Length;
			m_cpu_rom.CopyTo(image, offset);
			offset += m_cpu_rom.Length;
			m_ppu_rom.CopyTo(image, offset);
			offset += m_ppu_rom.Length;
			return image;
		}
	}
}

