using System;
using System.Text;
using System.Security.Cryptography;
using System.Diagnostics;
using System.Collections.Generic;

namespace mdc5{
	struct SaveArgument{
		public string Name{
			get; set;
		}
		public int Side{
			get; set;
		}
		public int Length{
			get; set;
		}
		public int Offset{
			get; set;
		}
	}
	class GameImage : Interface.Logput
	{
		imagefile.GameImage[] m_gameimage;
		Bios m_biosimage;
		
		public GameImage()
		{
			//Debug.Assert(PAGESIZE == (Manage.SIZE + Bios.EXTRA_SIZE));
		}
		
		bool BiosLoad(string rom_image, string rom_patch)
		{
			{
				byte [] bios;
				if(Static.Utility.binary_load(rom_image, out bios) == false){
					OnLogAdd(rom_image + " open error!");
					return false;
				}
				m_biosimage = new Bios();
				if(m_biosimage.rom_load(bios) == false){
					OnLogAdd(rom_image + " checksum error!");
					return false;
				}
			}
			{
				string [] recoard;
				if(Static.Utility.text_load(rom_patch, out recoard) == false){
					OnLogAdd(rom_patch + " open error!");
					return false;
				}
				if(m_biosimage.patch_load(recoard) == false){
					OnLogAdd(rom_patch + " recoard syntax error!");
					return false;
				}
			}
			return true;
		}
		bool image_load(mdc5.Script script, bool do_patch, bool patchlog, imagefile.GameImage g)
		{
			if(g.Load(script) == false){
				OnLogAdd(script.ImageFilename + " open error!");
				return false;
			}

			if(script.PatchData.Length != 0 && do_patch == true){
				if(patchlog == true){
					OnLogAdd("patching " + script.GameCode + "...");
				}
				foreach(RomRecoard.MotorolaSRecoard t in script.PatchData){
					string log;
					if(t.Valid == true){
						if(g.PatchManual(t, out log) != imagefile.GameImage.patchresult.OK){
							OnLogAdd(log);
							return false;
						}
						if(patchlog == true){
							OnLogAdd(log);
						}
					}
				}
			}
			if((g.Type == mdc5.Script.imagetype.disk) && (do_patch == true)){
				string [] log;
				g.PatchAuto(out log);
				if(patchlog == true){
					OnLogAdd(log);
				}
			}
			return true;
		}

		bool ImageLoad(mdc5.Script [] image, bool do_patch, bool patchlog)
		{
			List<imagefile.GameImage> gameimage = new List<imagefile.GameImage>();
			foreach(mdc5.Script t in image){
				switch(t.ImageType){
				case mdc5.Script.imagetype.disk:{
					imagefile.Fds fds = new imagefile.Fds();
					if(image_load(t, do_patch, patchlog, fds) == false){
						return false;
					}
					gameimage.Add(fds);
					}break;
				case mdc5.Script.imagetype.rom:{
					imagefile.Nes nes = new imagefile.Nes();
					if(image_load(t, do_patch, patchlog, nes) == false){
						return false;
					}
					gameimage.Add(nes);
					}break;
				default:
					break;
				}
			}
			m_gameimage = gameimage.ToArray();
			return true;
		}

		public bool BatchLink(Interface.Konfig c, mdc5.Script [] s, string output_prefix, bool do_patch, bool patchlog)
		{
			string rom_image = c.PathGet("romimage.in") + "/disksys.rom";
			string rom_patch = c.PathGet("rompatch.in") + "/bios.sr";
			if(BiosLoad(rom_image, rom_patch) == false){
				return false;
			}
			if(ImageLoad(s, do_patch, patchlog) == false){
				return false;
			}
			Debug.Assert(m_gameimage != null);
			Debug.Assert(m_biosimage != null);
			Debug.Assert((c.RomCapacity % hardware.mmc5.PAGESIZE) == 0);
			imagestream.Manage m = new imagestream.Manage(c.RomCapacity, 0x2000, c.RamCapacity);
			string fileprefix = c.PathGet("romimage.out") + "/" + output_prefix;

			m.GameimageSet(m_gameimage);
			byte [] rom = null;
			{
				string [] linklog;
				bool linkresult = m.Link(m_biosimage.RomBottom, m_biosimage.RomExtra, out rom, out linklog);
				OnLogAdd(linklog);
				if(linkresult == false){
					return false;
				}
			}
			if(c.OutputBin == true){
				string file = fileprefix + ".bin";
				Static.Utility.binary_save(file, rom);
				OnLogAdd(file + " created.");
			}
			if(c.OutputNes == true){
				imagefile.Nes nes = new imagefile.Nes();
				byte [] ppurom = new byte[0];
				bool t = nes.ImageMake(rom, 0x8000*2, ppurom, imagefile.Nes.mapper.ExROM);
				Debug.Assert(t);
				string file = fileprefix + ".nes";
				Static.Utility.binary_save(file, nes.ImageGet());
				OnLogAdd(file + " created.");
			}
			
			return true;
		}
	}
	class Bios{
		const int FIX_TOP = 0xe000;
		const int EXTRA_TOP = 0xcc00;
		public const int EXTRA_SIZE = FIX_TOP - EXTRA_TOP; //0x1800;
		public const int MANAGE_SIZE = 0x2000 -  EXTRA_SIZE;
		readonly static byte [] BIOS_HASH = {
			0x57, 0xfe, 0x1b, 0xde, 0xe9, 0x55, 0xbb, 0x48, 
			0xd3, 0x57, 0xe4, 0x63, 0xcc, 0xbf, 0x12, 0x94, 
			0x96, 0x93, 0x0b, 0x62
		};
		byte [] m_rom_bottom, m_rom_extra;

		public byte [] RomBottom{
			get{return m_rom_bottom;}
		}
		public byte [] RomExtra{
			get{return m_rom_extra;}
		}
		public bool rom_load(byte [] rom)
		{
			SHA1CryptoServiceProvider sf = new SHA1CryptoServiceProvider();
			byte [] result = sf.ComputeHash(rom);
			Debug.Assert(result.Length == BIOS_HASH.Length);
			for(int i = 0; i < result.Length; i++){
				if(result[i] != BIOS_HASH[i]){
					return false;
				}
			}
			m_rom_bottom = rom;
			m_rom_extra = Static.Utility.memory_new_fill(EXTRA_SIZE, 0xff);
			return true;
		}
		void patch(RomRecoard.MotorolaSRecoard r, uint offset, ref byte [] data)
		{
			offset = r.Address - offset;
			for(int i = 0; i < r.Data.Length; i++){
				data[offset + i] = r.Data[i];
			}
		}
		public bool patch_load(string [] recoard)
		{
			foreach(string t in recoard){
				RomRecoard.MotorolaSRecoard r = new RomRecoard.MotorolaSRecoard(t);
				if(r.Error == true){
					return false;
				}
				if(r.Valid == false){
					continue;
				}
				uint address_end = r.Address + (uint) r.Data.Length - 1;
				if(r.Address >= FIX_TOP){
					if(address_end >= 0x10000){
						return false;
					}
					patch(r, FIX_TOP, ref m_rom_bottom);
				}else if(r.Address >= EXTRA_TOP){
					if(address_end >= 0xe000){
						return false;
					}
					patch(r, EXTRA_TOP, ref m_rom_extra);
				}else{
					return false;
				}
			}
			return true;
		}
	}
}
