using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Linq;

namespace mdc5linker
{
	class ScriptInfomation: TextBox
	{
		const string LIST_SYNTAX = "Type:{0,-4} Size:{1,7} Code:{2}\r\nVersion:{3}";
		public void Reset()
		{
			string showtext;
			showtext = "\r\n";
			showtext += String.Format(LIST_SYNTAX, "", "", "", "");
			this.Text = showtext;
		}
		public void ScriptSet(mdc5.Script script)
		{
            string capacity = String.Format("0x{0:x5}", script.UsingByte);
			string showtext;
			showtext = script.GameName + "\r\n";
			showtext += String.Format(
				LIST_SYNTAX,
				script.ImageType, capacity, script.GameCode, script.GameVersion
			);
			this.Text = showtext;
		}
	}
	class GuiList : ListBox
	{
		readonly ScriptInfomation m_infomation_box;
		protected List<mdc5.Script> m_script;

		public GuiList(ScriptInfomation infomation_box)
		{
			m_infomation_box = infomation_box;
		}

		public void ItemChanged()
		{
			if(SelectedIndex != -1){
				m_infomation_box.ScriptSet(m_script[SelectedIndex]);
			}
		}
		
		protected void reset()
		{
			while(this.Items.Count != 0){
				this.Items.RemoveAt(0);
			}
		}
	}
	class Candinate : GuiList
	{
		public Candinate(ScriptInfomation infomation_box) : base(infomation_box)
		{
			m_script = new List<mdc5.Script>();
		}

		public void ScriptAdd(mdc5.Script [] script)
		{
			foreach(mdc5.Script t in script){
				m_script.Add(t);
			}
		}
		public void ScriptOrder(Interface.Konfig.listorder order)
		{
			if(m_script.Count == 0){
				return;
			}
			IEnumerable<mdc5.Script> query;
			switch(order){
			case Interface.Konfig.listorder.name_imagetype:
				query = (
					from s in m_script
					orderby s.GameName, s.ImageType
					select s
				);
				break;
			case Interface.Konfig.listorder.imagetype_name:
				query = (
					from s in m_script
					orderby s.ImageType, s.GameName
					select s
				);
				break;
			case Interface.Konfig.listorder.imagetype_code:
				query = (
					from s in m_script
					orderby s.ImageType, s.GameCode
					select s
				);
				break;
			case Interface.Konfig.listorder.code:
				query = (
					from s in m_script
					orderby s.GameCode
					select s
				);
				break;
			default:
				Debug.Assert(false);
				return;
			}
			Reset();
			m_script = new List<mdc5.Script>(query);
			foreach(mdc5.Script t in m_script){
				this.Items.Add(t.GameName);
			}
		}
		public mdc5.Script ScriptGet(string field)
		{
			foreach(mdc5.Script t in m_script){
				if(t.GameName == field){
					return t;
				}
			}
			Debug.Assert(false);
			return null;
		}
		public mdc5.Script ScriptGet(int field)
		{
			return m_script[field];
		}
		public void Reset()
		{
			m_script = new List<mdc5.Script>();
			reset();
		}
	}
	class SelectedImage : GuiList
	{
		public int Count
		{
			get {return m_script.Count;}
		}

		public SelectedImage(ScriptInfomation infomation_box) : base(infomation_box)
		{
			m_script = new List<mdc5.Script>();
		}
		void swap(int dindex, ListBox display, ref List<mdc5.Script> list)
		{
			int oldindex = display.SelectedIndex;
			int newindex = display.SelectedIndex + dindex;
			if((newindex < 0) || (newindex >= display.Items.Count)){
				return;
			}
			//swap index
			{
				mdc5.Script temp = list[newindex];
				list[newindex] = list[oldindex];
				list[oldindex] = temp;
			}
			switch(dindex){
			case 1:
				display.Items.RemoveAt(oldindex);
				display.Items.Insert(newindex, list[newindex].GameName);
				break;
			case -1:
				display.Items.RemoveAt(newindex);
				display.Items.Insert(oldindex, list[oldindex].GameName);
				break;
			default:
				Debug.Assert(false);
				break;
			}
			display.SelectedIndex = oldindex;
		}

		//protected override void OnKeyDown(KeyEventArgs e)
		//list更新したら true を返す
		public bool ToKeyDown(KeyEventArgs e)
		{
			if(this.SelectedIndex == -1){
				return false;
			}
			int dindex = 0; //微分とかの d
			if((e.KeyData & Keys.Modifiers) == Keys.Shift){
				switch(e.KeyData & ~Keys.Modifiers){
				case Keys.Up:
					dindex = -1;
					break;
				case Keys.Down:
					dindex = 1;
					break;
				}
			}else if(e.KeyData == Keys.Delete){
				m_script.RemoveAt(this.SelectedIndex);
				this.Items.RemoveAt(this.SelectedIndex);
				return true;
			}
			if(dindex != 0){
				swap(dindex, this, ref m_script);
				return true;
			}
			return false;
		}
		public void ScriptAdd(mdc5.Script s)
		{
			m_script.Add(s);
			this.Items.Add(s.GameName);
		}
		
		public mdc5.Script []ScriptGet()
		{
			return m_script.ToArray();
		}
		public void Reset()
		{
			m_script = new List<mdc5.Script>();
			reset();
		}
		public string OutputNameGet()
		{
			if(m_script.Count == 0){
				return "";
			}
			return ConsoleLinker.AutoFilenameGet(m_script.ToArray());
		}
	}
}
