TARGET = \
	ann_nsm.mdc btc_rlc.mdc \
	dfc_juk.mdc dfc_kf12.mdc dfc_j4.mdc \
	fmc_tc12.mdc fmc_ppn.mdc fmc_thse.mdc fmc_smb.mdc \
	jfd_dfs.mdc jfd_ggb.mdc \
	kds_esp.mdc kds_aka.mdc kds_you.mdc kds_nzn.mdc kds_twn.mdc \
	kds_akm_v0.mdc kds_akm_v1.mdc \
	pnf_dan.mdc pnf_win.mdc ssd_dzn.mdc
#	ban_sg1.mdc \
#	sfc_fyt.mdc 
ADDRESS_RANGE = \$$6000-\$$dfff
TYPE = disk

include mdc.mk

#multi version specify for KDS-AKM
kds_akm_v0.o: kds_akm.s
	$(AS) -D version=0 -l -o $@ $< > $(subst .o,.lst,$@)
kds_akm_v1.o: kds_akm.s
	$(AS) -D version=1 -l -o $@ $< > $(subst .o,.lst,$@)
#filename specify for ANN-NSM
ann_nsm.o: ann_nsm.s
	$(AS) -D SOFTWARE=0 -L -o $@ $<
ann_nsm_main.mot: ann_nsm.o
	$(P2HEX) $< $@ -r \$$6000-\$$c5cf -F moto
ann_nsm_data.mot: ann_nsm.o
	$(P2HEX) $< $@ -r \$$c5d0-\$$dfff -F moto
ann_nsm.mdc: ../mdc/ann_nsm.mdt ann_nsm_main.mot ann_nsm_data.mot
	cat $(MDCDIR)/$(subst .mdc,.mdt,$@) > $@
	#
	printf "$(PATCH_PREFIX)file = NSMMAIN\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat ann_nsm_main.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	#
	printf "$(PATCH_PREFIX)file = NSMDATA3\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat ann_nsm_data.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	#
	cp $@ $(MDCDIR)

#for FMC-SMB
fmc_smb.o: ann_nsm.s
	$(AS) -D SOFTWARE=1 -l -o $@ $< > fmc_smb.lst
fmc_smb_main.mot: fmc_smb.o
	$(P2HEX) $< $@ -r \$$6000-\$$c5cf -F moto
fmc_smb_data.mot: fmc_smb.o
	$(P2HEX) $< $@ -r \$$c5d0-\$$dfff -F moto
fmc_smb.mdc: ../mdc/fmc_smb.mdt fmc_smb_main.mot fmc_smb_data.mot
	cat $(MDCDIR)/$(subst .mdc,.mdt,$@) > $@
	#
	printf "$(PATCH_PREFIX)file = SM2MAIN\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat fmc_smb_main.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	#
	printf "$(PATCH_PREFIX)file = SM2DATA3\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat fmc_smb_data.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	#
	cp $@ $(MDCDIR)

#address filter for SSD-DZN. range for disk1.sideA.DOS
ssd_dzn.mot: ssd_dzn.o
	$(P2HEX) $< $@ -r \$$0450-\$$067d -F moto
