	cpu	6502
	page	0
;---- bios workmemory ----
mdc5_sidechange_status	equ	$5c00

;---- bios function for diskgame ---
	org	$f400
mdc5_mirror_set_a:
	dfs	3
mdc5_diskside_change:
	dfs	3
mdc5_diskchange_input_read:
	dfs	3
mdc5_mirror_set_x:
	dfs	3
mdc5_mirror_set_y:
	dfs	3
mdc5_function_scanline_irq_enable:
	dfs	3
mdc5_function_scanline_irq_disable:
	dfs	3
mdc5_diskchange_update:
	dfs	3

;---- bios function for romgame ---
	org	$5e00
mdc5_function_romboot:
	dfs	3
mdc5_function_cpubank_switch_8000_2000:
	dfs	3
mdc5_function_cpubank_switch_a000_2000:
	dfs	3
mdc5_function_cpubank_switch_c000_2000:
	dfs	3
mdc5_function_cpubank_switch_e000_2000:
	dfs	3
mdc5_function_cpubank_switch_8000_4000:
	dfs	3
mdc5_function_cpubank_switch_c000_4000:
	dfs	3

;---- mmc5 charcter memory bank register for romgame ----
;$5101 == 0
	org	$5120
mmc5_ppubank_0000_0400:
	dfs	1
mmc5_ppubank_0400_0400:
	dfs	1
mmc5_ppubank_0800_0400:
	dfs	1
mmc5_ppubank_0c00_0400:
	dfs	1
mmc5_ppubank_1000_0400:
	dfs	1
mmc5_ppubank_1400_0400:
	dfs	1
mmc5_ppubank_1800_0400:
	dfs	1
mmc5_ppubank_1c00_0400:
	dfs	1
;$5101 == 1
	org	$5121
mmc5_ppubank_0000_0800:
	dfs	2
mmc5_ppubank_0800_0800:
	dfs	2
mmc5_ppubank_1000_0800:
	dfs	2
mmc5_ppubank_1800_0800:
	dfs	2
;$5101 == 2
	org	$5123
mmc5_ppubank_0000_1000:
	dfs	4
mmc5_ppubank_1000_1000:
	dfs	4
;$5102 == 3
mmc5_ppubank_0000_2000	equ	$5127
;---- inline macro ----
irq_counter	equ	$5203
irq_status	equ	$5204

mdc5_macro_scanline_irq_enable	macro	line
	lda	irq_status
	lda	#$80  ;bit7 1:IRQ enable, 0: IRQ disable
	sta	irq_status
	lda	#line
	sta	irq_counter
	endm
	
mdc5_macro_scanline_irq_disable	macro
	lda	irq_status
	lda	#0
	sta	irq_status
	endm
