#include "stdafx.h"

#include "Configuration.h"
#include "ConfStrage.h"
#include "ConfStrageEnumEntries.h"

HRESULT CConfStrage::FinalConstruct() throw()
{
	return S_OK;
}

HRESULT CConfStrage::Init(LPCWSTR v_pSectionName, LPCWSTR v_pIniFilePath) throw()
{
	if ( !v_pSectionName || !*v_pSectionName ||
		 !v_pIniFilePath || !*v_pIniFilePath) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}
	try {
		iniFilePath_ = v_pIniFilePath;
		sectionName_ = v_pSectionName;
	}
	catch (...) {
		ATLASSERT(false);
		return E_OUTOFMEMORY;
	}
	return S_OK;
}

void CConfStrage::FinalRelease() throw()
{
}

HRESULT __stdcall CConfStrage::GetInt(LPCWSTR v_pName, int v_default, int* v_pValue) throw()
{
	ATLASSERT( !iniFilePath_.IsEmpty());
	ATLASSERT( !sectionName_.IsEmpty());

	if ( !v_pValue) {
		return E_POINTER;
	}
	if ( !v_pName || !*v_pName) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	try {
		*v_pValue = ::GetPrivateProfileInt(
			sectionName_,
			CW2T(v_pName),
			v_default,
			iniFilePath_
			);
	}
	catch (...) {
		ATLASSERT(false);
		return E_FAIL;
	}

	return S_OK;
}

HRESULT __stdcall CConfStrage::WriteInt(LPCWSTR v_pName, int v_value) throw()
{
	ATLASSERT( !iniFilePath_.IsEmpty());
	ATLASSERT( !sectionName_.IsEmpty());

	if ( !v_pName || !*v_pName) {
		return E_INVALIDARG;
	}

	try {
		CAtlString tmp;
		tmp.Format(_TEXT("%d"), v_value);

		if ( !::WritePrivateProfileString(
				sectionName_,
				CW2T(v_pName),
				tmp,
				iniFilePath_
				)) {
			return AtlHresultFromLastError();
		}
	}
	catch (...) {
		ATLASSERT(false);
		return E_FAIL;
	}

	return S_OK;
}

HRESULT __stdcall CConfStrage::GetString(LPCWSTR v_pName, LPCWSTR v_pDefault, BSTR* v_pValue) throw()
{
	ATLASSERT( !iniFilePath_.IsEmpty());
	ATLASSERT( !sectionName_.IsEmpty());

	if ( !v_pValue) {
		ATLASSERT(false);
		return E_POINTER;
	}
	if ( !v_pName || !*v_pName) {
		return E_INVALIDARG;
	}
	ATLASSERT(*v_pValue == NULL);

	try {
		if ( !v_pDefault) {
			v_pDefault = L"";
		}

		int bufsiz = MAX_PATH;
		CAtlString buf;
		for (;;) {
			LPTSTR pBuf = buf.GetBufferSetLength(bufsiz);
			int ret = ::GetPrivateProfileString(
					sectionName_,
					CW2T(v_pName),
					CW2T(v_pDefault),
					pBuf,
					bufsiz,
					iniFilePath_
					);
			buf.ReleaseBuffer();
			if (ret == bufsiz - 1) {
				// obt@TCY
				bufsiz *= 2;
				continue;
			}
			break;
		}

		CComBSTR tmp((LPCWSTR) CT2W(buf));
		*v_pValue = tmp.Detach();
		return S_OK;
	}
	catch (const CAtlException& exception) {
		ATLASSERT(false);
		return exception.m_hr;
	}
	catch (...) {
		ATLASSERT(false);
		return E_FAIL;
	}
}

HRESULT __stdcall CConfStrage::WriteString(LPCWSTR v_pName, LPCWSTR v_pValue) throw()
{
	ATLASSERT( !iniFilePath_.IsEmpty());
	ATLASSERT( !sectionName_.IsEmpty());

	if ( !v_pName || !*v_pName) {
		return E_INVALIDARG;
	}

	try {
		if ( !v_pValue) {
			v_pValue = L"";
		}

		if( !::WritePrivateProfileString(
			sectionName_,
			CW2T(v_pName),
			CW2T(v_pValue),
			iniFilePath_
			)) {
			return AtlHresultFromLastError();
		}
	}
	catch (...) {
		ATLASSERT(false);
		return E_FAIL;
	}

	return S_OK;
}

HRESULT __stdcall CConfStrage::GetData(LPCWSTR v_pName, LPVOID v_pData, size_t v_siz) throw()
{
	ATLASSERT( !iniFilePath_.IsEmpty());
	ATLASSERT( !sectionName_.IsEmpty());

	if ( !v_pData) {
		ATLASSERT(false);
		return E_POINTER;
	}
	if ( !v_pName || !*v_pName) {
		return E_INVALIDARG;
	}

	try {
		if ( !::GetPrivateProfileStruct(
			sectionName_,
			CW2T(v_pName),
			v_pData,
			static_cast<UINT>(v_siz),
			iniFilePath_
			)) {
			return E_FAIL;
		}
	}
	catch (...) {
		ATLASSERT(false);
		return E_FAIL;
	}

	return S_OK;
}

HRESULT __stdcall CConfStrage::WriteData(LPCWSTR v_pName, LPVOID v_pData, size_t v_siz) throw()
{
	ATLASSERT( !iniFilePath_.IsEmpty());
	ATLASSERT( !sectionName_.IsEmpty());

	if ( !v_pData) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}
	if ( !v_pName || !*v_pName) {
		return E_INVALIDARG;
	}

	try {
		if ( !::WritePrivateProfileStruct(
			sectionName_,
			CW2T(v_pName),
			v_pData,
			static_cast<UINT>(v_siz),
			iniFilePath_
			)) {
			return AtlHresultFromLastError();
		}
	}
	catch (...) {
		ATLASSERT(false);
		return E_FAIL;
	}

	return S_OK;
}

HRESULT __stdcall CConfStrage::EnumEntries(IConfStrageEnumEntries** v_ppEnumEntries) throw()
{
	ATLASSERT( !iniFilePath_.IsEmpty());
	ATLASSERT( !sectionName_.IsEmpty());

	if ( !v_ppEnumEntries) {
		ATLASSERT(false);
		return E_POINTER;
	}

	ObjectLock lock(this);

	HRESULT hr;
	CComObject<CConfStrageEnumEntries>* pEnumEntriesImpl = NULL;
	hr = CComObject<CConfStrageEnumEntries>::CreateInstance(&pEnumEntriesImpl);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return hr;
	}
	CComPtr<IConfStrageEnumEntries> pEnumEntries(pEnumEntriesImpl);
	ATLASSERT(pEnumEntries);

	hr = pEnumEntriesImpl->Init(this);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return hr;
	}

	return pEnumEntries.CopyTo(v_ppEnumEntries);
}

HRESULT __stdcall CConfStrage::GetName(BSTR* v_pName) throw()
{
	if ( !v_pName) {
		return E_POINTER;
	}

	try {
		ATLASSERT(!*v_pName);
		*v_pName = ::SysAllocString(CT2W(sectionName_));
		return S_OK;
	}
	catch (const CAtlException& exception) {
		return exception.m_hr;
	}
	catch (...) {
		return E_FAIL;
	}
}
