#include "stdafx.h"

#include "Configuration.h"
#include "ConfStrageDir.h"
#include "ConfStrageDirEnumStrages.h"

HRESULT CConfStrageDirEnumStrages::FinalConstruct() throw()
{
	return S_OK;
}

void CConfStrageDirEnumStrages::FinalRelease() throw()
{
	pConfStrageDir_.Release();
}

HRESULT CConfStrageDirEnumStrages::Init(CConfStrageDir* v_pConfStrageDir) throw()
{
	if ( !v_pConfStrageDir) {
		ATLASSERT(false);
		return E_FAIL;
	}

	try {
		pConfStrageDir_ = v_pConfStrageDir;

		const CSectionMap& sectionMap = v_pConfStrageDir->sectionMap_;
		POSITION pos = sectionMap.GetHeadPosition();
		while (pos) {
			const CSectionMap::CPair* pair = sectionMap.GetNext(pos);
			sectionMap_.SetAt(pair->m_key, pair->m_value);
		}

		pos_ = sectionMap_.GetHeadPosition();
	}
	catch (...) {
		ATLASSERT(false);
		return E_FAIL;
	}
	return S_OK;
}

/// IConfStrageDirEnumStrages ///

HRESULT __stdcall CConfStrageDirEnumStrages::Next(BSTR* v_pName, IConfStrage** v_ppStrage) throw()
{
	ATLASSERT(pConfStrageDir_);

	try {
		if (v_pName) {
			ATLASSERT(!*v_pName);
			*v_pName = NULL;
		}
		if (v_ppStrage) {
			ATLASSERT(!*v_ppStrage);
			*v_ppStrage = NULL;
		}

		if ( !pos_) {
			// I[ɒB
			return S_FALSE;
		}
		
		const CSectionMap::CPair* pair = sectionMap_.GetNext(pos_);
		ATLASSERT(pair);

		if (v_pName) {
			CComBSTR name(pair->m_key);
			*v_pName = name.Detach();
		}

		if (v_ppStrage) {
			HRESULT hr;
			CComPtr<IConfStrage> pConfStrage(pair->m_value);
			hr = pConfStrage.CopyTo(v_ppStrage);
			if (FAILED(hr)) {
				return hr;
			}
		}

		return S_OK;
	}
	catch (const CAtlException& exception) {
		ATLASSERT(false);
		return exception.m_hr;
	}
	catch (...) {
		ATLASSERT(false);
		return E_FAIL;
	}
}
