#include "stdafx.h"
#include "resource.h"

#include <htmlhelp.h>
#include <shellapi.h>

#include "SettingDlg.h"
#include "../lib/Configuration.h"

CSettingDlg::CSettingDlg(void)
{
}

CSettingDlg::~CSettingDlg(void)
{
}

HRESULT CSettingDlg::SetSetting(ISetting* v_pSetting) throw()
{
	ATLASSERT(v_pSetting);
	try {
		pSetting_ = v_pSetting;
		return S_OK;
	}
	catch (...) {
		return E_FAIL;
	}
}

HRESULT CSettingDlg::GetSetting(ISetting** v_ppSetting) throw()
{
	return pSetting_.CopyTo(v_ppSetting);
}

HRESULT CSettingDlg::SetURLLimitSuggest(IHTMLLinkCollector* v_pLinkCollector) throw()
{
	try {
		pLinkCollector_ = v_pLinkCollector;
	}
	catch (...) {
		return E_FAIL;
	}
	return S_OK;
}

HRESULT CSettingDlg::GetURLLimitSuggest(IHTMLLinkCollector** v_ppLinkCollector) throw()
{
	return pLinkCollector_.CopyTo(v_ppLinkCollector);
}

HRESULT CSettingDlg::SetTemplateConfigCollection(ITemplateConfigCollection* v_pTemplateConfigCollection) throw()
{
	try {
		pTemplateConfigCollection_ = v_pTemplateConfigCollection;
	}
	catch (...) {
		return E_FAIL;
	}
	return S_OK;
}

HRESULT CSettingDlg::GetTemplateConfigCollection(ITemplateConfigCollection** v_ppTemplateConfigCollection) throw()
{
	return pTemplateConfigCollection_.CopyTo(v_ppTemplateConfigCollection);
}

void CSettingDlg::UpdateAllItems(void) throw()
{
	ATLASSERT(pSetting_);

	CheckDlgButton(IDC_IMG_LINK,
		(pSetting_->is_ImgLink() == S_OK) ? BST_CHECKED : BST_UNCHECKED);
	
	CComBSTR tmp;
	if (SUCCEEDED(pSetting_->get_ImgLink_Ext(&tmp))){
		SetDlgItemText(IDC_IMG_LINK_EXT, CW2T(tmp));
	}
	
	CheckDlgButton(IDC_IMG,
		(pSetting_->is_Img() == S_OK) ? BST_CHECKED : BST_UNCHECKED);

	tmp.Empty();
	if (SUCCEEDED(pSetting_->get_Img_Ext(&tmp))) {
		SetDlgItemText(IDC_IMG_EXT, CW2T(tmp));
	}

	CheckDlgButton(IDC_IMG_SIZE,
		(pSetting_->is_Img_Size() == S_OK) ? BST_CHECKED : BST_UNCHECKED);

	UINT imgWidth;
	if (SUCCEEDED(pSetting_->get_Img_Width(&imgWidth))) {
		CString strImgWidth;
		strImgWidth.Format(_TEXT("%lu"), imgWidth);
		SetDlgItemText(IDC_IMG_WIDTH, strImgWidth);
	}

	UINT imgHeight;
	if (SUCCEEDED(pSetting_->get_Img_Height(&imgHeight))) {
		CString strImgHeight;
		strImgHeight.Format(_TEXT("%lu"), imgHeight);
		SetDlgItemText(IDC_IMG_HEIGHT, strImgHeight);
	}

	CheckDlgButton(IDC_URL_LINK,
		(pSetting_->is_URLLink() == S_OK) ? BST_CHECKED : BST_UNCHECKED);

	tmp.Empty();
	if (SUCCEEDED(pSetting_->get_URLLink_Ext(&tmp))) {
		SetDlgItemText(IDC_URL_LINK_EXT, CW2T(tmp));
	}

	UINT frmWidth;
	if (SUCCEEDED(pSetting_->get_IFrame_Width(&frmWidth))) {
		CString strFrmWidth;
		strFrmWidth.Format(_TEXT("%lu"), frmWidth);
		SetDlgItemText(IDC_IFRAME_WIDTH, strFrmWidth);
	}

	UINT frmHeight;
	if (SUCCEEDED(pSetting_->get_IFrame_Height(&frmHeight))) {
		CString strFrmHeight;
		strFrmHeight.Format(_TEXT("%lu"), frmHeight);
		SetDlgItemText(IDC_IFRAME_HEIGHT, strFrmHeight);
	}

	CheckDlgButton(IDC_LINK,
		(pSetting_->is_Link() == S_OK) ? BST_CHECKED : BST_UNCHECKED);

	tmp.Empty();
	if (SUCCEEDED(pSetting_->get_Link_Ext(&tmp))) {
		SetDlgItemText(IDC_LINK_EXT, CW2T(tmp));
	}

	CheckDlgButton(IDC_URL,
		(pSetting_->is_URL() == S_OK) ? BST_CHECKED : BST_UNCHECKED);

	tmp.Empty();
	if (SUCCEEDED(pSetting_->get_URL_Limit(&tmp))) {
		SetDlgItemText(IDC_URL_LIMIT, CW2T(tmp));
	}

	CheckDlgButton(IDC_OPEN_NEW,
		(pSetting_->is_OpenNewWindow() == S_OK) ? BST_CHECKED : BST_UNCHECKED);

	tmp.Empty();
	if (SUCCEEDED(pSetting_->get_Title(&tmp))) {
		SetDlgItemText(IDC_TITLE, CW2T(tmp));
	}

	// ʂ̕\Zbg
	UpdateEnable();
}

LRESULT CSettingDlg::OnInitDialog(UINT uMsg,
	WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	HMENU hSysMenu = GetSystemMenu(FALSE);
	ATLASSERT(hSysMenu);

	CString menuText;
	if ( !menuText.LoadString(IDS_SYSCMD_HELP)) {
		ATLASSERT(false);
	}
	LPTSTR lpMenuText = menuText.GetBuffer();

	MENUITEMINFO menuItemInfo = {0};
	menuItemInfo.cbSize = sizeof(MENUITEMINFO);
	menuItemInfo.fMask = MIIM_STRING | MIIM_ID;
	menuItemInfo.fType = MFT_STRING;
	menuItemInfo.dwTypeData = lpMenuText;
	menuItemInfo.cch = lstrlen(lpMenuText);
	menuItemInfo.wID = IDC_SYSCMD_ABOUT;
	InsertMenuItem(hSysMenu, SC_CLOSE, FALSE, &menuItemInfo);

	UpdateAllItems();

	if (pLinkCollector_) {
		CWindow wndURLLimit = GetDlgItem(IDC_URL_LIMIT);

		CComBSTR urlLimit;
		if (SUCCEEDED(pSetting_->get_URL_Limit(&urlLimit))) {
			wndURLLimit.SendMessage(CB_ADDSTRING, 0, (LPARAM)(LPCTSTR) CW2T(urlLimit));
		}

		HRESULT hr;

		ULONG mx;
		hr = pLinkCollector_->GetCount(&mx);
		if (SUCCEEDED(hr)) {
			for (ULONG idx = 0; idx < mx; idx++) {
				CComBSTR urlBase;
				hr = pLinkCollector_->GetURL(idx, &urlBase);
				if (FAILED(hr)) {
					break;
				}
				wndURLLimit.SendMessage(CB_ADDSTRING, 0, (LPARAM)(LPCTSTR) CW2T(urlBase));
			}
		}
	}

	if (pTemplateConfigCollection_) {
		CWindow wndTemplate = GetDlgItem(IDC_TEMPLATE);

		HRESULT hr;

		CComBSTR selectedName;
		hr = pSetting_->get_TemplateName(&selectedName);
		if (FAILED(hr)) {
			selectedName.Empty();
		}

		size_t mx;
		hr = pTemplateConfigCollection_->GetCount(&mx);
		if (SUCCEEDED(hr)) {
			WPARAM cursel = CB_ERR;
			for (size_t idx = 0; idx < mx; idx++) {
				if (cursel == CB_ERR) {
					// 1ȏ̃ACeΏICfbNX0ɂ
					cursel = 0;
				}
				CComPtr<ITemplateConfig> pTemplateConfig;
				hr = pTemplateConfigCollection_->GetTemplateConfig(idx, &pTemplateConfig);
				if (FAILED(hr)) {
					break;
				}

				CComBSTR name;
				hr = pTemplateConfig->GetName(&name);
				if (FAILED(hr)) {
					break;
				}

				CComBSTR displayName;
				hr = pTemplateConfig->GetDisplayName(&displayName);
				if (FAILED(hr)) {
					break;
				}

				LRESULT cbidx = wndTemplate.SendMessage(CB_ADDSTRING, 0, (LPARAM)(LPCTSTR) CW2T(displayName));
				if (cbidx != CB_ERR) {
					// ev[gݒ̃CfbNXۑ
					wndTemplate.SendMessage(CB_SETITEMDATA, cbidx, idx);
					// ev[gۑĂݒ̃ev[gƈvΑI𕜌
					if (selectedName && selectedName == name) {
						cursel = cbidx;
					}
				}
			}
			// I̕ (͏I)
			wndTemplate.SendMessage(CB_SETCURSEL, cursel, 0);
		}
	}

	return 0;
}

LRESULT CSettingDlg::OnSysCommand(UINT uMsg,
	WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	if (wParam != IDC_SYSCMD_ABOUT) {
		bHandled = FALSE;
		return 0;
	}

	CAtlStringW page;
	page.LoadString(IDS_SYSCMD_HELP_URL);

	HRESULT hr;
	CComBSTR helpFile;
	hr = GetModuleDirectory(_AtlBaseModule.GetModuleInstance(), &helpFile);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return 0;
	}
	helpFile.Append(page);

	ShellExecute(m_hWnd, _TEXT("OPEN"), helpFile, NULL, NULL, SW_SHOWNORMAL);

	return 0;
}


LRESULT CSettingDlg::OnHelp(UINT uMsg,
	WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	HELPINFO *pHelpInfo = (HELPINFO*) lParam;

	CString message;
	if (!message.LoadString(pHelpInfo->iCtrlId)) {
		message.LoadString(IDS_NO_HELP);
	}

	RECT margin = {8, 8, 8, 8};

	HH_POPUP popupInfo = {0};
	popupInfo.cbStruct = sizeof(HH_POPUP);
	popupInfo.idString = 0;
	popupInfo.pszText = message;
	popupInfo.pt = pHelpInfo->MousePos;
	popupInfo.clrForeground = -1;
	popupInfo.clrBackground = -1;
	popupInfo.rcMargins = margin;

	if ( !HtmlHelp(m_hWnd, NULL, HH_DISPLAY_TEXT_POPUP, (DWORD_PTR) &popupInfo)) {
		MessageBox(_TEXT("wv݂܂B"));
	}

	return 0;
}

LRESULT CSettingDlg::OnOK(
	WORD wNotifyCode,
	WORD wID,
	HWND hWndCtl,
	BOOL& bHandled 
	)
{
	ATLASSERT(pSetting_);

	CComBSTR tmp;
	CString sizTemp;

	CWindow wndTemplate = GetDlgItem(IDC_TEMPLATE);
	LRESULT cursel = wndTemplate.SendMessage(CB_GETCURSEL, 0, 0);
	if (cursel == CB_ERR) {
		// ev[g̑IĂȂ
		MessageBeep(MB_ICONERROR);
		return 0;
	}
	LRESULT templateIdx = wndTemplate.SendMessage(CB_GETITEMDATA, cursel, 0);
	if (templateIdx != CB_ERR) {
		CComPtr<ITemplateConfig> pTemplateConfig;
		HRESULT hr;
		hr = pTemplateConfigCollection_->GetTemplateConfig((size_t) templateIdx, &pTemplateConfig);
		ATLASSERT(SUCCEEDED(hr));
		if (SUCCEEDED(hr)) {
			CComBSTR name;
			hr = pTemplateConfig->GetName(&name);
			if (SUCCEEDED(hr)) {
				pSetting_->put_TemplateName(name);
			}
		}
	}


	pSetting_->put_ImgLink(IsDlgButtonChecked(IDC_IMG_LINK) == BST_CHECKED);

	if (GetDlgItemText(IDC_IMG_LINK_EXT, tmp.m_str)) {
		pSetting_->put_ImgLink_Ext(tmp);
	}

	pSetting_->put_Img(IsDlgButtonChecked(IDC_IMG) == BST_CHECKED);

	if (GetDlgItemText(IDC_IMG_EXT, tmp.m_str)) {
		pSetting_->put_Img_Ext(tmp);
	}

	pSetting_->put_Img_Size(IsDlgButtonChecked(IDC_IMG_SIZE) == BST_CHECKED);

	if (GetDlgItemText(IDC_IMG_WIDTH, sizTemp)) {
		const UINT siz = _ttol(sizTemp);
		pSetting_->put_Img_Width(siz);
	}
	if (GetDlgItemText(IDC_IMG_HEIGHT, sizTemp)) {
		const UINT siz = _ttol(sizTemp);
		pSetting_->put_Img_Height(siz);
	}

	pSetting_->put_URLLink(IsDlgButtonChecked(IDC_URL_LINK) == BST_CHECKED);

	if (GetDlgItemText(IDC_URL_LINK_EXT, tmp.m_str)) {
		pSetting_->put_URLLink_Ext(tmp);
	}

	if (GetDlgItemText(IDC_IFRAME_WIDTH, sizTemp)) {
		const UINT siz = _ttol(sizTemp);
		pSetting_->put_IFrame_Width(siz);
	}
	if (GetDlgItemText(IDC_IFRAME_HEIGHT, sizTemp)) {
		const UINT siz = _ttol(sizTemp);
		pSetting_->put_IFrame_Height(siz);
	}

	pSetting_->put_Link(IsDlgButtonChecked(IDC_LINK) == BST_CHECKED);

	if (GetDlgItemText(IDC_LINK_EXT, tmp.m_str)) {
		pSetting_->put_Link_Ext(tmp);
	}

	pSetting_->put_URL(IsDlgButtonChecked(IDC_URL) == BST_CHECKED);

	if (GetDlgItemText(IDC_URL_LIMIT, tmp.m_str)) {
		pSetting_->put_URL_Limit(tmp);
	}

	pSetting_->put_OpenNewWindow(IsDlgButtonChecked(IDC_OPEN_NEW) == BST_CHECKED);

	if (GetDlgItemText(IDC_TITLE, tmp.m_str)) {
		pSetting_->put_Title(tmp);
	}

	EndDialog(IDOK);
	return 0;
}

LRESULT CSettingDlg::OnCancel(
	WORD wNotifyCode,
	WORD wID,
	HWND hWndCtl,
	BOOL& bHandled 
	)
{
	EndDialog(IDCANCEL);
	return 0;
}

LRESULT CSettingDlg::OnBnClickedReset(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	ATLASSERT(pSetting_);

	// ݒlɖ߂
	DWORD keyState = GetKeyState(VK_SHIFT);
	if (keyState & 0x8000) {
		try {
			HRESULT hr;

			CComBSTR urlLimit;
			hr = pSetting_->get_URL_Limit(&urlLimit);
			if (FAILED(hr)) { AtlThrow(hr); }

			CComBSTR title;
			hr = pSetting_->get_Title(&title);
			if (FAILED(hr)) { AtlThrow(hr); }

			CComBSTR templateName;
			hr = pSetting_->get_TemplateName(&templateName);
			if (FAILED(hr)) { AtlThrow(hr); }

			CComQIPtr<IPersistConf> pPersistConf(pSetting_);
			ATLASSERT(pPersistConf);
			pPersistConf->InitNew();

			pSetting_->put_URL_Limit(urlLimit);
			pSetting_->put_Title(title);
			pSetting_->put_TemplateName(templateName);
		}
		catch (...) {
			MessageBox(_TEXT("sȗO܂B"), _TEXT("G["), MB_ICONERROR | MB_OK);
			return 0;
		}
	}

	// _CAOĐݒ肷
	UpdateAllItems();

	return 0;
}

LRESULT CSettingDlg::OnBnClicked(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	UpdateEnable();
	return 0;
}

void CSettingDlg::UpdateEnable(void)
{
	const bool enableImgLink = (IsDlgButtonChecked(IDC_IMG_LINK) == BST_CHECKED);
	CWindow imgLink = GetDlgItem(IDC_IMG_LINK_EXT);
	imgLink.EnableWindow(enableImgLink ? TRUE : FALSE);

	const bool enableImg = (IsDlgButtonChecked(IDC_IMG) == BST_CHECKED);
	CWindow imgExt = GetDlgItem(IDC_IMG_EXT);
	imgExt.EnableWindow(enableImg ? TRUE : FALSE);

	CWindow imgSize = GetDlgItem(IDC_IMG_SIZE);
	imgSize.EnableWindow(enableImg ? TRUE : FALSE);

	const bool enableImgSize = (IsDlgButtonChecked(IDC_IMG_SIZE) == BST_CHECKED);
	CWindow imgWidth = GetDlgItem(IDC_IMG_WIDTH);
	CWindow imgHeight = GetDlgItem(IDC_IMG_HEIGHT);
	imgWidth.EnableWindow((enableImgSize && enableImg) ? TRUE : FALSE);
	imgHeight.EnableWindow((enableImgSize && enableImg) ? TRUE : FALSE);

	const bool enableLink = (IsDlgButtonChecked(IDC_LINK) == BST_CHECKED);
	CWindow linkExt = GetDlgItem(IDC_LINK_EXT);
	linkExt.EnableWindow(enableLink ? TRUE : FALSE);

	const bool enableURLLink = (IsDlgButtonChecked(IDC_URL_LINK) == BST_CHECKED);
	CWindow urlLinkExt = GetDlgItem(IDC_URL_LINK_EXT);
	CWindow frameWidth = GetDlgItem(IDC_IFRAME_WIDTH);
	CWindow frameHeight = GetDlgItem(IDC_IFRAME_HEIGHT);
	urlLinkExt.EnableWindow(enableURLLink ? TRUE : FALSE);
	frameWidth.EnableWindow(enableURLLink ? TRUE : FALSE);
	frameHeight.EnableWindow(enableURLLink ? TRUE : FALSE);

	const bool enableURL = (IsDlgButtonChecked(IDC_URL) == BST_CHECKED);
	CWindow urlLimit = GetDlgItem(IDC_URL_LIMIT);
	urlLimit.EnableWindow(enableURL ? TRUE : FALSE);
}
