#include "stdafx.h"

#include "TemplateEvaluater.h"
#include "SimpleBuffer.h"


class __declspec(uuid("{FFDD3CF3-8B8D-4c32-BBEE-0F246D632531}")) CTemplateSourceEncodingDetectProcessor
	: public CComObjectRoot
	, public ITemplateSourceProcessor
{
public:
	BEGIN_COM_MAP(CTemplateSourceEncodingDetectProcessor)
		COM_INTERFACE_ENTRY(ITemplateSourceProcessor)
	END_COM_MAP()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct(void) throw()
	{
		return S_OK;
	}

	void FinalRelease() throw()
	{
		pSource_.Release();
	}

	HRESULT Init(ITemplateSourceWriter2* v_pSource) throw()
	{
		if ( !v_pSource) {
			ATLASSERT(false);
			return E_INVALIDARG;
		}
		try {
			pSource_ = v_pSource;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall Process(const BYTE* v_pLine, size_t v_siz, BOOL v_scriptlet) throw()
	{
		if ( !v_pLine || v_siz == 0) {
			return S_FALSE;
		}

		if (v_siz <= 1 || v_pLine[0] != '@') {
			return S_OK;
		}

		//TODO: 

		// @Ŏn܂XNvgbg̓\[XR[hɓo^ȂB
		return S_FALSE;
	}

protected:

	CComPtr<ITemplateSourceWriter2> pSource_;
};


HRESULT __stdcall CreateTemplateSourceEncodingDetectProcessor(
	ITemplateSourceWriter2* v_pSrc, ITemplateSourceProcessor** v_ppProcessor) throw()
{
	if ( !v_ppProcessor) {
		return E_POINTER;
	}
	if ( !v_pSrc) {
		return E_POINTER;
	}

	try {
		HRESULT hr;
		CComObject<CTemplateSourceEncodingDetectProcessor>* pProcessorImpl = NULL;
		hr = CComObject<CTemplateSourceEncodingDetectProcessor>::CreateInstance(&pProcessorImpl);
		if (FAILED(hr)) {
			return hr;
		}
		CComPtr<ITemplateSourceProcessor> pProcessor(pProcessorImpl);

		hr = pProcessorImpl->Init(v_pSrc);
		if (FAILED(hr)) {
			return hr;
		}

		return pProcessor.CopyTo(v_ppProcessor);
	}
	catch (...) {
		return E_FAIL;
	}
}


class __declspec(uuid("{7F8A8CA9-3DE9-4b98-8808-7059FA7818BB}")) CTemplateSourceEncodingProcessor
	: public CComObjectRoot
	, public ITemplateSourceProcessor
{
public:
	BEGIN_COM_MAP(CTemplateSourceEncodingProcessor)
		COM_INTERFACE_ENTRY(ITemplateSourceProcessor)
	END_COM_MAP()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct(void) throw()
	{
		return S_OK;
	}

	void FinalRelease() throw()
	{
		pSource_.Release();
	}

	HRESULT Init(ITemplateSourceWriter2* v_pSource) throw()
	{
		if ( !v_pSource) {
			ATLASSERT(false);
			return E_INVALIDARG;
		}
		try {
			pSource_ = v_pSource;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall Process(const BYTE* v_pLine, size_t v_siz, BOOL v_scriptlet) throw()
	{
		if ( !v_pLine || v_siz == 0) {
			return S_FALSE;
		}

		HRESULT hr;
		
		// \[XR[hw̃R[hy[W擾
		UINT codepage = 0;
		hr = pSource_->get_Codepage(&codepage);
		if (FAILED(hr)) {
			return hr;
		}

		// oCgz񂩂UnicodeփR[hy[Ww肵ĕϊ
		int required = MultiByteToWideChar(
			codepage,
			0,
			reinterpret_cast<LPCSTR>(v_pLine),
			static_cast<int>(v_siz),
			NULL,
			0
			);
		if ( !required) {
			return AtlHresultFromLastError();
		}

		CSimpleBuffer<WCHAR> wide(required);
		int ret = MultiByteToWideChar(
			codepage,
			0,
			reinterpret_cast<LPCSTR>(v_pLine),
			static_cast<int>(v_siz),
			wide.GetData(),
			required
			);
		if ( !required) {
			return AtlHresultFromLastError();
		}

		// \[XR[hɓo^
		hr = pSource_->Write(
			wide.GetData(),
			static_cast<UINT>(wide.GetCount()),
			v_scriptlet
			);
		if (FAILED(hr)) {
			return hr;
		}

		return S_OK;
	}

protected:

	CComPtr<ITemplateSourceWriter2> pSource_;
};

HRESULT __stdcall CreateTemplateSourceEncodingProcessor(
	ITemplateSourceWriter2* v_pSrc, ITemplateSourceProcessor** v_ppProcessor) throw()
{
	if ( !v_ppProcessor) {
		return E_POINTER;
	}
	if ( !v_pSrc) {
		return E_POINTER;
	}

	try {
		HRESULT hr;
		CComObject<CTemplateSourceEncodingProcessor>* pProcessorImpl = NULL;
		hr = CComObject<CTemplateSourceEncodingProcessor>::CreateInstance(&pProcessorImpl);
		if (FAILED(hr)) {
			return hr;
		}
		CComPtr<ITemplateSourceProcessor> pProcessor(pProcessorImpl);

		hr = pProcessorImpl->Init(v_pSrc);
		if (FAILED(hr)) {
			return hr;
		}

		return pProcessor.CopyTo(v_ppProcessor);
	}
	catch (...) {
		return E_FAIL;
	}
}

