package org.mineap.nndd.android.user
{
	import flash.data.EncryptedLocalStore;
	import flash.utils.ByteArray;
	
	import mx.utils.Base64Decoder;
	import mx.utils.Base64Encoder;
	
	import org.mineap.nndd.android.conf.ConfigManager;
	
	/**
	 * 
	 * @author shiraminekeisuke
	 * 
	 */
	public class UserManager
	{
		
		private static const STORE_KEY_MAIL_ADDRESS:String = "mailAddress";
		private static const STORE_KEY_PASSWORD:String = "password";
		
		/**
		 * 
		 */
		private var _user:String;
		
		/**
		 * 
		 */
		private var _password:String;
		
		/**
		 * 
		 */
		private static const _userManager:UserManager = new UserManager();
		
		/**
		 * 
		 * 
		 */
		public function UserManager()
		{
			if(_userManager != null){
				throw ArgumentError("MyListRenewSchedulerはインスタンス化できません。");
			}
			
			ConfigManager.instance.reload();
			_user = ConfigManager.instance.getItem(STORE_KEY_MAIL_ADDRESS);
			
			if (EncryptedLocalStore.isSupported)
			{
				var value:ByteArray = EncryptedLocalStore.getItem(STORE_KEY_PASSWORD);
				if (value != null)
				{
					_password = value.readUTFBytes(value.length);
				}
			}
			else
			{
				var encodedPass:String = ConfigManager.instance.getItem(STORE_KEY_PASSWORD);
				
				if (encodedPass != null)
				{
					var decoder:Base64Decoder = new Base64Decoder();
					decoder.decode(encodedPass);
					var passByteArray:ByteArray = decoder.toByteArray();
					
					_password = passByteArray.readUTFBytes(passByteArray.length);
				}
			}
			
			
		}
		
		/**
		 * 
		 * @return 
		 * 
		 */
		public static function get instance():UserManager{
			return _userManager;
		}

		/**
		 * 
		 */
		public function get user():String
		{
			return _user;
		}

		/**
		 * @private
		 */
		public function set user(value:String):void
		{
			_user = value;
			ConfigManager.instance.setItem(STORE_KEY_MAIL_ADDRESS, _user);
			ConfigManager.instance.save();
		}

		/**
		 * 
		 */
		public function get password():String
		{
			return _password;
		}

		/**
		 * @private
		 */
		public function set password(value:String):void
		{
			_password = value;
			
			if (EncryptedLocalStore.isSupported)
			{
				var byteArray:ByteArray = new ByteArray();
				byteArray.writeUTFBytes(_password);
				EncryptedLocalStore.setItem(STORE_KEY_PASSWORD, byteArray);
			}
			else
			{
				var encoder:Base64Encoder = new Base64Encoder();
				encoder.encodeUTFBytes(_password);
				ConfigManager.instance.setItem(STORE_KEY_PASSWORD, encoder.toString());
				ConfigManager.instance.save();
			}
			
		}


	}
}