/*  
 	D-STAR room server Program V00.15
		    Date 12/15/2011
                     Satoshi Yasuda
                       7m3tjz/ad6gz
                                               
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <signal.h>
#include <windows.h>
#include <fcntl.h>
#include <assert.h>


void	ctrl_c();
char	*curtime(void);
void	add_connected_table (u_long ip_addr);
void	update_connected_table (u_long ip_addr);
void	delete_from_table(u_long ip_addr);
void	alive_in_table(u_long ip_addr);
void	cfg_read(char FileName[]);
void	usage(void);
void	reply_server_status(void);
void	delete_all_from_table(void);
void	send_dv_packet (u_long ip_addr);
void	send_header_packet (u_long ip_addr);
void	AckNaksend(u_long ip_addr, int sw);
void	CONNECTsend (u_long ip_addr);
void	ConnectTableCheck(void);
void	dprs (unsigned char s_data[]);
void	DprsComPortOpen(void);
int	DprsSW;
int	ReplySW;

#define	OUT_PORT	39998	
#define	IN_PORT		39999
#define LOG_PORT	39997	
#define version_high	0x00
#define	version_low	0x15
#define	version_Year	0x11
#define	version_Month	0x12
#define	version_Day	0x15



/* definition of id in back_bone */
#define	dd_type		0x40
#define	dv_type		0x20
#define	dv_flag		0x21
#define	header_type	0x10


struct	call_table {
	char	req_id[2];
	unsigned char	flags[2];
	unsigned char	PicVer[2];
	struct	{
		unsigned char	: 7;
		unsigned char	RepeaterAcc	: 1;
	} flag;
	char	reserve;
	char	callsign[8];
	char	zone[8];
	char	area[8];
	u_long  ip_address;
	int	ssn;
	int	port;
};

struct	connected_table {
	struct connected_table *f_chain;
	char	callsign[8];
	char	roomname[8];
	u_long	ip_address;
	int	port;
	struct	{
		unsigned char	: 6;
		unsigned char	alive : 1;
		unsigned char	RepeaterAcc : 1;
	} flag;
};

struct	dv_header{
	unsigned char	flags[3];
	unsigned char	RPT2Call[8];
	unsigned char	RPT1Call[8];
	unsigned char	YourCall[8];
	unsigned char	MyCall[8];
	unsigned char	MyCall2[4];
	unsigned char	CRC[2];
};

struct	back_bone{
	unsigned char	id;
	unsigned char	dest_repeater_id;
	unsigned char	send_repeater_id;
	unsigned char	send_terminal_id;
	unsigned char	seq_high;
	unsigned char	seq_low;
	unsigned char	control;
};

struct	voice_data{
	unsigned char	voice_segment[9];
	unsigned char	data_segment[3];
};

struct inet_dv_packet {
	unsigned char	id[4];
	unsigned char	flags[2];
	unsigned char	reserve[2];
	struct	back_bone b_bone;
	union {
		struct	dv_header rf_header;
		struct	voice_data v_data;
	};
};


struct node_packet {
	union {
		struct inet_dv_packet node_dv_pkt;
		struct call_table node_table;
	};
};

struct	connect_log {
	unsigned char	NodeCall[8];
	unsigned char	RoomName[8];
	u_long		ip_address;
	unsigned char	reserve[4];
};
	
struct	access_log {
	unsigned char	NodeCall[8];
	unsigned char	RoomName[8];
	unsigned char	MyCall[8];
};

struct	node_log{
	unsigned char	id[4];
	unsigned char	reserve[4];
	union {
		struct connect_log con_log;
		struct access_log acc_log;
	};
};

SOCKET	sock_out, sock_in, sock_log;
int	debug, info, from_len;
struct	node_packet table;
struct	sockaddr_in addr_in, from;
struct	sockaddr_in addr_out;
struct	sockaddr_in addr_log;
struct	connected_table *first_pnt, *last_pnt;
struct	hostent *p_ent;
struct	in_addr *p_in_addr;
struct	timeval	tv;
fd_set	readfd;

int	in_port = IN_PORT;
int	out_port = OUT_PORT;
int	log_port = LOG_PORT;
int	out_port_save;
char	logfile[128] = {"RoomServerLog"};
char	log_server[128];
u_long	from_ip;
u_long	cur_ip;
FILE	*log_file;
int	ssn_old;
WSADATA wsaData;
unsigned char	NodeCallSave[8];
unsigned char	YourCallSave[8];

char	DprsPortName[11] = {"\\\\.\\com1"};
int	slow_data_sw;
HANDLE	dprscomport;
DCB	dcb;
int	ok, baud_rate;
unsigned char slow_data_buf[6];
int	sendSW;
char	lastframe[6] ={0x55,0x55,0x55,0x55,0xc8,0x7a};
char	LastFrameCheck[6];
time_t	time1, time2;


/* Short message of ACK "SENT TO ALL NODE  "  */         
char	ACKmsg[11][12] =  {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x2d,0x16,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x30,0x1c,0xd6,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x3e,0x1b,0xb3,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x31,0x1b,0xdc,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x50,0x0e,0xdf,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x32,0x03,0xb3,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x3e,0x00,0xd7,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x33,0x0a,0xb3,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x50,0x6f,0xb3,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x55,0x55,
			0x55,0xc8,0x7a,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x55,0x55};

/* Short message of NAK "DID NOT SEND TO NODE"  */
char	NAKmsg[11][12] =  {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x2d,0x16,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x30,0x0b,0xda,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x34,0x6f,0xdd,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x31,0x00,0xc7,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x50,0x1c,0xd6,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x32,0x01,0xd7,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x50,0x1b,0xdc,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x33,0x6f,0xdd,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x3f,0x0b,0xd6,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x55,0x55,
			0x55,0xc8,0x7a,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x55,0x55};

/* Short message of CONNECTED "CONNECTED TO SERVER "  */
char	CONNECTmsg[11][12] =  {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x2d,0x16,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x30,0x0c,0xdc,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x3e,0x01,0xd6,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x31,0x0c,0xc7,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x35,0x0b,0xb3,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x32,0x1b,0xdc,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x50,0x1c,0xd6,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x33,0x1d,0xc5,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x35,0x1d,0xb3,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x55,0x55,
			0x55,0xc8,0x7a,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x55,0x55};

char	BeepMsg[8][12] =  {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x2d,0x16,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x16,0x29,0xf5,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x16,0x29,0xf5,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x16,0x29,0xf5,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x16,0x29,0xf5,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x16,0x29,0xf5,
			0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x55,0x55,
			0x55,0xc8,0x7a,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x55,0x55};


void	ctrl_c ()
{
	if (dprscomport != NULL) CloseHandle (dprscomport);
	shutdown (sock_out, SD_SEND);
	shutdown (sock_in, SD_RECEIVE);
	shutdown (sock_log, SD_SEND);
	closesocket (sock_out);
	closesocket (sock_in);
	closesocket (sock_log);
	if (log_file != NULL)
	{
		fprintf (log_file, "log end %.24s\n",curtime());
		fclose (log_file);
	}
	WSACleanup();
	printf ("End %.24s\n",curtime());
	abort();
} 


void main(int argc, char **argv)
{
	int	flag, n, i;
	int	ret;
	struct	tm *pt;
	time_t	t;
	unsigned short	crc;
	u_long  ip_save, send_ip;
	char	*cfg_file;
	int	seq;
	int	l;

	signal (SIGINT, ctrl_c);
	signal (SIGBREAK, ctrl_c);

	SetPriorityClass(GetCurrentProcess, THREAD_PRIORITY_HIGHEST);


	debug = 0;
	info = 0;
	cfg_file = NULL;

	DprsSW = FALSE;
	ReplySW = FALSE;
	slow_data_sw = FALSE;
	dprscomport = NULL;
	baud_rate = 9600;

	sendSW = FALSE;
	cur_ip = NULL;

	if (argc >= 2)
	{
		for (i = 1 ; i < argc ; i++)
		{ 
			if (!strncmp (argv[i],"-d",2)) 	debug = 1;
			else if (!strncmp (argv[i], "-i",2)) info = 1;
			else if (!strncmp (argv[i], "-f",2)) cfg_file = (char *)argv[i+1];
			else if (!strncmp (argv[i], "-?",2)) usage();

		}
	}

	printf (" D-STAR room  Server Program V%2.2x.%2.2x 20%2.2x/%2.2x/%2.2x\n",
						version_high, version_low, version_Year, version_Month, version_Day);
	printf (" (C) 2011     Satoshi Yasuda       7m3tjz/ad6gz\n");
	printf ("              Start Time %.24s\n",curtime());

	if (debug) printf ("                                       debug mode\n"); 

	log_server[0] = NULL;
	cfg_read(cfg_file);

	if (DprsSW)	DprsComPortOpen ();

	/* Log file open */
	log_file = NULL;
	if (strlen(logfile))
	{
		log_file = fopen (logfile, "a");
		if (log_file == NULL) printf ("log file(%s) open error\n",logfile);
		else fprintf (log_file, "log start %.24s\n",curtime());
	}

        if (WSAStartup(2, &wsaData))
        {   printf("winsock initialize failed\n");
            abort();
        }

	sock_in = socket(AF_INET, SOCK_DGRAM, 0);
        if (sock_in == INVALID_SOCKET)
        {   printf("did not create in sock\n");
            abort();
        }

	sock_out = socket(AF_INET, SOCK_DGRAM, 0);
        if (sock_out == INVALID_SOCKET)
        {   printf("did not create out sock\n");
            abort();
        }

	sock_log = socket(AF_INET, SOCK_DGRAM, 0);
        if (sock_out == INVALID_SOCKET)
        {   printf("did not create log sock\n");
            abort();
        }


	memset(&addr_out, 0, sizeof(addr_out));
	addr_out.sin_family = AF_INET;
	addr_out.sin_port = htons(out_port);


	memset(&addr_in, 0, sizeof(addr_in));
	addr_in.sin_family = AF_INET;
	addr_in.sin_port = htons(in_port);
	addr_in.sin_addr.s_addr = htonl(INADDR_ANY);

	bind(sock_in, (struct sockaddr *)&addr_in, sizeof(addr_in));

	/* server address set */
	p_ent = NULL;
	if (strlen(log_server))
	{
		p_ent = gethostbyname(log_server);
		if (p_ent == NULL)
		{
			printf ("Log Server Not Found\n");
			return;
		}
		p_in_addr = (struct in_addr *)p_ent->h_addr;

		memset(&addr_log, 0, sizeof(addr_log));
		addr_log.sin_family = AF_INET;
		addr_log.sin_port = htons(log_port);
		addr_log.sin_addr.s_addr = inet_addr(inet_ntoa(*p_in_addr));
	} else {
		printf ("Not assign the log server!!\n");
	}

	from_len = sizeof (struct sockaddr);
	flag = 0;
	first_pnt = malloc (sizeof (struct connected_table));
	first_pnt->ip_address = 0;
	first_pnt->port = 0;
	first_pnt->f_chain = NULL;
	first_pnt->flag.alive = 0;
	first_pnt->flag.RepeaterAcc = 0;
	last_pnt = first_pnt;


	while (1)		/* loop */
	{
    		n = recvfrom (sock_in, (char *)&table, 56, flag, (struct sockaddr *)&from, &from_len);
    		from_ip = from.sin_addr.s_addr;


	    	if (debug && ((n == 40) || (n == 44)))
		{	
			printf ("%.24s packet from %d.%d.%d,%d  length %d req_id %c%c ver: V%.2x.%.2x Firmware: V%.2x.%.2x\n",
				curtime(),
			from_ip & 0xff, from_ip>>8 & 0xff, from_ip>>16 & 0xff, from_ip>> 24 & 0xff,
			n, table.node_table.req_id[0], table.node_table.req_id[1],
			table.node_table.flags[0], table.node_table.flags[1], 
			table.node_table.PicVer[0], table.node_table.PicVer[1]);
		} else if (debug /*&& (n == -1)*/) {
			printf ("%.24s packet from %d.%d.%d,%d  lenght %d  error no: %d\n",
				curtime(),from_ip & 0xff, from_ip>>8 & 0xff, from_ip>>16 & 0xff, from_ip>> 24 & 0xff, n,
				WSAGetLastError());
	   		} else if (debug) {
			printf ("%.24s packet from %d.%d.%d,%d  lenght %d\n",
				curtime(),from_ip & 0xff, from_ip>>8 & 0xff, from_ip>>16 & 0xff, from_ip>> 24 & 0xff, n);
		}

		if ((n == 44) || (n == 40))
		{
			if (!strncmp(table.node_table.req_id, "RS", 2) || 
				 !strncmp(table.node_table.req_id, "SI", 2))
			{
				if (n == 44) out_port_save = table.node_table.port;
				else  	     out_port_save = out_port;
				update_connected_table (from.sin_addr.s_addr);
				if (!strncmp(table.node_table.req_id, "SI", 2))
				{
					reply_server_status();
					if (ReplySW) CONNECTsend (from_ip);
				}
			}
		} else if (n == 16) {
			if (!strncmp(table.node_table.req_id, "DD", 2))
			{
				table.node_table.ip_address = 0;
				delete_from_table (from.sin_addr.s_addr);
			}
			else if (!strncmp(table.node_table.req_id, "AL", 2))
			{
				alive_in_table (from.sin_addr.s_addr);
			}

		} else {
		    if (debug) printf ("%.24s sendSW: %d  current IP: %x  from IP: %x\n", curtime(), sendSW, cur_ip, from_ip);
		    if (!sendSW || (cur_ip == from_ip))
		    {
			if (n == 56)
      			{
				if (table.node_dv_pkt.b_bone.id == header_type)
				{
					time(&time2);
					if (difftime (time2, time1) > 60)
					{
						ConnectTableCheck();
					}
					cur_ip = from_ip;
					sendSW = TRUE;
					send_header_packet (from.sin_addr.s_addr);
				}
			} else if (n == 27) {
				if (table.node_dv_pkt.b_bone.id == dv_type)
				{
					cur_ip = from_ip;
					sendSW = TRUE;
					if (DprsSW) dprs ((unsigned char *)&table.node_dv_pkt.v_data.data_segment[0]);


					for (l = 0; l < 12 ; l++)
					{
						LastFrameCheck[0] = LastFrameCheck[1]; 
						LastFrameCheck[1] = LastFrameCheck[2]; 
						LastFrameCheck[2] = LastFrameCheck[3]; 
						LastFrameCheck[3] = LastFrameCheck[4]; 
						LastFrameCheck[4] = LastFrameCheck[5];
						LastFrameCheck[5] = table.node_dv_pkt.v_data.voice_segment[l];
 						if (!strncmp(LastFrameCheck,lastframe,6))
						{
							sendSW = FALSE;
							cur_ip = NULL;
						}
					}
					seq = table.node_dv_pkt.b_bone.seq_high << 8 | table.node_dv_pkt.b_bone.seq_low;
					if (debug)
					{
						printf ("%.24s seq. %d(%d) %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x   %2.2x %2.2x %2.2x\n",
								curtime(),seq,seq%21,
								table.node_dv_pkt.v_data.voice_segment[0],
								table.node_dv_pkt.v_data.voice_segment[1],
								table.node_dv_pkt.v_data.voice_segment[2],
								table.node_dv_pkt.v_data.voice_segment[3],
								table.node_dv_pkt.v_data.voice_segment[4],
								table.node_dv_pkt.v_data.voice_segment[5],
								table.node_dv_pkt.v_data.voice_segment[6],
								table.node_dv_pkt.v_data.voice_segment[7],
								table.node_dv_pkt.v_data.voice_segment[8],
								table.node_dv_pkt.v_data.data_segment[0],
								table.node_dv_pkt.v_data.data_segment[1],
								table.node_dv_pkt.v_data.data_segment[2]
								);
					}
					send_dv_packet (from.sin_addr.s_addr);
				}
			}
		    }
		}
	}
}

/* Connect table update */
void	ConnectTableCheck()
{
	struct	connected_table *pnt;

loop:
	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (pnt->flag.alive)
		{
			delete_from_table (pnt->ip_address);
			goto loop;
		}
		pnt = pnt->f_chain;
	}
}

void	send_header_packet (u_long ip_addr)
{
	struct	connected_table *pnt;
	struct	node_log log;
	int	sw;	

	sw = 0;
	strncpy (YourCallSave,table.node_dv_pkt.rf_header.MyCall,8);
	if (debug || info)
	{
		printf ("%.24s Send Header Packet from %.8s\n",curtime(),table.node_dv_pkt.rf_header.MyCall);
	}

	strncpy (log.acc_log.MyCall,table.node_dv_pkt.rf_header.MyCall, 8);
	strncpy (log.id, "ACC ", 4);


	pnt = first_pnt->f_chain;
	while (pnt)
	{
	   time (&time1);
	   if (pnt->ip_address != ip_addr)
	   {
		if (debug || info) printf ("%.24s Send Header Packet to %.8s\n",curtime(), pnt->callsign);
		addr_out.sin_port = htons(pnt->port);
		addr_out.sin_addr.s_addr = pnt->ip_address;
		if (sendto(sock_out, (char *)&table, 56, 0, (struct sockaddr *)&addr_out, sizeof(addr_out)) == SOCKET_ERROR)
		{
			printf("send error 2:%d %x\n",WSAGetLastError(),pnt->ip_address);
			while (WSAGetLastError() == WSAENOBUFS)
			{
				Sleep (50);
				addr_out.sin_port = htons(pnt->port);
				addr_out.sin_addr.s_addr = pnt->ip_address;
				sendto(sock_out, (char *)&table, 56, 0,(struct sockaddr *)&addr_out, sizeof(addr_out));
			}
		}
		sw = 1;
		pnt->flag.alive = 1;
	   }
	   else
	   {
		strncpy (log.acc_log.NodeCall,pnt->callsign, 8);	
		strncpy (log.acc_log.RoomName,pnt->roomname, 8);
		strncpy (NodeCallSave,pnt->callsign, 8);
		pnt->flag.alive = 0;
	   }
	   pnt = pnt->f_chain;
	}

	if (p_ent) 
	{
		addr_log.sin_port = htons(log_port);
		addr_log.sin_addr.s_addr = inet_addr(inet_ntoa(*p_in_addr));
		sendto (sock_log, (char *)&log, sizeof (struct node_log),  0,
			(struct sockaddr *)&addr_log, sizeof (struct sockaddr));
	}

	pnt = first_pnt->f_chain;
	while (pnt)
	{
	   if (pnt->ip_address == ip_addr)
	   {
		if (!(pnt->flag.RepeaterAcc)) AckNaksend (ip_addr, sw);
		return;
	   }
	}
}

void	send_dv_packet (u_long ip_addr)
{
	struct	connected_table *pnt;

	pnt = first_pnt->f_chain;
	while (pnt)
	{
	   if (pnt->ip_address != ip_addr)
	   { 
		if (debug || info) printf ("%.24s Send DV Packet to %.8s\n",curtime(),pnt->callsign);
		if (log_file) fprintf (log_file,"Send DV Packet to %.8s\n",pnt->callsign);
		addr_out.sin_port = htons(pnt->port);
		addr_out.sin_addr.s_addr = pnt->ip_address;
		if (sendto(sock_out, (char *)&table, 27, 0, (struct sockaddr *)&addr_out, sizeof(addr_out)) == SOCKET_ERROR)
		{
			printf("send error 2:%d %x\n",WSAGetLastError(),pnt->ip_address);
			if (log_file ) fprintf(log_file, "send error 2:%d %x\n",WSAGetLastError(),pnt->ip_address);
			while (WSAGetLastError() == WSAENOBUFS)
			{
				Sleep (50);
				addr_out.sin_port = htons(pnt->port);
				addr_out.sin_addr.s_addr = pnt->ip_address;
				sendto(sock_out, (char *)&table, 27, 0,(struct sockaddr *)&addr_out, sizeof(addr_out));
			}
		}
	   }
	   pnt = pnt->f_chain;
	}

}

void	add_connected_table (u_long ip_addr)
{
	struct	connected_table *pnt;
	struct	node_log log;	

	pnt = malloc (sizeof (struct connected_table));
	pnt->f_chain = NULL;
	pnt->ip_address = ip_addr;
	pnt->port = out_port_save;
	pnt->flag.alive = 0;
	pnt->flag.RepeaterAcc = table.node_table.flag.RepeaterAcc;
	strncpy (pnt->callsign, table.node_table.callsign, 8);
	strncpy (pnt->roomname, table.node_table.zone, 8);
	if (debug || info) printf ("%.24s Node IP address added %.8s %.8s %d.%d.%d.%d\n",
				curtime(),pnt->callsign,pnt->roomname,
				ip_addr & 0xff, ip_addr>>8 & 0xff, ip_addr>>16 & 0xff, ip_addr>>24); 
	if (log_file) fprintf (log_file, "%.24s Node IP address added %.8s %.8s %d.%d.%d.%d\n",
				curtime(),pnt->callsign,pnt->roomname,
				ip_addr & 0xff, ip_addr>>8 & 0xff, ip_addr>>16 & 0xff, ip_addr>>24); 
	last_pnt->f_chain = pnt;
	last_pnt = pnt;

	strncpy (log.con_log.NodeCall,table.node_table.callsign, 8);	
	strncpy (log.con_log.RoomName,table.node_table.zone, 8);
	log.con_log.ip_address = ip_addr;	
	strncpy (log.id, "ADD ", 4);
	if (p_ent)
	{
		addr_log.sin_port = htons(log_port);
		addr_log.sin_addr.s_addr = inet_addr(inet_ntoa(*p_in_addr));
		sendto (sock_log, (char *)&log, sizeof (struct node_log),  0,
			(struct sockaddr *)&addr_log, sizeof (struct sockaddr));
	}
	return;
}


void	update_connected_table (u_long ip_addr)
{
	struct	connected_table *pnt;
	struct	node_log log;	
	
	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (!strncmp (pnt->callsign, table.node_table.callsign, 8))
		{
			if (pnt->ip_address != ip_addr)
			{
				if (debug || info) printf ("%.24s Node IP address updated %.8s %.8s from %d.%d.%d.%d to %d.%d.%d.%d\n",
					curtime(), pnt->callsign,pnt->roomname,pnt->ip_address & 0xff, pnt->ip_address>>8 & 0xff, 
					pnt->ip_address>>16 & 0xff, pnt->ip_address>>24,
					ip_addr & 0xff, ip_addr>>8 & 0xff, ip_addr>>16 & 0xff, ip_addr>>24); 
				if (log_file) fprintf (log_file, "%.24s Node IP address updated %.8s %.8s from %d.%d.%d.%d to %d.%d.%d.%d\n",
					curtime(), pnt->callsign,pnt->roomname,pnt->ip_address & 0xff, pnt->ip_address>>8 & 0xff, 
					pnt->ip_address>>16 & 0xff, pnt->ip_address>>24,
					ip_addr & 0xff, ip_addr>>8 & 0xff, ip_addr>>16 & 0xff, ip_addr>>24); 
				pnt->ip_address = ip_addr;
				pnt->port = out_port_save;
				strncpy (pnt->roomname, table.node_table.zone, 8);
			}
			return;
		}
		pnt = pnt->f_chain;
	}
	if (debug) printf ("Not found entry table: %.8s %.8s\n", table.node_table.zone, table.node_table.callsign); 
	if (log_file) fprintf (log_file, "Not found entry table: %.8s %.8s\n", table.node_table.zone, table.node_table.callsign); 
	add_connected_table (ip_addr);
	return;
}

void	delete_from_table (u_long ip_addr)
{
	int	k, i;
	struct	connected_table *pnt, *pnt_wrk;
	struct	node_log log;	

	pnt_wrk = first_pnt;
	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (pnt->ip_address == ip_addr)
		{
			if (debug || info) printf ("%.24s Deleted from table: %.8s %.8s\n",curtime(),pnt->roomname,pnt->callsign);
			if (log_file) fprintf (log_file, "%.24s Deleted from table: %.8s %.8s\n",curtime(),pnt->roomname,pnt->callsign);
			pnt_wrk->f_chain = pnt->f_chain;
			free (pnt);
			last_pnt = first_pnt;
			pnt = first_pnt->f_chain;
			while (pnt)
			{

				last_pnt = pnt;
				pnt = pnt->f_chain;
			}
			return;
		}
		pnt_wrk = pnt;
		pnt = pnt->f_chain;
	}
	return;
}

/* client status check */
void	alive_in_table (u_long ip_addr)
{
	int	k, i;
	struct	connected_table *pnt;

	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (pnt->ip_address == ip_addr)
		{
			if (debug || info) printf ("%.24s Alive in table: %.8s %.8s\n",curtime(),pnt->roomname,pnt->callsign);
			if (log_file) fprintf (log_file, "%.24s Alive in table: %.8s %.8s\n",curtime(),pnt->roomname,pnt->callsign);
			pnt->flag.alive = 0;
		}
		pnt = pnt->f_chain;
	}
}


void    delete_all_from_table (void)
{
        int     k, i;
        struct  connected_table  *pnt, *pnt_wrk;
	struct	node_log log;

	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (debug || info) printf ("%.24s Deleted from table: %.8s %.8s\n",curtime(),pnt->roomname,pnt->callsign);
		if (log_file) fprintf (log_file, "%.24s Deleted from table: %.8s %.8s\n",curtime(),pnt->roomname,pnt->callsign);
			strncpy (log.con_log.NodeCall,pnt->callsign, 8);	
			strncpy (log.con_log.RoomName,pnt->roomname, 8);
			log.con_log.ip_address = pnt->ip_address;	
			strncpy (log.id, "DEL ", 4);
			if (p_ent)
			{
				addr_log.sin_port = htons(log_port);
				addr_log.sin_addr.s_addr = inet_addr(inet_ntoa(*p_in_addr));
				sendto (sock_log, (char *)&log, sizeof (struct node_log),  0,
					(struct sockaddr *)&addr_log, sizeof (struct sockaddr));
			}

		pnt_wrk = pnt->f_chain;
		free (pnt);
		pnt = pnt_wrk;
	}
	last_pnt = first_pnt;
	return;
}

char *curtime(void)
{
	struct tm *pt;
	time_t	t;

	time (&t);
	pt = localtime (&t);
	return asctime(pt);
}

/* server status check */
void    reply_server_status(void)
{
        from.sin_addr.s_addr = from_ip;
        from.sin_port = htons(out_port_save);
        from.sin_family = AF_INET;
        strncpy (table.node_table.req_id, "SA", 2);
        sendto (sock_out, (char *)&table, 16, 0,
                        (struct sockaddr *)&from, sizeof (struct sockaddr));
        return;
}

/* read config. file */
void	cfg_read(char FileName[])
{
	FILE	*cfg;
	char	buf[256],str[256];
	char	*token, *last;
	u_int	i;

	cfg = NULL;
	if (FileName != NULL)
	{
		cfg = fopen (FileName,"r");
	}
	if (cfg == NULL)
	{
		cfg = fopen ("room_server.cfg","r");
		if (cfg == NULL)
		{
			printf ("Config file open error : %s\n",FileName);
			return;
		}
	}
	
	if (debug) printf ("\n*** Debug on Config File\n");
      
	while (fgets(buf, 256, cfg))
	{
		strcpy (str,buf);
		if (str[strlen(str)-1] == 0x0a) str[strlen(str)-1] = 0x00;
		token = str;
		while (*token == 0x20) token++;
		if (*token != 0x23)	/* check # */
		{
			last = strpbrk (str,";");
			if (last == NULL)
			{
				printf ("Not found ';' in  : %s\n",buf);
			} else {
				*last = 0x00;
				if (!strncmp (token,"InPort",6))
				{
					token = strpbrk(token,"=");
					token++;
					while (*token == 0x20) token++;
					in_port = atoi(token);
					if (debug) printf ("InPort : %d\n",in_port);
				} else if (!strncmp (token,"OutPort",6))
				{
					token = strpbrk(token,"=");
					token++;
					while (*token == 0x20) token++;
					out_port = atoi(token);
					if (debug) printf ("OutPort : %d\n",out_port);
				} else if (!strncmp (token,"LogPort",6))
				{
					token = strpbrk(token,"=");
					token++;
					while (*token == 0x20) token++;
					log_port = atoi(token);
					if (debug) printf ("LogPort : %d\n",log_port);
				} else if (!strncmp (token, "LogFileName", 11))
				{
					token = strpbrk(token,"=");
					token++;
					while (*token == 0x20) token++;
					strcpy (logfile, token);
					if (debug) printf ("LogFileName : %s\n",logfile);
				} else if (!strncmp (token, "LogServer", 9))
				{
					token = strpbrk(token,"=");
					token++;
					while (*token == 0x20) token++;
					strcpy (log_server, token);
					if (debug) printf ("LogServer : %s\n",log_server);
				} else if (!strncmp (token, "DprsComPort", 11))
				{
					token = strpbrk(token,"=");
					token++;
					while (*token == 0x20) token++;
					strcpy (&DprsPortName[4], token);
					if (debug) printf ("DprsComPort : %s\n", &DprsPortName[4]);
				} else if (!strncmp (token, "DprsSW", 6))
				{
					token = strpbrk(token,"=");
					token++;
					while (*token == 0x20) token++;
					if (!strncmp (token, "ON", 2))
					{
						DprsSW = TRUE;
					}
					if (debug) printf ("DprsSW : %s\n",token);
				} else if (!strncmp (token, "DprsBaudRate", 12))
				{
					token = strpbrk(token,"=");
					token++;
					while (*token == 0x20) token++;
					baud_rate = atoi(token);
					if (debug) printf ("DprsBaud : %d\n",baud_rate);
				} else {
					printf ("Config file error : %s\n\n",buf);
				}
			}
		}
	}
	fclose (cfg);
	if (debug) printf ("*** Debug Exit\n\n"); 
	return;
}

void	usage()
{
	printf ("Usage:\n");
	printf ("node [-d] [-i] [-f config_file]\n");
	printf (" -d : debug\n");
	printf (" -i : information\n");
	printf (" -f config_file : configure\n");
	exit (0);
}

void	AckNaksend (u_long ip_addr, int sw)
{
	struct inet_dv_packet header_pkt;
	int	seq, i;
	unsigned int	k;

	if (sw) header_pkt.rf_header.flags[0] = 0x00;
	else 	header_pkt.rf_header.flags[0] = 0x01;

	header_pkt.rf_header.flags[1] = 0x00;
	header_pkt.rf_header.flags[2] = 0x00;
	strncpy (header_pkt.rf_header.RPT2Call,NodeCallSave,8);
	strncpy (header_pkt.rf_header.RPT1Call,NodeCallSave,8);
	strncpy (header_pkt.rf_header.MyCall,NodeCallSave,8);
	strncpy (header_pkt.rf_header.MyCall2,"    ",4);
	strncpy (header_pkt.rf_header.YourCall,YourCallSave,8);
	header_pkt.rf_header.CRC[0] = 0x00;
	header_pkt.rf_header.CRC[1] = 0x00;

	addr_out.sin_port = htons(out_port_save);
	addr_out.sin_addr.s_addr = ip_addr;
	seq = 0;
	header_pkt.b_bone.seq_high = 0;
	header_pkt.b_bone.seq_low = 0;
	header_pkt.b_bone.id = header_type;
	if (sendto (sock_out, (char *)&header_pkt, 56, 0, (struct sockaddr *)&addr_out, sizeof(addr_out)) == SOCKET_ERROR)
	{
		printf("send error 1:%d %x\n",WSAGetLastError(),ip_addr);
		while (WSAGetLastError() == WSAENOBUFS)
		{
			Sleep (10);
			addr_out.sin_port = htons(out_port_save);
			addr_out.sin_addr.s_addr = ip_addr;
			sendto(sock_out, (char *)&header_pkt, 56, 0, (struct sockaddr *)&addr_out, sizeof(addr_out));
		}
	}

	Sleep (10);
	for (i = 0 ; i < 11 ; i++)
	{
		addr_out.sin_port = htons(out_port_save);
		addr_out.sin_addr.s_addr = ip_addr;
		header_pkt.b_bone.seq_high = seq >> 8;
		header_pkt.b_bone.seq_low = seq & 0xff;
		header_pkt.b_bone.id = dv_type;
		if (sw)strncpy (header_pkt.v_data.voice_segment, &ACKmsg[i][0], 12);
		else	strncpy (header_pkt.v_data.voice_segment, &NAKmsg[i][0], 12);
		if (sendto(sock_out, (char *)&header_pkt, 27, 0, (struct sockaddr *)&addr_out, sizeof(addr_out)) == SOCKET_ERROR)
		{
			printf("send error 2:%d %x\n",WSAGetLastError(),ip_addr);
			while (WSAGetLastError() == WSAENOBUFS)
			{
				Sleep (10);
				addr_out.sin_port = htons(out_port_save);
				addr_out.sin_addr.s_addr = ip_addr;
				sendto(sock_out, (char *)&header_pkt, 27, 0, (struct sockaddr *)&addr_out, sizeof(addr_out));
			}
		}
		Sleep (5);
		++seq;
	}

}

void	CONNECTsend (u_long ip_addr)
{
	struct inet_dv_packet header_pkt;
	int	seq, i;
	unsigned int	k;

	header_pkt.rf_header.flags[0] = 0x00;
	header_pkt.rf_header.flags[1] = 0x00;
	header_pkt.rf_header.flags[2] = 0x00;
	strncpy (header_pkt.rf_header.RPT2Call,table.node_table.callsign,8);
	strncpy (header_pkt.rf_header.RPT1Call,table.node_table.callsign,8);
	strncpy (header_pkt.rf_header.MyCall,table.node_table.callsign,8);
	strncpy (header_pkt.rf_header.MyCall2,"    ",4);
	strncpy (header_pkt.rf_header.YourCall,"CQCQCQ  ",8);
	header_pkt.rf_header.CRC[0] = 0x00;
	header_pkt.rf_header.CRC[1] = 0x00;

	addr_out.sin_port = htons(out_port_save);
	addr_out.sin_addr.s_addr = ip_addr;
	seq = 0;
	header_pkt.b_bone.seq_high = 0;
	header_pkt.b_bone.seq_low = 0;
	header_pkt.b_bone.id = header_type;
	if (sendto (sock_out, (char *)&header_pkt, 56, 0, (struct sockaddr *)&addr_out, sizeof(addr_out)) == SOCKET_ERROR)
	{
		printf("send error 1:%d %x\n",WSAGetLastError(),ip_addr);
		while (WSAGetLastError() == WSAENOBUFS)
		{
			Sleep (10);
			addr_out.sin_port = htons(out_port_save);
			addr_out.sin_addr.s_addr = ip_addr;
			sendto(sock_out, (char *)&header_pkt, 56, 0, (struct sockaddr *)&addr_out, sizeof(addr_out));
		}
	}

	Sleep (10);
	for (i = 0 ; i < 11 ; i++)
	{
		addr_out.sin_port = htons(out_port_save);
		addr_out.sin_addr.s_addr = ip_addr;
		header_pkt.b_bone.seq_high = seq >> 8;
		header_pkt.b_bone.seq_low = seq & 0xff;
		header_pkt.b_bone.id = dv_type;
		strncpy (header_pkt.v_data.voice_segment, &CONNECTmsg[i][0], 12);
		if (sendto(sock_out, (char *)&header_pkt, 27, 0, (struct sockaddr *)&addr_out, sizeof(addr_out)) == SOCKET_ERROR)
		{
			printf("send error 2:%d %x\n",WSAGetLastError(),ip_addr);
			while (WSAGetLastError() == WSAENOBUFS)
			{
				Sleep (10);
				addr_out.sin_port = htons(out_port_save);
				addr_out.sin_addr.s_addr = ip_addr;
				sendto(sock_out, (char *)&header_pkt, 27, 0, (struct sockaddr *)&addr_out, sizeof(addr_out));
			}
		}
		Sleep (5);
		++seq;
	}

}



/* DPRS data */ 
void	dprs(unsigned char s_data[])
{
	int	i, k;
	DWORD	writesize;

	/* check re-sync signal If so, skip this. */
	if ((s_data[0] == 0x55) && (s_data[1] == 0x2d) && (s_data[2] == 0x16))
	{
		slow_data_sw = FALSE;
		return;
	}

	if (slow_data_sw)
	{
		slow_data_buf[3] = s_data[0] ^ 0x70;
		slow_data_buf[4] = s_data[1] ^ 0x4f;
		slow_data_buf[5] = s_data[2] ^ 0x93;
		if ((slow_data_buf[0] & 0xf0) == 0x30)
		{
			k = slow_data_buf[0] & 0x0f;
			WriteFile (dprscomport, &slow_data_buf[1], k, &writesize, NULL);
			if (debug)
			{   		 
				for (i = 0 ; i < k ; i++)
				{
					printf ("%c",slow_data_buf[i+1]);	
				}
			}
		}
		slow_data_sw = FALSE;
	} else {
		slow_data_buf[0] = s_data[0] ^ 0x70;
		slow_data_buf[1] = s_data[1] ^ 0x4f;
		slow_data_buf[2] = s_data[2] ^ 0x93;
		slow_data_sw = TRUE;
	}
	return;
}

void	DprsComPortOpen ()
{
	dprscomport = CreateFile(DprsPortName, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL); 
	assert(dprscomport != INVALID_HANDLE_VALUE);

	ok = SetupComm(dprscomport, 128, 128); 
	ok = GetCommState(dprscomport, &dcb);
	dcb.BaudRate = baud_rate;
	dcb.ByteSize = 8;
	dcb.Parity = NOPARITY;
	dcb.StopBits = ONESTOPBIT;
	dcb.fAbortOnError = TRUE;
	ok = SetCommState(dprscomport, &dcb);
	return;
}
