/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: except.h,v 1.9 2003/12/20 06:51:58 takayuki Exp $
 */

// $Header: /home/CVS/configurator/base/except.h,v 1.9 2003/12/20 06:51:58 takayuki Exp $

#ifndef EXCEPT_H
#define EXCEPT_H

#ifdef _MSC_VER
#  pragma warning(disable:4290) //C++ 㳰λ̵뤵ޤؿ __declspec(nothrow) ǤʤȤΤɽޤ
#endif

//#include "testsuite.h"

#include <string>
#include <typeinfo>

    //㳰쥯饹
class Exception
{
private:
    static bool is_throwable;

protected:
    int         code;       //㳰
    std::string classname;  //㳰饹̾ ()
    std::string details;    //㳰

        //󥹥ȥ饯
    Exception(std::string classname = "Exception", int code = 0, std::string details = "") throw();
    Exception(std::string classname, std::string details) throw();

        //ǥȥ饯
public:
    Exception(const Exception & src) throw();

    virtual ~Exception(void) throw();

        //is-an-instance-ofطɾ
    inline bool isInstanceOf(const char * _classname) const throw()
    {   return classname.compare(_classname) == 0;   }

        //㳰ɤ
    inline int getCode(void) const throw()
    {   return code;   }

        //㳰
    inline std::string getDetails(void) const throw()
    {   return details;   }

        //ߤ㳰ե饰ξ֤˽ä㳰ȯԤ
    inline bool throwException(void)
    {
        if(is_throwable)
            throw *this;
        return is_throwable;
    }

        //is_throwableΥ
    static void setThrowControl(bool _throwable) throw()
    {   is_throwable = _throwable;   }

    static bool getThrowControl(void) throw()
    {   return is_throwable;   }


//  TESTSUITE_PROTOTYPE(main)
};


#define EXCEPTION(x)       class x : public Exception { public: x(void) throw() : Exception(#x)       {} };
#define EXCEPTION_(x,y)    class x : public Exception { public: x(void) throw() : Exception(#x, y)    {} };
#define EXCEPTION__(x,y,z) class x : public Exception { public: x(void) throw() : Exception(#x, y, z) {} };

#endif



