/*
 *  TOPPERS/OSEK Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      OSEK Kernel
 * 
 *  Copyright (C) 2004-2006 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	Tv^[QbgˑVXe^C}W[iLEGO MINDSTORMS NXTpj
 */


#include	"kernel.h"

/* LEJOS NXJ */
#include	"systick.h"


/* Originally, systick_low_priority_C is a LEJOS ISR. 
 * LEJOS-OSEK uses systick_isr_C1 category 2 ISR instead of systick_low_priority_C 
 * to implement a system timer module for OSEK alarm and 
 * check the buttons status to shutdown the system
 */
extern void systick_low_priority_C(void);

/* user_1ms_isr_type2 is invoked in an ISR category 2 and
 * published to users
 */
extern void user_1ms_isr_type2(void);

extern volatile U8 gStartOS_flag;
extern void ecrobot_checkExitButton(void);

void systick_isr_C1()
{

	/* OSEK was started */ 
	if (gStartOS_flag == 1)
	{
		user_1ms_isr_type2();

		ecrobot_checkExitButton();
	}

	/* this function should be here to stop the NXT immediately 
	 * after EXIT button was pressed
	 */
	systick_low_priority_C();

}

