/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.mklib;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.rpf.mklib.RawbitSerialIdTable;
import jp.nyatla.nyartoolkit.rpf.reality.nyartk.NyARReality;
import jp.nyatla.nyartoolkit.rpf.reality.nyartk.NyARRealityTarget;
import jp.nyatla.nyartoolkit.rpf.realitysource.nyartk.NyARRealitySource;

public class ASyncIdMarkerTable {
    private RawbitSerialIdTable _mklib = new RawbitSerialIdTable(1);
    private IResultListener _listener;

    public ASyncIdMarkerTable(IResultListener i_listener) throws NyARException {
        this._mklib.addAnyItem("ANY ID", 40.0);
        this._listener = i_listener;
    }

    private void callListener(boolean i_result, long i_serial, int i_dir, double i_width, long i_id) {
        this._listener.OnDetect(i_result, i_serial, i_dir, i_width, i_id);
    }

    public void requestAsyncMarkerDetect(NyARReality i_reality, NyARRealitySource i_source, NyARRealityTarget i_target) throws NyARException {
        NyARRgbRaster raster = new NyARRgbRaster(100, 100, 262402);
        i_reality.getRgbPatt2d(i_source, i_target.refTargetVertex(), 1, (INyARRgbRaster)raster);
        AsyncThread t = new AsyncThread(this, i_target.getSerialId(), raster);
        t.start();
    }

    private class AsyncThread
    extends Thread {
        private ASyncIdMarkerTable _parent;
        private long _serial;
        private NyARRgbRaster _source;

        public AsyncThread(ASyncIdMarkerTable i_parent, long i_serial, NyARRgbRaster i_raster) {
            this._parent = i_parent;
            this._serial = i_serial;
            this._source = i_raster;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean res;
                AsyncThread.sleep(3000L);
                RawbitSerialIdTable.IdentifyIdResult ret = new RawbitSerialIdTable.IdentifyIdResult();
                RawbitSerialIdTable rawbitSerialIdTable = this._parent._mklib;
                synchronized (rawbitSerialIdTable) {
                    NyARDoublePoint2d[] vx = NyARDoublePoint2d.createArray(4);
                    vx[0].x = 0.0;
                    vx[0].y = 0.0;
                    vx[1].x = 99.0;
                    vx[1].y = 0.0;
                    vx[2].x = 99.0;
                    vx[2].y = 99.0;
                    vx[3].x = 0.0;
                    vx[3].y = 99.0;
                    res = this._parent._mklib.identifyId(vx, this._source, ret);
                }
                this._parent.callListener(res, this._serial, ret.artk_direction, ret.marker_width, ret.id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface IResultListener {
        public void OnDetect(boolean var1, long var2, int var4, double var5, long var7);
    }
}

