/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import java.io.InputStream;
import java.util.ArrayList;
import jp.nyatla.nyar4psg.NyAR4PsgConfig;
import jp.nyatla.nyar4psg.NyARPsgBaseClass;
import jp.nyatla.nyar4psg.PImageRaster;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat_ARToolKit;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.markersystem.INyARMarkerSystemConfig;
import jp.nyatla.nyartoolkit.markersystem.NyARMarkerSystem;
import jp.nyatla.nyartoolkit.markersystem.NyARMarkerSystemConfig;
import jp.nyatla.nyartoolkit.markersystem.NyARSensor;
import processing.core.PApplet;
import processing.core.PGraphics3D;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix3D;
import processing.core.PVector;

public class MultiMarker
extends NyARPsgBaseClass {
    protected PImageSensor _ss;
    protected NyARMarkerSystem _ms;
    public static final double DEFAULT_CF_THRESHOLD = 0.51;
    public static final int DEFAULT_LOST_DELAY = 10;
    public static final int THLESHOLD_AUTO = -1;
    private ArrayList<Integer> _id_map = new ArrayList();
    private final PMatrix3D _ps_projection = new PMatrix3D();
    private PMatrix3D _old_matrix = null;

    public void setConfidenceThreshold(double i_val) {
        this._ms.setConfidenceThreshold(i_val);
    }

    public void setLostDelay(int i_val) {
        this._ms.setLostDelay(i_val);
    }

    public void setThreshold(int i_th) {
        int th = i_th == -1 ? Integer.MAX_VALUE : i_th;
        this._ms.setBinThreshold(th);
    }

    public int getCurrentThreshold() {
        return this.getCurrentThreshold();
    }

    public MultiMarker(PApplet parent, int i_width, int i_height, String i_cparam_file, NyAR4PsgConfig i_config) {
        try {
            NyARParam cp = NyARParam.createFromARParamFile((InputStream)parent.createInput(i_cparam_file));
            cp.changeScreenSize(i_width, i_height);
            this.initInstance(parent, cp, i_config);
        }
        catch (Exception e) {
            e.printStackTrace();
            parent.die("Catch an exception!");
        }
    }

    public MultiMarker(PApplet parent, int i_width, int i_height, String i_cparam_file) {
        try {
            NyARParam cp = NyARParam.createFromARParamFile((InputStream)parent.createInput(i_cparam_file));
            cp.changeScreenSize(i_width, i_height);
            this.initInstance(parent, cp, NyAR4PsgConfig.CONFIG_DEFAULT);
        }
        catch (Exception e) {
            e.printStackTrace();
            parent.die("Catch an exception!");
        }
    }

    public MultiMarker(PApplet parent, int i_width, int i_height, double[] i_intrinsic_matrix, double[] i_distortion_coeffs) {
        try {
            NyARParam cp = NyARParam.createFromCvCalibrateCamera2Result((int)i_width, (int)i_height, (double[])i_intrinsic_matrix, (double[])i_distortion_coeffs);
            cp.changeScreenSize(i_width, i_height);
            this.initInstance(parent, cp, NyAR4PsgConfig.CONFIG_DEFAULT);
        }
        catch (Exception e) {
            e.printStackTrace();
            parent.die("Catch an exception!");
        }
    }

    protected void initInstance(PApplet parent, NyARParam i_param, NyAR4PsgConfig i_config) throws NyARException {
        NyARIntSize s = i_param.getScreenSize();
        this._ss = new PImageSensor(new NyARIntSize(s.w, s.h));
        this._ms = new NyARMarkerSystem((INyARMarkerSystemConfig)new PsgMsCfg(i_param, i_config.env_transmat_mode));
        super.initInstance(parent, i_config);
    }

    @Override
    public PMatrix3D getProjectionMatrix() {
        return this._ps_projection;
    }

    @Override
    public PMatrix3D getProjectionMatrix(PMatrix3D i_buf) {
        return new PMatrix3D((PMatrix)this._ps_projection);
    }

    @Override
    public void setARClipping(float i_near, float i_far) {
        super.setARClipping(i_near, i_far);
        this._ms.setProjectionMatrixClipping((double)i_near, (double)i_far);
        NyARIntSize s = this._ms.getARParam().getScreenSize();
        NyARDoubleMatrix44 tmp = new NyARDoubleMatrix44();
        this._ms.getARParam().getPerspectiveProjectionMatrix().makeCameraFrustumRH((double)s.w, (double)s.h, (double)i_near, (double)i_far, tmp);
        MultiMarker.nyarMat2PsMat(tmp, this._ps_projection);
    }

    public void beginTransform(int i_id) {
        if (this._old_matrix != null) {
            this._ref_papplet.die("The function beginTransform is already called.", null);
        }
        if (!(this._ref_papplet.g instanceof PGraphics3D)) {
            this._ref_papplet.die("NyAR4Psg require PGraphics3D instance.");
        }
        this._old_matrix = new PMatrix3D((PMatrix)((PGraphics3D)this._ref_papplet.g).projection);
        this.setARPerspective();
        this._ref_papplet.pushMatrix();
        this._ref_papplet.setMatrix(this.getMarkerMatrix(i_id));
    }

    public void endTransform() {
        if (this._old_matrix == null) {
            this._ref_papplet.die("The function beginTransform is never called.", null);
        }
        this._ref_papplet.popMatrix();
        this.setPerspective(this._old_matrix);
        this._old_matrix = null;
    }

    public void detect(PImage i_image) {
        i_image.loadPixels();
        this.detectWithoutLoadPixels(i_image);
    }

    public void detectWithoutLoadPixels(PImage i_image) {
        try {
            this._ss.update(i_image);
            this._ms.update((NyARSensor)this._ss);
        }
        catch (Exception e) {
            e.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
    }

    public int addARMarker(String i_file_name, int i_patt_resolution, int i_edge_percentage, float i_width) {
        int psid = -1;
        try {
            this._id_map.add(this._ms.addARMarker(this._ref_papplet.createInput(i_file_name), i_patt_resolution, i_edge_percentage, (double)i_width));
            psid = this._id_map.size() - 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
        return psid;
    }

    public int addARMarker(String i_file_name, int i_patt_resolution, float i_width) {
        return this.addARMarker(i_file_name, i_patt_resolution, 25, i_width);
    }

    public int addARMarker(PImage i_img, int i_patt_resolution, int i_edge_percentage, float i_width) {
        int psid = -1;
        try {
            i_img.loadPixels();
            PImageRaster pr = new PImageRaster(i_img);
            this._id_map.add(this._ms.addARMarker((INyARRgbRaster)pr, i_patt_resolution, i_edge_percentage, (double)i_width));
            psid = this._id_map.size() - 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
        return psid;
    }

    public int addARMarker(String i_file_name, float i_width) {
        return this.addARMarker(i_file_name, 16, 25, i_width);
    }

    public int addNyIdMarker(int i_nyid, int i_width) {
        return this.addNyIdMarker(i_nyid, i_nyid, i_width);
    }

    public int addNyIdMarker(int i_nyid_range_s, int i_nyid_range_e, int i_width) {
        int psid = -1;
        try {
            this._id_map.add(this._ms.addNyIdMarker((long)i_nyid_range_s, (long)i_nyid_range_e, (double)i_width));
            psid = this._id_map.size() - 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
        return psid;
    }

    public int addPsARPlayCard(int i_psarid, int i_width) {
        int psid = -1;
        try {
            this._id_map.add(this._ms.addPsARPlayCard(i_psarid, (double)i_width));
            psid = this._id_map.size() - 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
        return psid;
    }

    public PVector[] getMarkerVertex2D(int i_id) {
        int msid = this._id_map.get(i_id);
        PVector[] r = new PVector[4];
        try {
            NyARIntPoint2d[] pos = this._ms.getMarkerVertex2D(msid);
            int i = 0;
            while (i < 4) {
                r[i] = new PVector((float)pos[i].x, (float)pos[i].y);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
        return r;
    }

    public PMatrix3D getMarkerMatrix(int i_id) {
        PMatrix3D p = new PMatrix3D();
        if (!this.isExistMarker(i_id)) {
            this._ref_papplet.die("Marker id " + i_id + " is not exist on image.", null);
        }
        int msid = this._id_map.get(i_id);
        try {
            MultiMarker.matResult2PMatrix3D(this._ms.getMarkerMatrix(msid), this._config._coordinate_system, p);
        }
        catch (Exception e) {
            e.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
        return p;
    }

    public double getConfidence(int i_id) {
        int msid = this._id_map.get(i_id);
        try {
            return this._ms.getConfidence(msid);
        }
        catch (Exception e) {
            this._ref_papplet.die("Marker id " + i_id + " is not AR Marker or not exist.", null);
            return Double.NaN;
        }
    }

    public long getNyId(int i_id) {
        int msid = this._id_map.get(i_id);
        try {
            return this._ms.getNyId(msid);
        }
        catch (Exception e) {
            this._ref_papplet.die("Marker id " + i_id + " is not NyId Marker or not exist.", null);
            return -1L;
        }
    }

    public boolean isExistMarker(int i_id) {
        int msid = this._id_map.get(i_id);
        try {
            return this._ms.isExistMarker(msid);
        }
        catch (Exception e) {
            this._ref_papplet.die("Catch an exception!", null);
            return false;
        }
    }

    public int getLostCount(int i_id) {
        if (!this.isExistMarker(i_id)) {
            this._ref_papplet.die("Marker id " + i_id + " is not on image.", null);
        }
        int msid = this._id_map.get(i_id);
        try {
            return (int)this._ms.getLostCount(msid);
        }
        catch (Exception e) {
            this._ref_papplet.die("Catch an exception!", null);
            return -1;
        }
    }

    public long getLife(int i_id) {
        try {
            if (!this.isExistMarker(i_id)) {
                this._ref_papplet.die("Marker id " + i_id + " is not on image.", null);
            }
            int msid = this._id_map.get(i_id);
            return this._ms.getLife(msid);
        }
        catch (Exception e) {
            this._ref_papplet.die("Catch an exception!", null);
            return -1L;
        }
    }

    public PVector marker2ScreenCoordSystem(int i_id, double i_x, double i_y, double i_z) {
        try {
            int msid = this._id_map.get(i_id);
            NyARDoublePoint2d pos = new NyARDoublePoint2d();
            this._ms.getScreenPos(msid, i_x, i_y, i_z, pos);
            PVector ret = new PVector();
            ret.x = (float)pos.x;
            ret.y = (float)pos.y;
            ret.z = 0.0f;
            return ret;
        }
        catch (Exception e) {
            this._ref_papplet.die("Catch an exception!", null);
            return null;
        }
    }

    public PVector screen2MarkerCoordSystem(int i_id, int i_x, int i_y) {
        try {
            int msid = this._id_map.get(i_id);
            PVector ret = new PVector();
            NyARDoublePoint3d tmp = new NyARDoublePoint3d();
            this._ms.getMarkerPlanePos(msid, i_x, i_y, tmp);
            ret.x = (float)tmp.x;
            ret.y = (float)tmp.y;
            ret.z = (float)tmp.z;
            if (this._config._coordinate_system == 1) {
                ret.x *= -1.0f;
            }
            return ret;
        }
        catch (Exception e) {
            this._ref_papplet.die("Catch an exception!", null);
            return null;
        }
    }

    public PImage pickupMarkerImage(int i_id, int i_x1, int i_y1, int i_x2, int i_y2, int i_x3, int i_y3, int i_x4, int i_y4, int i_out_w_pix, int i_out_h_pix) {
        PImage p = new PImage(i_out_w_pix, i_out_h_pix);
        try {
            PImageRaster pr = new PImageRaster(p);
            int msid = this._id_map.get(i_id);
            this._ms.getMarkerPlaneImage(msid, (NyARSensor)this._ss, (double)i_x1, (double)i_y1, (double)i_x2, (double)i_y2, (double)i_x3, (double)i_y3, (double)i_x4, (double)i_y4, (INyARRgbRaster)pr);
            p.updatePixels();
        }
        catch (Exception e) {
            this._ref_papplet.die("pickupMarkerImage failed.", null);
        }
        return p;
    }

    public PImage pickupRectMarkerImage(int i_id, int i_l, int i_t, int i_w, int i_h, int i_out_w_pix, int i_out_h_pix) {
        return this.pickupMarkerImage(i_id, i_l + i_w - 1, i_t + i_h - 1, i_l, i_t + i_h - 1, i_l, i_t, i_l + i_w - 1, i_t, i_out_w_pix, i_out_h_pix);
    }

    class PImageSensor
    extends NyARSensor {
        private PImageRaster _src;

        public PImageSensor(NyARIntSize i_size) throws NyARException {
            super(i_size);
            this._src = new PImageRaster(i_size.w, i_size.h);
        }

        public void update(PImage i_img) throws NyARException {
            this._src.wrapBuffer(i_img);
            super.update((INyARRgbRaster)this._src);
        }
    }

    class PsgMsCfg
    extends NyARMarkerSystemConfig {
        private int _tmat_type;

        public PsgMsCfg(NyARParam i_param, int i_tmat_type) throws NyARException {
            super(i_param);
            this._tmat_type = i_tmat_type;
        }

        public INyARTransMat createTransmatAlgorism() throws NyARException {
            switch (this._tmat_type) {
                case 0: {
                    return new NyARTransMat_ARToolKit(this._param);
                }
                case 1: {
                    return new NyARTransMat(this._param);
                }
            }
            throw new NyARException("Invalid Transmat algolism type.");
        }
    }
}

