/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.param;

import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARObserv2IdealMap {
    protected int _stride;
    protected double[] _mapx;
    protected double[] _mapy;

    public NyARObserv2IdealMap(NyARCameraDistortionFactor i_distfactor, NyARIntSize i_screen_size) {
        NyARDoublePoint2d opoint = new NyARDoublePoint2d();
        this._mapx = new double[i_screen_size.w * i_screen_size.h];
        this._mapy = new double[i_screen_size.w * i_screen_size.h];
        this._stride = i_screen_size.w;
        int ptr = i_screen_size.h * i_screen_size.w - 1;
        int i = i_screen_size.h - 1;
        while (i >= 0) {
            int i2 = i_screen_size.w - 1;
            while (i2 >= 0) {
                i_distfactor.observ2Ideal(i2, i, opoint);
                this._mapx[ptr] = opoint.x;
                this._mapy[ptr] = opoint.y;
                --ptr;
                --i2;
            }
            --i;
        }
    }

    public void observ2Ideal(int ix, int iy, NyARDoublePoint2d o_point) {
        int idx = ix + iy * this._stride;
        o_point.x = this._mapx[idx];
        o_point.y = this._mapy[idx];
    }

    public void observ2IdealBatch(int[] i_x_coord, int[] i_y_coord, int i_start, int i_num, double[] o_x_coord, double[] o_y_coord, int i_out_start_index) {
        int ptr = i_out_start_index;
        double[] mapx = this._mapx;
        double[] mapy = this._mapy;
        int stride = this._stride;
        int j = 0;
        while (j < i_num) {
            int idx = i_x_coord[i_start + j] + i_y_coord[i_start + j] * stride;
            o_x_coord[ptr] = mapx[idx];
            o_y_coord[ptr] = mapy[idx];
            ++ptr;
            ++j;
        }
    }
}

