/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter.gs2bin;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.gs2bin.INyARRasterFilter_Gs2Bin;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_ConstantThreshold
implements INyARRasterFilter_Gs2Bin {
    public int _threshold;

    public NyARRasterFilter_ConstantThreshold(int i_initial_threshold, int i_in_raster_type, int i_out_raster_type) throws NyARException {
        assert (i_in_raster_type == 262145);
        assert (i_out_raster_type == 262146);
        this._threshold = i_initial_threshold;
    }

    public NyARRasterFilter_ConstantThreshold() throws NyARException {
        this._threshold = 0;
    }

    public void setThreshold(int i_threshold) {
        this._threshold = i_threshold;
    }

    public void doFilter(NyARGrayscaleRaster i_input, NyARBinRaster i_output) throws NyARException {
        assert (i_input.getBufferType() == 262145);
        assert (i_output.getBufferType() == 262146);
        int[] out_buf = (int[])i_output.getBuffer();
        int[] in_buf = (int[])i_input.getBuffer();
        NyARIntSize s = i_input.getSize();
        int th = this._threshold;
        int bp = s.w * s.h - 1;
        int pix_count = s.h * s.w;
        int pix_mod_part = pix_count - pix_count % 8;
        bp = pix_count - 1;
        while (bp >= pix_mod_part) {
            out_buf[bp] = (in_buf[bp] & 0xFF) <= th ? 0 : 1;
            --bp;
        }
        while (bp >= 0) {
            out_buf[bp] = (in_buf[bp] & 0xFF) <= th ? 0 : 1;
            int n = (in_buf[--bp] & 0xFF) <= th ? 0 : 1;
            out_buf[bp] = n;
            int n2 = (in_buf[--bp] & 0xFF) <= th ? 0 : 1;
            out_buf[bp] = n2;
            int n3 = (in_buf[--bp] & 0xFF) <= th ? 0 : 1;
            out_buf[bp] = n3;
            int n4 = (in_buf[--bp] & 0xFF) <= th ? 0 : 1;
            out_buf[bp] = n4;
            int n5 = (in_buf[--bp] & 0xFF) <= th ? 0 : 1;
            out_buf[bp] = n5;
            int n6 = (in_buf[--bp] & 0xFF) <= th ? 0 : 1;
            out_buf[bp] = n6;
            int n7 = (in_buf[--bp] & 0xFF) <= th ? 0 : 1;
            out_buf[bp] = n7;
            --bp;
        }
    }
}

