/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pickup;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARRgbPixelDriver;
import jp.nyatla.nyartoolkit.core.pixeldriver.NyARRgbPixelDriverFactory;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARPerspectiveCopy;
import jp.nyatla.nyartoolkit.core.rasterdriver.NyARPerspectiveCopyFactory;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARColorPatt_Perspective
implements INyARColorPatt {
    private NyARIntPoint2d _edge = new NyARIntPoint2d();
    protected int[] _patdata;
    protected int _sample_per_pixel;
    protected NyARIntSize _size;
    private INyARRgbPixelDriver _pixelreader;
    private static final int BUFFER_FORMAT = 262402;
    private INyARRgbRaster _last_input_raster = null;
    private INyARPerspectiveCopy _raster_driver;

    private void initInstance(int i_width, int i_height, int i_point_per_pix) throws NyARException {
        assert (i_width > 2 && i_height > 2);
        this._sample_per_pixel = i_point_per_pix;
        this._size = new NyARIntSize(i_width, i_height);
        this._patdata = new int[i_height * i_width];
        this._pixelreader = NyARRgbPixelDriverFactory.createDriver(this);
    }

    public NyARColorPatt_Perspective(int i_width, int i_height, int i_point_per_pix) throws NyARException {
        this.initInstance(i_width, i_height, i_point_per_pix);
        this._edge.setValue(0, 0);
    }

    public NyARColorPatt_Perspective(int i_width, int i_height, int i_point_per_pix, int i_edge_percentage) throws NyARException {
        this.initInstance(i_width, i_height, i_point_per_pix);
        this._edge.setValue(i_edge_percentage, i_edge_percentage);
    }

    public void setEdgeSizeByPercent(int i_x_percent, int i_y_percent, int i_sample_per_pixel) {
        assert (i_x_percent >= 0);
        assert (i_y_percent >= 0);
        this._edge.setValue(i_x_percent, i_y_percent);
        this._sample_per_pixel = i_sample_per_pixel;
    }

    @Override
    public final int getWidth() {
        return this._size.w;
    }

    @Override
    public final int getHeight() {
        return this._size.h;
    }

    @Override
    public final NyARIntSize getSize() {
        return this._size;
    }

    @Override
    public final INyARRgbPixelDriver getRgbPixelDriver() {
        return this._pixelreader;
    }

    @Override
    public Object getBuffer() {
        return this._patdata;
    }

    @Override
    public boolean hasBuffer() {
        return this._patdata != null;
    }

    @Override
    public void wrapBuffer(Object i_ref_buf) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public final int getBufferType() {
        return 262402;
    }

    @Override
    public final boolean isEqualBufferType(int i_type_value) {
        return 262402 == i_type_value;
    }

    @Override
    public boolean pickFromRaster(INyARRgbRaster image, NyARIntPoint2d[] i_vertexs) throws NyARException {
        if (this._last_input_raster != image) {
            this._raster_driver = (INyARPerspectiveCopy)image.createInterface(INyARPerspectiveCopy.class);
            this._last_input_raster = image;
        }
        return this._raster_driver.copyPatt(i_vertexs, this._edge.x, this._edge.y, this._sample_per_pixel, (INyARRgbRaster)this);
    }

    @Override
    public Object createInterface(Class<?> iIid) throws NyARException {
        if (iIid == INyARPerspectiveCopy.class) {
            return NyARPerspectiveCopyFactory.createDriver(this);
        }
        if (iIid == NyARMatchPattDeviationColorData.IRasterDriver.class) {
            return NyARMatchPattDeviationColorData.RasterDriverFactory.createDriver(this);
        }
        throw new NyARException();
    }
}

