/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.detector;

import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattResult;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt_Color_WITHOUT_PCA;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.INyARRgb2GsFilterArtkTh;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARCoord2Linear;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARRectOffset;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARIntCoordinates;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.detector.NyARSingleDetectMarker_ARTKv2;
import jp.nyatla.nyartoolkit.detector.NyARSingleDetectMarker_NyARTK;
import jp.nyatla.nyartoolkit.detector.NyARSingleDetectMarker_NyARTK_FITTING_ARTKv2;

public abstract class NyARSingleDetectMarker {
    private INyARRgbRaster _last_input_raster = null;
    private INyARRgb2GsFilterArtkTh _bin_filter = null;
    protected INyARTransMat _transmat;
    protected INyARColorPatt _inst_patt;
    private NyARRectOffset _offset;
    private NyARMatchPattDeviationColorData _deviation_data;
    private NyARMatchPatt_Color_WITHOUT_PCA _match_patt;
    private NyARCoord2Linear _coordline;
    protected NyARBinRaster _bin_raster;
    private double _confidence = 0.0;
    protected NyARSquare _square = new NyARSquare();
    protected boolean _is_continue = false;
    private final NyARMatchPattResult __detectMarkerLite_mr = new NyARMatchPattResult();
    private NyARIntPoint2d[] __ref_vertex = new NyARIntPoint2d[4];
    public static final int PF_ARTOOLKIT_COMPATIBLE = 1;
    public static final int PF_NYARTOOLKIT = 2;
    public static final int PF_NYARTOOLKIT_ARTOOLKIT_FITTING = 100;
    public static final int PF_TEST2 = 201;

    public NyARSquare refSquare() {
        return this._square;
    }

    public double getConfidence() {
        return this._confidence;
    }

    public void setContinueMode(boolean i_is_continue) {
        this._is_continue = i_is_continue;
    }

    public void getTransmat(NyARTransMatResult o_result) throws NyARException {
        if (this._is_continue) {
            this._transmat.transMatContinue(this._square, this._offset, o_result, o_result);
        } else {
            this._transmat.transMat(this._square, this._offset, o_result);
        }
    }

    public void getTransmationMatrix(NyARTransMatResult o_result) throws NyARException {
        this.getTransmat(o_result);
    }

    public boolean detectMarkerLite(INyARRgbRaster i_raster, int i_th) throws NyARException {
        if (!this._bin_raster.getSize().isEqualSize(i_raster.getSize())) {
            throw new NyARException();
        }
        if (this._last_input_raster != i_raster) {
            this._bin_filter = (INyARRgb2GsFilterArtkTh)i_raster.createInterface(INyARRgb2GsFilterArtkTh.class);
            this._last_input_raster = i_raster;
        }
        this._bin_filter.doFilter(i_th, this._bin_raster);
        this._confidence = 0.0;
        this._last_input_raster = i_raster;
        this.execDetectMarker();
        return this._confidence != 0.0;
    }

    protected void updateSquareInfo(NyARIntCoordinates i_coord, int[] i_vertex_index) throws NyARException {
        NyARMatchPattResult mr = this.__detectMarkerLite_mr;
        NyARIntPoint2d[] vertex = this.__ref_vertex;
        vertex[0] = i_coord.items[i_vertex_index[0]];
        vertex[1] = i_coord.items[i_vertex_index[1]];
        vertex[2] = i_coord.items[i_vertex_index[2]];
        vertex[3] = i_coord.items[i_vertex_index[3]];
        if (!this._inst_patt.pickFromRaster(this._last_input_raster, vertex)) {
            return;
        }
        this._deviation_data.setRaster(this._inst_patt);
        if (!this._match_patt.evaluate(this._deviation_data, mr)) {
            return;
        }
        if (this._confidence > mr.confidence) {
            return;
        }
        NyARSquare sq = this._square;
        this._confidence = mr.confidence;
        int i = 0;
        while (i < 4) {
            int idx = (i + 4 - mr.direction) % 4;
            this._coordline.coord2Line(i_vertex_index[idx], i_vertex_index[(idx + 1) % 4], i_coord, sq.line[i]);
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (!sq.line[i].crossPos(sq.line[(i + 3) % 4], sq.sqvertex[i])) {
                throw new NyARException();
            }
            ++i;
        }
    }

    protected NyARSingleDetectMarker(NyARParam i_ref_param, NyARCode i_ref_code, double i_marker_width) throws NyARException {
        this._deviation_data = new NyARMatchPattDeviationColorData(i_ref_code.getWidth(), i_ref_code.getHeight());
        this._match_patt = new NyARMatchPatt_Color_WITHOUT_PCA(i_ref_code);
        this._offset = new NyARRectOffset();
        this._offset.setSquare(i_marker_width);
        this._coordline = new NyARCoord2Linear(i_ref_param.getScreenSize(), i_ref_param.getDistortionFactor());
        NyARIntSize s = i_ref_param.getScreenSize();
        this._bin_raster = new NyARBinRaster(s.w, s.h);
    }

    protected abstract void execDetectMarker() throws NyARException;

    public static NyARSingleDetectMarker createInstance(NyARParam i_param, NyARCode i_code, double i_marker_width, int i_profile_id) throws NyARException {
        switch (i_profile_id) {
            case 1: {
                return new NyARSingleDetectMarker_ARTKv2(i_param, i_code, i_marker_width);
            }
            case 100: {
                return new NyARSingleDetectMarker_NyARTK_FITTING_ARTKv2(i_param, i_code, i_marker_width);
            }
            case 2: {
                return new NyARSingleDetectMarker_NyARTK(i_param, i_code, i_marker_width);
            }
        }
        throw new NyARException();
    }

    public static NyARSingleDetectMarker createInstance(NyARParam i_param, NyARCode i_code, double i_marker_width) throws NyARException {
        return NyARSingleDetectMarker.createInstance(i_param, i_code, i_marker_width, 2);
    }
}

