/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core2.rasteranalyzer;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARBufferReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntRect;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.stack.NyARIntRectStack;

public class NyARRasterDetector_QrCodeEdge {
    private NyARIntRectStack _result;

    public NyARRasterDetector_QrCodeEdge(int i_result_max) {
        this._result = new NyARIntRectStack(i_result_max);
    }

    public NyARIntRectStack geResult() {
        return this._result;
    }

    private boolean check_w1(int i_w1) {
        return i_w1 >= 1;
    }

    private boolean check_b1(int i_b1) {
        return i_b1 >= 2;
    }

    private boolean check_w2(int i_b1, int i_w2) {
        int v = i_w2 * 100 / i_b1;
        return 30 <= v && v <= 170;
    }

    private boolean check_b2(int i_b1, int i_b2) {
        int v = i_b2 * 100 / i_b1;
        return 200 <= v && v <= 400;
    }

    private boolean check_w3(int i_w2, int i_w3) {
        int v = i_w3 * 100 / i_w2;
        return 50 <= v && v <= 150;
    }

    private boolean check_b3(int i_b3, int i_b1) {
        int v = i_b3 * 100 / i_b1;
        return 50 <= v && v <= 150;
    }

    public void analyzeRaster(INyARRaster i_input) throws NyARException {
        INyARBufferReader buffer_reader = i_input.getBufferReader();
        assert (buffer_reader.isEqualBufferType(262146));
        this._result.clear();
        NyARIntSize size = i_input.getSize();
        int x = 0;
        int b3 = 0;
        int w3 = 0;
        int b2 = 0;
        int w2 = 0;
        int b1 = 0;
        int w1 = 0;
        int[] raster_buf = (int[])buffer_reader.getBuffer();
        int b2_spos = 0;
        int y = size.h - 1 - 8;
        while (y >= 8) {
            int line_ptr = y * size.w;
            x = size.w - 1;
            int s_pos = 0;
            int token_id = 0;
            block10: while (x >= 0) {
                block0 : switch (token_id) {
                    case 0: {
                        w1 = 0;
                        while (x >= 0) {
                            if (raster_buf[line_ptr + x] == 0) {
                                if (this.check_w1(w1)) {
                                    token_id = 1;
                                    break block0;
                                }
                            } else {
                                ++w1;
                            }
                            --x;
                        }
                        continue block10;
                    }
                    case 1: {
                        b1 = 0;
                        s_pos = x;
                        while (x >= 0) {
                            if (raster_buf[line_ptr + x] > 0) {
                                if (!this.check_b1(b1)) {
                                    token_id = 0;
                                    break block0;
                                }
                                token_id = 2;
                                break block0;
                            }
                            ++b1;
                            --x;
                        }
                        continue block10;
                    }
                    case 2: {
                        w2 = 0;
                        while (x >= 0) {
                            if (raster_buf[line_ptr + x] == 0) {
                                if (!this.check_w2(b1, w2)) {
                                    w1 = w2;
                                    token_id = 1;
                                    break block0;
                                }
                                token_id = 3;
                                break block0;
                            }
                            ++w2;
                            --x;
                        }
                        continue block10;
                    }
                    case 3: {
                        b2 = 0;
                        b2_spos = x;
                        while (x >= 0) {
                            if (raster_buf[line_ptr + x] > 0) {
                                if (!this.check_b2(b1, b2)) {
                                    if (this.check_w1(w2) && this.check_b1(b2)) {
                                        w1 = w2;
                                        b1 = b2;
                                        s_pos = b2_spos;
                                        token_id = 2;
                                        break block0;
                                    }
                                    token_id = 0;
                                    break block0;
                                }
                                token_id = 4;
                                break block0;
                            }
                            ++b2;
                            --x;
                        }
                        continue block10;
                    }
                    case 4: {
                        w3 = 0;
                        while (x >= 0) {
                            if (raster_buf[line_ptr + x] == 0) {
                                if (!this.check_w3(w2, w3)) {
                                    if (this.check_w1(w2) && this.check_b1(b2)) {
                                        w1 = w2;
                                        b1 = b2;
                                        s_pos = b2_spos;
                                        token_id = 2;
                                        break block0;
                                    }
                                    token_id = 0;
                                    break block0;
                                }
                                token_id = 5;
                                break block0;
                            }
                            ++w3;
                            --x;
                        }
                        continue block10;
                    }
                    case 5: {
                        b3 = 0;
                        int b3_spos = x;
                        while (x >= 0) {
                            if (raster_buf[line_ptr + x] > 0) {
                                if (!this.check_b3(b3, b1)) {
                                    if (this.check_w1(w2) && this.check_b1(b2)) {
                                        w1 = w3;
                                        b1 = b3;
                                        s_pos = b3_spos;
                                        token_id = 2;
                                        break block0;
                                    }
                                    token_id = 0;
                                    break block0;
                                }
                                token_id = 10;
                                break block0;
                            }
                            ++b3;
                            --x;
                        }
                        continue block10;
                    }
                    case 10: {
                        NyARIntRect item = (NyARIntRect)this._result.prePush();
                        item.x = x;
                        item.y = y;
                        item.w = s_pos - x;
                        item.h = 0;
                        token_id = 0;
                        break;
                    }
                    default: {
                        throw new NyARException();
                    }
                }
            }
            --y;
        }
    }
}

