/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.analyzer.raster.NyARRasterAnalyzer_Histogram;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.NyARRasterFilter_CustomToneTable;
import jp.nyatla.nyartoolkit.core.types.NyARHistogram;

public class NyARRasterFilter_EqualizeHist
extends NyARRasterFilter_CustomToneTable {
    private NyARRasterAnalyzer_Histogram _hist_analyzer;
    private NyARHistogram _histogram = new NyARHistogram(256);

    public NyARRasterFilter_EqualizeHist(int i_raster_type, int i_sample_interval) throws NyARException {
        super(i_raster_type);
        this._hist_analyzer = new NyARRasterAnalyzer_Histogram(i_raster_type, i_sample_interval);
    }

    public void doFilter(INyARRaster i_input, INyARRaster i_output) throws NyARException {
        NyARHistogram hist = this._histogram;
        this._hist_analyzer.analyzeRaster(i_input, hist);
        int hist_total = this._histogram.total_of_data;
        int min = hist.getMinData();
        int hist_size = this._histogram.length;
        int sum = 0;
        int i = 0;
        while (i < hist_size) {
            this.table[i] = ((sum += hist.data[i]) - min) * (hist_size - 1) / (hist_total - min);
            ++i;
        }
        super.doFilter(i_input, i_output);
    }
}

