/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.INyARRasterFilter;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_Roberts
implements INyARRasterFilter {
    private IdoFilterImpl _do_filter_impl;

    public NyARRasterFilter_Roberts(int i_raster_type) throws NyARException {
        switch (i_raster_type) {
            case 262145: {
                this._do_filter_impl = new IdoFilterImpl_GRAY_8();
                break;
            }
            default: {
                throw new NyARException();
            }
        }
    }

    public void doFilter(INyARRaster i_input, INyARRaster i_output) throws NyARException {
        this._do_filter_impl.doFilter(i_input, i_output, i_input.getSize());
    }

    static interface IdoFilterImpl {
        public void doFilter(INyARRaster var1, INyARRaster var2, NyARIntSize var3) throws NyARException;
    }

    class IdoFilterImpl_GRAY_8
    implements IdoFilterImpl {
        IdoFilterImpl_GRAY_8() {
        }

        public void doFilter(INyARRaster i_input, INyARRaster i_output, NyARIntSize i_size) throws NyARException {
            assert (i_input.isEqualBufferType(262145));
            assert (i_output.isEqualBufferType(262145));
            int[] in_ptr = (int[])i_input.getBuffer();
            int[] out_ptr = (int[])i_output.getBuffer();
            int width = i_size.w;
            int height = i_size.h;
            int y = 0;
            while (y < height - 1) {
                int idx = y * width;
                int p00 = in_ptr[idx];
                int p10 = in_ptr[width + idx];
                int x = 0;
                while (x < width - 1) {
                    int p01 = in_ptr[idx + 1];
                    int p11 = in_ptr[idx + width + 1];
                    int fx = p11 - p00;
                    int fy = p10 - p01;
                    out_ptr[idx] = (int)Math.sqrt(fx * fx + fy * fy) >> 1;
                    p00 = p01;
                    p10 = p11;
                    ++idx;
                    ++x;
                }
                ++y;
            }
        }
    }
}

