/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core2.rasteranalyzer.threshold;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARBufferReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core2.rasteranalyzer.threshold.INyARRasterThresholdAnalyzer;

public class NyARRasterThresholdAnalyzer_PTile
implements INyARRasterThresholdAnalyzer {
    private int _persentage;
    private int _threshold;

    public NyARRasterThresholdAnalyzer_PTile(int i_persentage) {
        assert (-100 <= i_persentage && i_persentage <= 100);
        this._persentage = i_persentage;
    }

    private int createHistgram(INyARBufferReader i_reader, NyARIntSize i_size, int[] o_histgram) throws NyARException {
        int i;
        int[] in_buf = (int[])i_reader.getBuffer();
        int[] histgram = o_histgram;
        int i2 = 0;
        while (i2 < 256) {
            histgram[i2] = 0;
            ++i2;
        }
        int sum = 0;
        int y = 0;
        while (y < i_size.h) {
            int sum2 = 0;
            int x = 0;
            while (x < i_size.w) {
                int v;
                int n = v = in_buf[y * i_size.w + x];
                histgram[n] = histgram[n] + 1;
                sum2 += v;
                ++x;
            }
            sum += sum2 / i_size.w;
            ++y;
        }
        int th_pixcels = i_size.w * i_size.h * this._persentage / 100;
        if (th_pixcels > 0) {
            i = 0;
            while (i < 254) {
                if ((th_pixcels -= histgram[i]) > 0) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            i = 255;
            while (i > 1) {
                if ((th_pixcels += histgram[i]) < 0) {
                    --i;
                    continue;
                }
                break;
            }
        }
        return i;
    }

    public void analyzeRaster(INyARRaster i_input) throws NyARException {
        INyARBufferReader buffer_reader = i_input.getBufferReader();
        assert (buffer_reader.isEqualBufferType(262145));
        int[] histgram = new int[256];
        this._threshold = this.createHistgram(buffer_reader, i_input.getSize(), histgram);
    }

    public void debugDrawHistgramMap(INyARRaster i_input, INyARRaster i_output) throws NyARException {
        INyARBufferReader in_buffer_reader = i_input.getBufferReader();
        INyARBufferReader out_buffer_reader = i_output.getBufferReader();
        assert (in_buffer_reader.isEqualBufferType(262145));
        assert (out_buffer_reader.isEqualBufferType(262145));
        NyARIntSize size = i_output.getSize();
        int[] out_buf = (int[])out_buffer_reader.getBuffer();
        int y = 0;
        while (y < size.h) {
            int x = 0;
            while (x < size.w) {
                out_buf[y * size.w + x] = 0;
                ++x;
            }
            ++y;
        }
        int[] histgram = new int[256];
        int threshold = this.createHistgram(in_buffer_reader, i_input.getSize(), histgram);
        int max_v = 0;
        int i = 0;
        while (i < 255) {
            if (max_v < histgram[i]) {
                max_v = histgram[i];
            }
            ++i;
        }
        i = 0;
        while (i < size.h) {
            out_buf[i * size.w + 0] = 128;
            out_buf[i * size.w + 128] = 128;
            out_buf[i * size.w + 255] = 128;
            ++i;
        }
        i = 0;
        while (i < 255) {
            out_buf[histgram[i] * (size.h - 1) / max_v * size.w + i] = 255;
            ++i;
        }
        i = 0;
        while (i < size.h) {
            out_buf[i * size.w + threshold] = 255;
            ++i;
        }
    }

    public int getThreshold() {
        return this._threshold;
    }

    public int getThreshold(int i_x, int i_y) {
        return this._threshold;
    }
}

