/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core2.rasterfilter.gs2bin;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.INyARRasterFilter_GsToBin;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_Threshold
implements INyARRasterFilter_GsToBin {
    private int _threshold;

    public NyARRasterFilter_Threshold(int i_threshold) {
        this._threshold = i_threshold;
    }

    public void doFilter(NyARGrayscaleRaster i_input, NyARBinRaster i_output) throws NyARException {
        assert (i_input.getSize().isEqualSize(i_output.getSize()));
        int[] out_buf = (int[])i_output.getBufferReader().getBuffer();
        int[] in_buf = (int[])i_input.getBufferReader().getBuffer();
        int bp = 0;
        NyARIntSize size = i_output.getSize();
        int y = 0;
        while (y < size.h - 1) {
            int x = 0;
            while (x < size.w) {
                out_buf[y * size.w + x] = in_buf[y * size.w + x] >= this._threshold ? 1 : 0;
                bp += 3;
                ++x;
            }
            ++y;
        }
    }

    public void setThreshold(int i_threshold) {
        this._threshold = i_threshold;
    }
}

