/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.utils;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.rpf.utils.INyARGsRasterGraphics;

class NyARGsRasterGraphics_GS_INT8
implements INyARGsRasterGraphics {
    private INyARGrayscaleRaster _raster;

    public NyARGsRasterGraphics_GS_INT8(INyARGrayscaleRaster i_raster) {
        this._raster = i_raster;
    }

    @Override
    public void fill(int i_value) {
        int[] buf = (int[])this._raster.getBuffer();
        NyARIntSize s = this._raster.getSize();
        int i = s.h * s.w - 1;
        while (i >= 0) {
            buf[i] = i_value;
            --i;
        }
    }

    @Override
    public void copyTo(int i_left, int i_top, int i_skip, INyARGrayscaleRaster o_output) throws NyARException {
        assert (this._raster.getSize().isInnerSize(i_left + o_output.getWidth() * i_skip, i_top + o_output.getHeight() * i_skip));
        int[] input = (int[])this._raster.getBuffer();
        switch (o_output.getBufferType()) {
            case 262145: {
                int[] output = (int[])o_output.getBuffer();
                NyARIntSize dest_size = o_output.getSize();
                NyARIntSize src_size = this._raster.getSize();
                int skip_src_y = src_size.w - dest_size.w * i_skip + src_size.w * (i_skip - 1);
                int pix_count = dest_size.w;
                int pix_mod_part = pix_count - pix_count % 8;
                int pt_dst = 0;
                int pt_src = i_top * src_size.w + i_left;
                int y = dest_size.h - 1;
                while (y >= 0) {
                    int x = pix_count - 1;
                    while (x >= pix_mod_part) {
                        output[pt_dst++] = input[pt_src];
                        pt_src += i_skip;
                        --x;
                    }
                    while (x >= 0) {
                        output[pt_dst++] = input[pt_src];
                        output[pt_dst++] = input[pt_src += i_skip];
                        output[pt_dst++] = input[pt_src += i_skip];
                        output[pt_dst++] = input[pt_src += i_skip];
                        output[pt_dst++] = input[pt_src += i_skip];
                        output[pt_dst++] = input[pt_src += i_skip];
                        output[pt_dst++] = input[pt_src += i_skip];
                        output[pt_dst++] = input[pt_src += i_skip];
                        pt_src += i_skip;
                        x -= 8;
                    }
                    pt_src += skip_src_y;
                    --y;
                }
                return;
            }
        }
        throw new NyARException();
    }
}

