/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter.gs;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.gs.INyARGsCustomToneTableFilter;
import jp.nyatla.nyartoolkit.core.rasterfilter.gs.INyARGsToneTableFilter;
import jp.nyatla.nyartoolkit.core.rasterfilter.gs.NyARGsFilterFactory;

class NyARGsToneTableFilter
implements INyARGsToneTableFilter {
    private int[] _table = new int[256];
    private INyARGsCustomToneTableFilter _tone_filter;

    public NyARGsToneTableFilter(INyARGrayscaleRaster i_raster) throws NyARException {
        this._tone_filter = NyARGsFilterFactory.createCustomToneTableFilter(i_raster);
    }

    @Override
    public void line(int i_x, int i_y, double i_a, INyARGrayscaleRaster i_output) throws NyARException {
        if (i_a == 0.0) {
            int i = 0;
            while (i <= i_x) {
                this._table[i] = 0;
                ++i;
            }
            i = 0;
            while (i < 256) {
                this._table[i] = 255;
                ++i;
            }
        } else {
            int b = i_y - (int)(i_a * (double)i_x);
            int i = 0;
            while (i < 256) {
                int v = (int)(i_a * (double)i) + b;
                this._table[i] = v < 0 ? 0 : (v > 255 ? 255 : v);
                ++i;
            }
        }
        this._tone_filter.doFilter(this._table, i_output);
    }

    @Override
    public void line(double i_a, INyARGrayscaleRaster i_output) throws NyARException {
        this.line(0, 0, i_a, i_output);
    }

    @Override
    public void sigmoid(int i_x, int i_y, double i_gain, INyARGrayscaleRaster i_output) throws NyARException {
        int i = 0;
        while (i < 256) {
            int v = 255 * (int)(1.0 / (1.0 + Math.exp(i_gain * (double)(i - i_x))) - 0.5) + i_y;
            this._table[i] = v < 0 ? 0 : (v > 255 ? 255 : v);
            ++i;
        }
        this._tone_filter.doFilter(this._table, i_output);
    }

    @Override
    public void gamma(double i_gamma, INyARGrayscaleRaster i_output) throws NyARException {
        int i = 0;
        while (i < 256) {
            this._table[i] = (int)(Math.pow((double)i / 255.0, i_gamma) * 255.0);
            ++i;
        }
        this._tone_filter.doFilter(this._table, i_output);
    }
}

