/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.sampler.lrlabel;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntRect;
import jp.nyatla.nyartoolkit.core.types.stack.NyARPointerStack;
import jp.nyatla.nyartoolkit.core.utils.NyARManagedObject;
import jp.nyatla.nyartoolkit.core.utils.NyARManagedObjectPool;

public class LowResolutionLabelingSamplerOut {
    private AreaPool _pool;
    private AreaStack _stack;

    public LowResolutionLabelingSamplerOut(int i_length) throws NyARException {
        this._pool = new AreaPool(i_length);
        this._stack = new AreaStack(i_length);
    }

    public void initializeParams() {
        Item[] items = (Item[])this._stack.getArray();
        int i = this._stack.getLength() - 1;
        while (i >= 0) {
            items[i].releaseObject();
            items[i] = null;
            --i;
        }
        this._stack.clear();
    }

    public Item prePush() throws NyARException {
        Item result = (Item)this._pool.newObject();
        if (result == null) {
            return null;
        }
        if (this._stack.push(result) == null) {
            result.releaseObject();
            return null;
        }
        return result;
    }

    public Item[] getArray() {
        return (Item[])this._stack.getArray();
    }

    public int getLength() {
        return this._stack.getLength();
    }

    private class AreaPool
    extends NyARManagedObjectPool<Item> {
        public AreaPool(int i_length) throws NyARException {
            super.initInstance(i_length, Item.class);
        }

        @Override
        protected Item createElement() {
            return new Item(this._op_interface);
        }
    }

    private class AreaStack
    extends NyARPointerStack<Item> {
        public AreaStack(int i_length) throws NyARException {
            super.initInstance(i_length, Item.class);
        }
    }

    public class Item
    extends NyARManagedObject {
        public NyARIntPoint2d entry_pos;
        public NyARIntRect base_area;
        public NyARIntPoint2d base_area_center;
        public int base_area_sq_diagonal;
        public int lebeling_th;

        public Item(NyARManagedObject.INyARManagedObjectPoolOperater i_pool) {
            super(i_pool);
            this.entry_pos = new NyARIntPoint2d();
            this.base_area = new NyARIntRect();
            this.base_area_center = new NyARIntPoint2d();
        }
    }
}

