/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import jp.nyatla.nyar4psg.PImageRaster;
import jp.nyatla.nyar4psg.SingleMarkerBaseClass;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.detector.NyARSingleDetectMarker;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class NyARBoard
extends SingleMarkerBaseClass {
    public int lostDelay = 10;
    public int lostCount = 0;
    public double cfThreshold = 0.4;
    public double confidence = 0.0;
    public int gsThreshold = 110;
    private final NyARTransMatResult _result = new NyARTransMatResult();
    private NyARSingleDetectMarker _nya;
    private PImageRaster _raster;

    public NyARBoard(PApplet parent, int i_width, int i_height, String i_cparam, String i_patt, int i_patt_width, int i_projection_coord_system) {
        super(parent, i_cparam, i_width, i_height, i_projection_coord_system);
        this.initInstance(i_width, i_height, i_patt, i_patt_width);
    }

    public NyARBoard(PApplet parent, int i_width, int i_height, String i_cparam, String i_patt, int i_patt_width) {
        super(parent, i_cparam, i_width, i_height, 1);
        this.initInstance(i_width, i_height, i_patt, i_patt_width);
    }

    private void initInstance(int i_width, int i_height, String i_patt, int i_patt_width) {
        try {
            this.angle = new PVector();
            this.trans = new PVector();
            this.pos2d = new int[4][2];
            this.transmat = new double[16];
            this._raster = new PImageRaster(i_width, i_height);
            NyARCode code = new NyARCode(16, 16);
            code.loadARPatt(this._pa.createInput(i_patt));
            this._nya = new NyARSingleDetectMarker(this._ar_param, code, (double)i_patt_width, this._raster.getBufferType());
        }
        catch (NyARException e) {
            this._pa.die("Error while setting up NyARToolkit for java", (Exception)((Object)e));
        }
    }

    public boolean detect(PImage i_image) {
        boolean is_marker_exist = false;
        try {
            double cf;
            this._raster.wrapBuffer(i_image);
            is_marker_exist = this._nya.detectMarkerLite((INyARRgbRaster)this._raster, this.gsThreshold);
            if (is_marker_exist && (cf = this._nya.getConfidence()) < this.cfThreshold) {
                is_marker_exist = false;
            }
            if (is_marker_exist) {
                this.confidence = this._nya.getConfidence();
                this.lostCount = 0;
                this._nya.getTransmationMatrix(this._result);
                this.updateTransmat(this._nya.refSquare(), this._result);
            } else if (this.lostCount < this.lostDelay) {
                ++this.lostCount;
                is_marker_exist = true;
            } else {
                is_marker_exist = false;
            }
            return is_marker_exist;
        }
        catch (NyARException e) {
            this._pa.die("Error while marker detecting up NyARToolkit for java", (Exception)((Object)e));
            return is_marker_exist;
        }
    }
}

