/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.INyARRasterFilter_Rgb2Gs;
import jp.nyatla.nyartoolkit.core.types.NyARIntRect;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_Rgb2Gs_RgbAve192
implements INyARRasterFilter_Rgb2Gs {
    protected IdoThFilterImpl _do_filter_impl;

    public NyARRasterFilter_Rgb2Gs_RgbAve192(int i_in_raster_type, int i_out_raster_type) throws NyARException {
        if (!this.initInstance(i_in_raster_type, i_out_raster_type)) {
            throw new NyARException();
        }
    }

    public NyARRasterFilter_Rgb2Gs_RgbAve192(int i_in_raster_type) throws NyARException {
        if (!this.initInstance(i_in_raster_type, 262145)) {
            throw new NyARException();
        }
    }

    protected boolean initInstance(int i_in_raster_type, int i_out_raster_type) {
        block0 : switch (i_out_raster_type) {
            case 262145: {
                switch (i_in_raster_type) {
                    case 65537: 
                    case 65538: {
                        this._do_filter_impl = new doThFilterImpl_BYTE1D_B8G8R8_24();
                        break block0;
                    }
                    case 65793: {
                        this._do_filter_impl = new doThFilterImpl_BYTE1D_B8G8R8X8_32();
                        break block0;
                    }
                    case 262402: {
                        this._do_filter_impl = new doThFilterImpl_BUFFERFORMAT_INT1D_X8R8G8B8_32();
                        break block0;
                    }
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void doFilter(INyARRgbRaster i_input, NyARGrayscaleRaster i_output) throws NyARException {
        assert (i_input.getSize().isEqualSize(i_output.getSize()));
        NyARIntSize s = i_input.getSize();
        this._do_filter_impl.doFilter(i_input, (int[])i_output.getBuffer(), 0, 0, s.w, s.h);
    }

    public void doFilter(INyARRgbRaster i_input, NyARIntRect i_rect, NyARGrayscaleRaster i_output) throws NyARException {
        assert (i_input.getSize().isEqualSize(i_output.getSize()));
        this._do_filter_impl.doFilter(i_input, (int[])i_output.getBuffer(), i_rect.x, i_rect.y, i_rect.w, i_rect.h);
    }

    public void doCutFilter(INyARRgbRaster i_input, int i_left, int i_top, int i_skip, NyARGrayscaleRaster i_output) throws NyARException {
        this._do_filter_impl.doCutFilter(i_input, i_left, i_top, i_skip, i_output);
    }

    protected static interface IdoThFilterImpl {
        public void doFilter(INyARRaster var1, int[] var2, int var3, int var4, int var5, int var6) throws NyARException;

        public void doCutFilter(INyARRaster var1, int var2, int var3, int var4, NyARGrayscaleRaster var5) throws NyARException;
    }

    private class doThFilterImpl_BUFFERFORMAT_INT1D_X8R8G8B8_32
    implements IdoThFilterImpl {
        private doThFilterImpl_BUFFERFORMAT_INT1D_X8R8G8B8_32() {
        }

        @Override
        public void doCutFilter(INyARRaster i_input, int l, int t, int i_st, NyARGrayscaleRaster o_output) throws NyARException {
            assert (i_input.isEqualBufferType(262402));
            assert (i_input.getSize().isInnerSize(l + o_output.getWidth() * i_st, t + o_output.getHeight() * i_st));
            int[] input = (int[])i_input.getBuffer();
            int[] output = (int[])o_output.getBuffer();
            NyARIntSize dest_size = o_output.getSize();
            NyARIntSize src_size = i_input.getSize();
            int skip_src_y = src_size.w - dest_size.w * i_st + src_size.w * (i_st - 1);
            int skip_src_x = i_st;
            int pix_count = dest_size.w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt_dst = 0;
            int pt_src = t * src_size.w + l;
            int y = dest_size.h - 1;
            while (y >= 0) {
                int v;
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    pt_src += skip_src_x;
                    --x;
                }
                while (x >= 0) {
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    pt_src += skip_src_x;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    pt_src += skip_src_x;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    pt_src += skip_src_x;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    pt_src += skip_src_x;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    pt_src += skip_src_x;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    pt_src += skip_src_x;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    pt_src += skip_src_x;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    pt_src += skip_src_x;
                    x -= 8;
                }
                pt_src += skip_src_y;
                --y;
            }
        }

        @Override
        public void doFilter(INyARRaster i_input, int[] o_output, int l, int t, int w, int h) {
            int row_padding_dst;
            assert (i_input.isEqualBufferType(262402));
            NyARIntSize size = i_input.getSize();
            int[] in_buf = (int[])i_input.getBuffer();
            int bp = l + t * size.w;
            int b = t + h;
            int row_padding_src = row_padding_dst = size.w - w;
            int pix_count = w;
            int pix_mod_part = pix_count - pix_count % 8;
            int src_ptr = t * size.w + l;
            int y = t;
            while (y < b) {
                int v;
                int x = 0;
                x = pix_count - 1;
                while (x >= pix_mod_part) {
                    v = in_buf[src_ptr++];
                    o_output[bp++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    --x;
                }
                while (x >= 0) {
                    v = in_buf[src_ptr++];
                    o_output[bp++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    v = in_buf[src_ptr++];
                    o_output[bp++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    v = in_buf[src_ptr++];
                    o_output[bp++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    v = in_buf[src_ptr++];
                    o_output[bp++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    v = in_buf[src_ptr++];
                    o_output[bp++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    v = in_buf[src_ptr++];
                    o_output[bp++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    v = in_buf[src_ptr++];
                    o_output[bp++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    v = in_buf[src_ptr++];
                    o_output[bp++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                    x -= 8;
                }
                bp += row_padding_dst;
                src_ptr += row_padding_src;
                ++y;
            }
        }
    }

    private class doThFilterImpl_BYTE1D_B8G8R8X8_32
    implements IdoThFilterImpl {
        private doThFilterImpl_BYTE1D_B8G8R8X8_32() {
        }

        @Override
        public void doCutFilter(INyARRaster i_input, int l, int t, int i_st, NyARGrayscaleRaster o_output) throws NyARException {
            NyARException.notImplement();
        }

        @Override
        public void doFilter(INyARRaster i_input, int[] o_output, int l, int t, int w, int h) throws NyARException {
            assert (i_input.isEqualBufferType(65793));
            NyARIntSize size = i_input.getSize();
            byte[] in_buf = (byte[])i_input.getBuffer();
            int bp = (l + t * size.w) * 4;
            int b = t + h;
            int row_padding = (size.w - w) * 4;
            int y = t;
            while (y < b) {
                int x = 0;
                while (x < w) {
                    o_output[y * size.w + x + l] = (in_buf[bp] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF) >> 2;
                    bp += 4;
                    ++x;
                }
                bp += row_padding;
                ++y;
            }
        }
    }

    private class doThFilterImpl_BYTE1D_B8G8R8_24
    implements IdoThFilterImpl {
        private doThFilterImpl_BYTE1D_B8G8R8_24() {
        }

        @Override
        public void doCutFilter(INyARRaster i_input, int l, int t, int i_st, NyARGrayscaleRaster o_output) throws NyARException {
            assert (i_input.isEqualBufferType(65538) || i_input.isEqualBufferType(65537));
            assert (i_input.getSize().isInnerSize(l + o_output.getWidth() * i_st, t + o_output.getHeight() * i_st));
            byte[] input = (byte[])i_input.getBuffer();
            int[] output = (int[])o_output.getBuffer();
            NyARIntSize dest_size = o_output.getSize();
            NyARIntSize src_size = i_input.getSize();
            int skip_src_y = (src_size.w - dest_size.w * i_st) * 3 + src_size.w * (i_st - 1) * 3;
            int skip_src_x = 3 * i_st;
            int pix_count = dest_size.w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt_dst = 0;
            int pt_src = (t * src_size.w + l) * 3;
            int y = dest_size.h - 1;
            while (y >= 0) {
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    output[pt_dst++] = (input[pt_src + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) >> 2;
                    pt_src += skip_src_x;
                    --x;
                }
                while (x >= 0) {
                    output[pt_dst++] = (input[pt_src + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) >> 2;
                    output[pt_dst++] = (input[(pt_src += skip_src_x) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) >> 2;
                    output[pt_dst++] = (input[(pt_src += skip_src_x) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) >> 2;
                    output[pt_dst++] = (input[(pt_src += skip_src_x) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) >> 2;
                    output[pt_dst++] = (input[(pt_src += skip_src_x) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) >> 2;
                    output[pt_dst++] = (input[(pt_src += skip_src_x) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) >> 2;
                    output[pt_dst++] = (input[(pt_src += skip_src_x) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) >> 2;
                    output[pt_dst++] = (input[(pt_src += skip_src_x) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) >> 2;
                    pt_src += skip_src_x;
                    x -= 8;
                }
                pt_src += skip_src_y;
                --y;
            }
        }

        @Override
        public void doFilter(INyARRaster i_input, int[] o_output, int l, int t, int w, int h) {
            assert (i_input.isEqualBufferType(65538) || i_input.isEqualBufferType(65537));
            NyARIntSize size = i_input.getSize();
            byte[] in_buf = (byte[])i_input.getBuffer();
            int bp = (l + t * size.w) * 3;
            int b = t + h;
            int row_padding_dst = size.w - w;
            int row_padding_src = row_padding_dst * 3;
            int pix_count = w;
            int pix_mod_part = pix_count - pix_count % 8;
            int src_ptr = t * size.w + l;
            int y = t;
            while (y < b) {
                int x = 0;
                x = pix_count - 1;
                while (x >= pix_mod_part) {
                    o_output[src_ptr++] = (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) >> 2;
                    --x;
                }
                while (x >= 0) {
                    o_output[src_ptr++] = (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) >> 2;
                    o_output[src_ptr++] = (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) >> 2;
                    o_output[src_ptr++] = (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) >> 2;
                    o_output[src_ptr++] = (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) >> 2;
                    o_output[src_ptr++] = (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) >> 2;
                    o_output[src_ptr++] = (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) >> 2;
                    o_output[src_ptr++] = (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) >> 2;
                    o_output[src_ptr++] = (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) + (in_buf[bp++] & 0xFF) >> 2;
                    x -= 8;
                }
                bp += row_padding_dst;
                src_ptr += row_padding_src;
                ++y;
            }
        }
    }
}

