/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.core.NyARException;

public class NyARMat {
    protected double[][] _m;
    private int[] __matrixSelfInv_nos;
    protected int clm;
    protected int row;

    protected NyARMat() throws NyARException {
        throw new NyARException();
    }

    public NyARMat(int i_row, int i_clm, double[][] i_m, boolean i_is_attached_buffer) {
        this.clm = i_clm;
        this.row = i_row;
        this._m = i_m;
    }

    public NyARMat(int i_row, int i_clm) {
        this._m = new double[i_row][i_clm];
        this.clm = i_clm;
        this.row = i_row;
        this.__matrixSelfInv_nos = new int[i_row];
    }

    public int getClm() {
        return this.clm;
    }

    public int getRow() {
        return this.row;
    }

    public void realloc(int i_row, int i_clm) {
        if (i_row > this._m.length || i_clm > this._m[0].length) {
            this._m = new double[i_row][i_clm];
            this.__matrixSelfInv_nos = new int[i_row];
        }
        this.clm = i_clm;
        this.row = i_row;
    }

    public void mul(NyARMat i_mat_a, NyARMat i_mat_b) throws NyARException {
        assert (i_mat_a.clm == i_mat_b.row && this.row == i_mat_a.row && this.clm == i_mat_b.clm);
        double[][] am = i_mat_a._m;
        double[][] bm = i_mat_b._m;
        double[][] dm = this._m;
        int r = 0;
        while (r < this.row) {
            int c = 0;
            while (c < this.clm) {
                double w = 0.0;
                int i = 0;
                while (i < i_mat_a.clm) {
                    w += am[r][i] * bm[i][c];
                    ++i;
                }
                dm[r][c] = w;
                ++c;
            }
            ++r;
        }
    }

    public boolean inverse() throws NyARException {
        double[] ap_i;
        double work;
        int j;
        int i;
        double[][] ap = this._m;
        int dimen = this.row;
        int dimen_1 = dimen - 1;
        int[] nos = this.__matrixSelfInv_nos;
        switch (dimen) {
            case 0: {
                throw new NyARException();
            }
            case 1: {
                ap[0][0] = 1.0 / ap[0][0];
                return true;
            }
        }
        int n = 0;
        while (n < dimen) {
            nos[n] = n;
            ++n;
        }
        int ip = 0;
        n = 0;
        while (n < dimen) {
            double[] ap_n = ap[n];
            double p = 0.0;
            i = n;
            while (i < dimen) {
                double d;
                double pbuf = Math.abs(ap[i][0]);
                if (p < d) {
                    p = pbuf;
                    ip = i;
                }
                ++i;
            }
            if (p == 0.0) {
                return false;
            }
            int nwork = nos[ip];
            nos[ip] = nos[n];
            nos[n] = nwork;
            double[] ap_ip = ap[ip];
            j = 0;
            while (j < dimen) {
                work = ap_ip[j];
                ap_ip[j] = ap_n[j];
                ap_n[j] = work;
                ++j;
            }
            work = ap_n[0];
            j = 0;
            while (j < dimen_1) {
                ap_n[j] = ap_n[j + 1] / work;
                ++j;
            }
            ap_n[j] = 1.0 / work;
            i = 0;
            while (i < dimen) {
                if (i != n) {
                    ap_i = ap[i];
                    work = ap_i[0];
                    j = 0;
                    while (j < dimen_1) {
                        ap_i[j] = ap_i[j + 1] - work * ap_n[j];
                        ++j;
                    }
                    ap_i[j] = -work * ap_n[j];
                }
                ++i;
            }
            ++n;
        }
        n = 0;
        while (n < dimen) {
            j = n;
            while (j < dimen) {
                if (nos[j] == n) break;
                ++j;
            }
            nos[j] = nos[n];
            i = 0;
            while (i < dimen) {
                ap_i = ap[i];
                work = ap_i[j];
                ap_i[j] = ap_i[n];
                ap_i[n] = work;
                ++i;
            }
            ++n;
        }
        return true;
    }

    public void setValue(NyARMat i_copy_from) throws NyARException {
        if (this.row != i_copy_from.row || this.clm != i_copy_from.clm) {
            throw new NyARException();
        }
        int r = this.row - 1;
        while (r >= 0) {
            int c = this.clm - 1;
            while (c >= 0) {
                this._m[r][c] = i_copy_from._m[r][c];
                --c;
            }
            --r;
        }
    }

    public double[][] getArray() {
        return this._m;
    }

    public void loadZero() {
        int i = this.row - 1;
        while (i >= 0) {
            int i2 = this.clm - 1;
            while (i2 >= 0) {
                this._m[i][i2] = 0.0;
                --i2;
            }
            --i;
        }
    }

    public void transpose(NyARMat i_src) throws NyARException {
        if (this.row != i_src.clm || this.clm != i_src.row) {
            throw new NyARException();
        }
        int r = 0;
        while (r < this.row) {
            int c = 0;
            while (c < this.clm) {
                this._m[r][c] = i_src._m[c][r];
                ++c;
            }
            ++r;
        }
    }

    public static void matrixUnit(NyARMat unit) throws NyARException {
        if (unit.row != unit.clm) {
            throw new NyARException();
        }
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        int r = 0;
        while (r < unit.getRow()) {
            int c = 0;
            while (c < unit.getClm()) {
                unit._m[r][c] = r == c ? 1.0 : 0.0;
                ++c;
            }
            ++r;
        }
    }

    public void zeroCrear() {
        this.loadZero();
    }

    public void copyFrom(NyARMat i_copy_from) throws NyARException {
        this.setValue(i_copy_from);
    }

    public boolean matrixSelfInv() throws NyARException {
        return this.inverse();
    }

    public void matrixMul(NyARMat i_mat_a, NyARMat i_mat_b) throws NyARException {
        this.mul(i_mat_a, i_mat_b);
    }
}

