/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat.optimize.artoolkit;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.transmat.optimize.artoolkit.INyARRotMatrixOptimize;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotMatrix_ARToolKit;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;

public class NyARRotMatrixOptimize
implements INyARRotMatrixOptimize {
    private final NyARPerspectiveProjectionMatrix _projection_mat_ref;
    private final double[][] __modifyMatrix_double1D = new double[8][3];

    public NyARRotMatrixOptimize(NyARPerspectiveProjectionMatrix i_projection_mat_ref) {
        this._projection_mat_ref = i_projection_mat_ref;
    }

    @Override
    public double modifyMatrix(NyARRotMatrix_ARToolKit io_rot, NyARDoublePoint3d trans, NyARDoublePoint3d[] i_vertex3d, NyARDoublePoint2d[] i_vertex2d) throws NyARException {
        double ma = 0.0;
        double mb = 0.0;
        double mc = 0.0;
        double minerr = 0.0;
        int s1 = 0;
        int s2 = 0;
        int s3 = 0;
        double factor = 0.17453292519943295;
        NyARDoublePoint3d d_pt = i_vertex3d[0];
        double VX00 = d_pt.x;
        double VX01 = d_pt.y;
        double VX02 = d_pt.z;
        d_pt = i_vertex3d[1];
        double VX10 = d_pt.x;
        double VX11 = d_pt.y;
        double VX12 = d_pt.z;
        d_pt = i_vertex3d[2];
        double VX20 = d_pt.x;
        double VX21 = d_pt.y;
        double VX22 = d_pt.z;
        d_pt = i_vertex3d[3];
        double VX30 = d_pt.x;
        double VX31 = d_pt.y;
        double VX32 = d_pt.z;
        NyARDoublePoint2d d_pt2 = i_vertex2d[0];
        double P2D00 = d_pt2.x;
        double P2D01 = d_pt2.y;
        d_pt2 = i_vertex2d[1];
        double P2D10 = d_pt2.x;
        double P2D11 = d_pt2.y;
        d_pt2 = i_vertex2d[2];
        double P2D20 = d_pt2.x;
        double P2D21 = d_pt2.y;
        d_pt2 = i_vertex2d[3];
        double P2D30 = d_pt2.x;
        double P2D31 = d_pt2.y;
        NyARPerspectiveProjectionMatrix prjmat = this._projection_mat_ref;
        double CP0 = prjmat.m00;
        double CP1 = prjmat.m01;
        double CP2 = prjmat.m02;
        double CP4 = prjmat.m10;
        double CP5 = prjmat.m11;
        double CP6 = prjmat.m12;
        double CP8 = prjmat.m20;
        double CP9 = prjmat.m21;
        double CP10 = prjmat.m22;
        double combo03 = CP0 * trans.x + CP1 * trans.y + CP2 * trans.z + prjmat.m03;
        double combo13 = CP4 * trans.x + CP5 * trans.y + CP6 * trans.z + prjmat.m13;
        double combo23 = CP8 * trans.x + CP9 * trans.y + CP10 * trans.z + prjmat.m23;
        double[][] double1D = this.__modifyMatrix_double1D;
        double[] a_factor = double1D[1];
        double[] sinb = double1D[2];
        double[] cosb = double1D[3];
        double[] b_factor = double1D[4];
        double[] sinc = double1D[5];
        double[] cosc = double1D[6];
        double[] c_factor = double1D[7];
        NyARDoublePoint3d angle = io_rot.getAngle();
        double a2 = angle.x;
        double b2 = angle.y;
        double c2 = angle.z;
        int i = 0;
        while (i < 10) {
            minerr = 1.0E9;
            int j = 0;
            while (j < 3) {
                double w;
                double w2 = factor * (double)(j - 1);
                a_factor[j] = w = a2 + w2;
                b_factor[j] = w = b2 + w2;
                sinb[j] = Math.sin(w);
                cosb[j] = Math.cos(w);
                c_factor[j] = w = c2 + w2;
                sinc[j] = Math.sin(w);
                cosc[j] = Math.cos(w);
                ++j;
            }
            int t1 = 0;
            while (t1 < 3) {
                double SA = Math.sin(a_factor[t1]);
                double CA = Math.cos(a_factor[t1]);
                double CACA = CA * CA;
                double SASA = SA * SA;
                double SACA = SA * CA;
                int t2 = 0;
                while (t2 < 3) {
                    double wsin = sinb[t2];
                    double wcos = cosb[t2];
                    double CACACB = CACA * wcos;
                    double SACACB = SACA * wcos;
                    double SASACB = SASA * wcos;
                    double CASB = CA * wsin;
                    double SASB = SA * wsin;
                    double combo02 = CP0 * CASB + CP1 * SASB + CP2 * wcos;
                    double combo12 = CP4 * CASB + CP5 * SASB + CP6 * wcos;
                    double combo22 = CP8 * CASB + CP9 * SASB + CP10 * wcos;
                    double combo02_2 = combo02 * VX02 + combo03;
                    double combo02_5 = combo02 * VX12 + combo03;
                    double combo02_8 = combo02 * VX22 + combo03;
                    double combo02_11 = combo02 * VX32 + combo03;
                    double combo12_2 = combo12 * VX02 + combo13;
                    double combo12_5 = combo12 * VX12 + combo13;
                    double combo12_8 = combo12 * VX22 + combo13;
                    double combo12_11 = combo12 * VX32 + combo13;
                    double combo22_2 = combo22 * VX02 + combo23;
                    double combo22_5 = combo22 * VX12 + combo23;
                    double combo22_8 = combo22 * VX22 + combo23;
                    double combo22_11 = combo22 * VX32 + combo23;
                    int t3 = 0;
                    while (t3 < 3) {
                        wsin = sinc[t3];
                        wcos = cosc[t3];
                        double SACASC = SACA * wsin;
                        double SACACC = SACA * wcos;
                        double SACACBSC = SACACB * wsin;
                        double SACACBCC = SACACB * wcos;
                        double rot0 = CACACB * wcos + SASA * wcos + SACACBSC - SACASC;
                        double rot3 = SACACBCC - SACACC + SASACB * wsin + CACA * wsin;
                        double rot6 = -CASB * wcos - SASB * wsin;
                        double combo00 = CP0 * rot0 + CP1 * rot3 + CP2 * rot6;
                        double combo10 = CP4 * rot0 + CP5 * rot3 + CP6 * rot6;
                        double combo20 = CP8 * rot0 + CP9 * rot3 + CP10 * rot6;
                        double rot1 = -CACACB * wsin - SASA * wsin + SACACBCC - SACACC;
                        double rot4 = -SACACBSC + SACASC + SASACB * wcos + CACA * wcos;
                        double rot7 = CASB * wsin - SASB * wcos;
                        double combo01 = CP0 * rot1 + CP1 * rot4 + CP2 * rot7;
                        double combo11 = CP4 * rot1 + CP5 * rot4 + CP6 * rot7;
                        double combo21 = CP8 * rot1 + CP9 * rot4 + CP10 * rot7;
                        double err = 0.0;
                        double h = combo20 * VX00 + combo21 * VX01 + combo22_2;
                        double x = P2D00 - (combo00 * VX00 + combo01 * VX01 + combo02_2) / h;
                        double y = P2D01 - (combo10 * VX00 + combo11 * VX01 + combo12_2) / h;
                        err += x * x + y * y;
                        h = combo20 * VX10 + combo21 * VX11 + combo22_5;
                        x = P2D10 - (combo00 * VX10 + combo01 * VX11 + combo02_5) / h;
                        y = P2D11 - (combo10 * VX10 + combo11 * VX11 + combo12_5) / h;
                        err += x * x + y * y;
                        h = combo20 * VX20 + combo21 * VX21 + combo22_8;
                        x = P2D20 - (combo00 * VX20 + combo01 * VX21 + combo02_8) / h;
                        y = P2D21 - (combo10 * VX20 + combo11 * VX21 + combo12_8) / h;
                        err += x * x + y * y;
                        h = combo20 * VX30 + combo21 * VX31 + combo22_11;
                        x = P2D30 - (combo00 * VX30 + combo01 * VX31 + combo02_11) / h;
                        y = P2D31 - (combo10 * VX30 + combo11 * VX31 + combo12_11) / h;
                        if ((err += x * x + y * y) < minerr) {
                            minerr = err;
                            ma = a_factor[t1];
                            mb = b_factor[t2];
                            mc = c_factor[t3];
                            s1 = t1 - 1;
                            s2 = t2 - 1;
                            s3 = t3 - 1;
                        }
                        ++t3;
                    }
                    ++t2;
                }
                ++t1;
            }
            if (s1 == 0 && s2 == 0 && s3 == 0) {
                factor *= 0.5;
            }
            a2 = ma;
            b2 = mb;
            c2 = mc;
            ++i;
        }
        io_rot.setAngle(ma, mb, mc);
        return minerr / 4.0;
    }
}

