/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.markersystem.utils;

import java.util.ArrayList;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.markersystem.utils.SquareStack;
import jp.nyatla.nyartoolkit.markersystem.utils.TMarkerData;
import jp.nyatla.nyartoolkit.markersystem.utils.VertexSortTable;

public class TrackingList
extends ArrayList<TMarkerData> {
    private static final long serialVersionUID = -6446466460932931830L;
    private VertexSortTable _tracking_list;
    private int[] __ret = new int[2];

    public TrackingList() throws NyARException {
        this._tracking_list = new VertexSortTable(1);
    }

    public void prepare() {
        this._tracking_list.reset();
        int i = this.size() - 1;
        while (i >= 0) {
            TMarkerData target = (TMarkerData)this.get(i);
            target.sq = null;
            if (target.life > 0L) {
                ++target.lost_count;
            }
            --i;
        }
    }

    public boolean update(SquareStack.Item i_new_sq) throws NyARException {
        int[] ret = this.__ret;
        int new_area = i_new_sq.rect_area;
        int new_sq_dist = i_new_sq.vertex_area.getDiagonalSqDist();
        boolean is_dispatched = false;
        int i = this.size() - 1;
        while (i >= 0) {
            long sq_move;
            int a_rate;
            TMarkerData target = (TMarkerData)this.get(i);
            if (target.lost_count <= 1 && (a_rate = new_area * 100 / target.tl_rect_area) >= 50 && 150 >= a_rate && (sq_move = (long)target.tl_center.sqDist(i_new_sq.center2d)) * 4L / (long)new_sq_dist <= 0L) {
                VertexSortTable.Item item;
                TrackingList.compareVertexSet(i_new_sq.ob_vertex, target.tl_vertex, ret);
                int sqdist = ret[1];
                int shift = ret[0];
                if ((long)sqdist <= (sq_move + 8L) * 10L && (item = this._tracking_list.getInsertPoint(sqdist)) != null) {
                    item = this._tracking_list.insertFromTailBefore(item);
                    item.marker = target;
                    item.shift = shift;
                    item.sq_dist = sqdist;
                    item.ref_sq = i_new_sq;
                    is_dispatched = true;
                }
            }
            --i;
        }
        return is_dispatched;
    }

    public static void compareVertexSet(NyARIntPoint2d[] i_v1, NyARIntPoint2d[] i_v2, int[] ret) {
        int min_dist = Integer.MAX_VALUE;
        int min_index = 0;
        int i = 3;
        while (i >= 0) {
            int d = 0;
            int i2 = 3;
            while (i2 >= 0) {
                int xd = i_v1[i2].x - i_v2[(i2 + i) % 4].x;
                int yd = i_v1[i2].y - i_v2[(i2 + i) % 4].y;
                d += xd * xd + yd * yd;
                --i2;
            }
            if (min_dist > d) {
                min_dist = d;
                min_index = i;
            }
            --i;
        }
        ret[0] = min_index;
        ret[1] = min_dist;
    }

    @Override
    public boolean add(TMarkerData e) {
        int i = 0;
        while (i < 2) {
            this._tracking_list.append();
            ++i;
        }
        return super.add(e);
    }

    public void finish() {
        VertexSortTable.Item top_item = this._tracking_list.getTopItem();
        while (top_item != null) {
            TMarkerData target = top_item.marker;
            if (target.lost_count > 0) {
                target.lost_count = 0;
                ++target.life;
                target.sq = top_item.ref_sq;
                target.sq.rotateVertexL(4 - top_item.shift);
                NyARIntPoint2d.shiftCopy(top_item.ref_sq.ob_vertex, target.tl_vertex, 4 - top_item.shift);
                target.tl_center.setValue(top_item.ref_sq.center2d);
                target.tl_rect_area = top_item.ref_sq.rect_area;
            }
            this._tracking_list.disableMatchItem(top_item);
            top_item = this._tracking_list.getTopItem();
        }
    }
}

