/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.bootstrap;

import com.funambol.framework.core.AbstractCommand;
import com.funambol.framework.core.Add;
import com.funambol.framework.core.CmdID;
import com.funambol.framework.core.Constants;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.RepresentationException;
import com.funambol.framework.core.SessionID;
import com.funambol.framework.core.Source;
import com.funambol.framework.core.SyncBody;
import com.funambol.framework.core.SyncHdr;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.core.Target;
import com.funambol.framework.core.dm.bootstrap.BasicAccountInfo;
import com.funambol.framework.engine.dm.TreeNode;
import com.funambol.framework.engine.dm.Util;
import com.funambol.framework.notification.NotificationException;
import com.funambol.framework.tools.Base64;
import com.funambol.framework.tools.WBXMLTools;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;

public class PlainBootstrapMessageBuilder {
    public static final String ACC_NAME = "/Name";
    public static final String ACC_AUTH_PREF = "/AuthPref";
    public static final String ACC_SERVER_ADDR = "/Addr";
    public static final String ACC_SERVER_PORT_NBR = "/PortNbr";
    public static final String ACC_SERVER_ADDR_TYPE = "/AddrType";
    public static final String ACC_SERVER_ID = "/ServerId";
    public static final String ACC_SERVER_PASSWORD = "/ServerPW";
    public static final String ACC_SERVER_NONCE = "/ServerNonce";
    public static final String ACC_CLIENT_USERNAME = "/UserName";
    public static final String ACC_CLIENT_PASSWORD = "/ClientPW";
    public static final String ACC_CLIENT_NONCE = "/ClientNonce";
    private static final Logger log = Logger.getLogger((String)PlainBootstrapMessageBuilder.class.getName());

    public byte[] buildMessage(BasicAccountInfo basicAccountInfo, TreeNode[] nodes) throws NotificationException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"Calling buildMessage in PlainBootstrapMessageBuilder");
        }
        Map<String, Object> bootstrapNodes = this.accountInfoNodes(basicAccountInfo);
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (bootstrapNodes.containsKey(nodes[i].getName())) continue;
                bootstrapNodes.put(nodes[i].getName(), nodes[i]);
            }
        }
        SyncML syncMLPlainBootstrapMessage = this.getSyncMLBootstrapMessage(bootstrapNodes, basicAccountInfo);
        byte[] message = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IBindingFactory f = BindingDirectory.getFactory(SyncML.class);
            IMarshallingContext c = f.createMarshallingContext();
            c.setIndent(0);
            c.marshalDocument((Object)syncMLPlainBootstrapMessage, "UTF-8", null, (OutputStream)bout);
            String inputXml = new String(bout.toByteArray());
            inputXml = this.metInfNamespaceHandler(inputXml);
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)("PlainBootstrapMessage - xml: " + inputXml));
            }
            message = WBXMLTools.toWBXML((String)inputXml, (String)Constants.DTD_1_1.getValue());
        }
        catch (Exception ex) {
            throw new NotificationException("Error during xml to wbxml transformation", (Throwable)ex);
        }
        return message;
    }

    private String metInfNamespaceHandler(String msg) {
        int s = 0;
        int e = 0;
        StringBuffer response = new StringBuffer();
        while ((e = msg.indexOf("<Meta", s)) >= 0) {
            response = response.append(msg.substring(s, e));
            int a = msg.indexOf("</Meta>", e);
            String meta = msg.substring(e, a);
            meta = meta.replaceAll("<Type>", "<Type xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Format>", "<Format xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Mark>", "<Mark xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Size>", "<Size xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Anchor>", "<Anchor xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Version>", "<Version xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<NextNonce>", "<NextNonce xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<MaxMsgSize>", "<MaxMsgSize xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<MaxObjSize>", "<MaxObjSize xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<EMI>", "<EMI xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Mem>", "<Mem xmlns='syncml:metinf'>");
            s = a + 7;
            response.append(meta).append("</Meta>");
        }
        return response.append(msg.substring(s, msg.length())).toString();
    }

    private Map<String, Object> accountInfoNodes(BasicAccountInfo basicAccountInfo) {
        LinkedHashMap<String, Object> accountNodes = new LinkedHashMap<String, Object>();
        String accountURI = "./SyncML/DMAcc/" + basicAccountInfo.getAccountName();
        accountNodes.put(accountURI, new TreeNode(accountURI, null, "node"));
        accountNodes.put(accountURI + ACC_AUTH_PREF, new TreeNode(accountURI + ACC_AUTH_PREF, (Object)basicAccountInfo.getAuthPref()));
        accountNodes.put(accountURI + ACC_SERVER_ADDR, new TreeNode(accountURI + ACC_SERVER_ADDR, (Object)basicAccountInfo.getServerAddress()));
        accountNodes.put(accountURI + ACC_SERVER_PORT_NBR, new TreeNode(accountURI + ACC_SERVER_PORT_NBR, (Object)Integer.toString(basicAccountInfo.getServerPort()), "int"));
        accountNodes.put(accountURI + ACC_SERVER_ADDR_TYPE, new TreeNode(accountURI + ACC_SERVER_ADDR_TYPE, (Object)Integer.toString(basicAccountInfo.getAddressType()), "int"));
        accountNodes.put(accountURI + ACC_SERVER_ID, new TreeNode(accountURI + ACC_SERVER_ID, (Object)basicAccountInfo.getServerId()));
        accountNodes.put(accountURI + ACC_SERVER_NONCE, new TreeNode(accountURI + ACC_SERVER_NONCE, (Object)Base64.encode((byte[])basicAccountInfo.getServerNonce()), "b64"));
        accountNodes.put(accountURI + ACC_SERVER_PASSWORD, new TreeNode(accountURI + ACC_SERVER_PASSWORD, (Object)basicAccountInfo.getServerPassword()));
        accountNodes.put(accountURI + ACC_CLIENT_NONCE, new TreeNode(accountURI + ACC_CLIENT_NONCE, (Object)Base64.encode((byte[])basicAccountInfo.getClientNonce())));
        accountNodes.put(accountURI + ACC_CLIENT_PASSWORD, new TreeNode(accountURI + ACC_CLIENT_PASSWORD, (Object)basicAccountInfo.getClientPassword()));
        accountNodes.put(accountURI + ACC_CLIENT_USERNAME, new TreeNode(accountURI + ACC_CLIENT_USERNAME, (Object)basicAccountInfo.getClientUsername()));
        return accountNodes;
    }

    private SyncML getSyncMLBootstrapMessage(Map<String, Object> bootstrapNodes, BasicAccountInfo basicAccountInfo) throws NotificationException {
        SyncML syncMLBootstrapMessage = null;
        SyncHdr syncHdrMessage = null;
        SyncBody syncBodyMessage = null;
        try {
            URL url = null;
            URL newUrlWithPort = null;
            try {
                url = new URL(basicAccountInfo.getServerAddress());
                String hostName = url.getHost();
                String protocol = url.getProtocol();
                String file = url.getFile();
                newUrlWithPort = new URL(protocol, hostName, basicAccountInfo.getServerPort(), file);
            }
            catch (MalformedURLException e) {
                throw new NotificationException("Error creating the serverURI", (Throwable)e);
            }
            syncHdrMessage = new SyncHdr(Constants.DTD_1_1, Constants.SYNCML_DM_1_1, new SessionID("0"), "0", new Target(basicAccountInfo.getDeviceId()), new Source(newUrlWithPort.toExternalForm()), null, false, null, null);
            Item[] items = Util.nodes2Items(bootstrapNodes, (boolean)true, (boolean)false, null);
            Add addCommand = new Add(new CmdID(1L), false, null, null, items);
            syncBodyMessage = new SyncBody(new AbstractCommand[]{addCommand}, true);
            syncMLBootstrapMessage = new SyncML(syncHdrMessage, syncBodyMessage);
        }
        catch (RepresentationException ex) {
            throw new NotificationException("Error during creation of the SyncML message", (Throwable)ex);
        }
        return syncMLBootstrapMessage;
    }
}

