/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.notification;

import com.funambol.framework.config.Configuration;
import com.funambol.framework.notification.NotificationException;
import com.funambol.framework.notification.NotificationSender;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Properties;
import org.jboss.logging.Logger;

public class HttpSender2
implements NotificationSender {
    private String deviceFile = null;
    private String deviceAddress = null;
    private static final transient Logger log = Logger.getLogger((String)HttpSender2.class.getName());

    public String getDeviceFile() {
        return this.deviceFile;
    }

    public void setDeviceFile(String deviceFile) {
        this.deviceFile = deviceFile;
    }

    private String getDeviceAddress(String phoneNumber) throws NotificationException {
        Properties deviceProperties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(this.deviceFile);
            deviceProperties.load(fis);
            fis.close();
        }
        catch (Exception e) {
            throw new NotificationException("Error initilizing http sender", (Throwable)e);
        }
        return deviceProperties.getProperty(phoneNumber);
    }

    public void sendMessages(int messageType, String[] phoneNumbers, byte[][] messages, String info) throws NotificationException {
        for (int i = 0; i < phoneNumbers.length; ++i) {
            if (i != 0) {
                System.out.println("Wait 20 s for test with SCTS");
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            this.sendMessage(messageType, phoneNumbers[i], messages[i], info);
        }
    }

    private void sendMessage(int messageType, String phoneNumber, byte[] message, String info) throws NotificationException {
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("sendMessage: " + message + " (length: " + message.length + ")"));
        }
        if (messageType != 0) {
            throw new NotificationException("This sender is usable only for notification message");
        }
        byte[] nestedRequest = this.buildNestedRequest(message);
        byte[] request = this.buildRequest(nestedRequest);
        this.deviceAddress = this.getDeviceAddress(phoneNumber);
        try {
            this.sendHttpRequest(request);
        }
        catch (Exception e) {
            throw new NotificationException("Error sending the message via http", (Throwable)e);
        }
    }

    private void sendHttpRequest(byte[] message) throws Exception {
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("Send message to: " + this.deviceAddress));
        }
        URL url = new URL(this.deviceAddress);
        String host = url.getHost();
        int port = url.getPort();
        Socket conn = new Socket(host, port);
        BufferedOutputStream wr = new BufferedOutputStream(conn.getOutputStream());
        wr.write(message);
        wr.flush();
        wr.close();
    }

    private byte[] buildRequest(byte[] message) {
        StringBuffer sb = new StringBuffer("POST /wappush HTTP/1.1\r\n");
        String serverURI = Configuration.getConfiguration().getStringValue("server.uri");
        URL url = null;
        try {
            url = new URL(serverURI);
        }
        catch (MalformedURLException ex) {
            log.error((Object)"invalid serverURI", (Throwable)ex);
        }
        String hostName = url.getHost();
        sb.append("Host: ").append(hostName).append("\r\n");
        sb.append("Content-Type: application/http\r\n");
        sb.append("Content-Length: ").append(message.length).append("\r\n");
        sb.append("X-Wap-Push-OTA-Version: 1.0\r\n\r\n");
        byte[] header = sb.toString().getBytes();
        byte[] request = new byte[header.length + message.length];
        System.arraycopy(header, 0, request, 0, header.length);
        System.arraycopy(message, 0, request, header.length, message.length);
        return request;
    }

    private byte[] buildNestedRequest(byte[] message) {
        StringBuffer sb = new StringBuffer("HTTP/1.1 200 OK\r\n");
        sb.append("Content-Language: en\r\n");
        sb.append("Content-Length: ").append(message.length).append("\r\n");
        sb.append("Content-Type: application/vnd.syncml.notification\r\n\r\n");
        byte[] header = sb.toString().getBytes();
        byte[] nestedRequest = new byte[header.length + message.length];
        System.arraycopy(header, 0, nestedRequest, 0, header.length);
        System.arraycopy(message, 0, nestedRequest, header.length, message.length);
        return nestedRequest;
    }
}

