/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.notification;

import com.funambol.framework.notification.BootStrapSender;
import com.funambol.framework.notification.NotificationException;
import com.funambol.framework.notification.NotificationSender;
import com.funambol.framework.tools.DbgTools;
import org.jboss.logging.Logger;

public class SimpleSender
implements NotificationSender,
BootStrapSender {
    private static final transient Logger log = Logger.getLogger((String)SimpleSender.class.getName());

    public void sendMessage(int messageType, String phoneNumber, byte[] message, String info) throws NotificationException {
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("Send message \n\tmessageType: " + messageType + "\n\tphoneNumber: " + phoneNumber + "\n\tmessage length: " + (message != null ? String.valueOf(message.length) : "unknown") + "\n\tinfo: " + info));
            log.info((Object)("Message: " + DbgTools.bytesToHex((byte[])message)));
        }
    }

    public void sendMessages(int messageType, String[] phoneNumbers, byte[][] message, String info) throws NotificationException {
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("Send messages \n\tmessageType: " + messageType + "\n\tnum. devices: " + phoneNumbers.length + "\n\tinfo: " + info));
            for (int i = 0; i < message.length; ++i) {
                log.info((Object)("Message " + i + ": " + DbgTools.bytesToHex((byte[])message[i])));
            }
        }
    }

    public void sendMessages(int[] messageType, String[] digest, int[] authMethods, String[] phoneNumbers, byte[][] messages, String[] info) throws NotificationException {
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("Send messages: \n\tnum. devices: " + phoneNumbers.length));
            for (int i = 0; i < messages.length; ++i) {
                log.info((Object)("Phone number " + i + ": " + phoneNumbers[i]));
                log.info((Object)("Message " + i + ": " + DbgTools.bytesToHex((byte[])messages[i])));
                log.info((Object)("Digest " + i + ": " + digest[i]));
                log.info((Object)("AuthMethod " + i + ": " + authMethods[i]));
                log.info((Object)("Info " + i + ": " + digest[i]));
            }
        }
    }
}

