/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.session;

import com.funambol.framework.config.Configuration;
import com.funambol.framework.config.ConfigurationConstants;
import com.funambol.framework.core.AbstractCommand;
import com.funambol.framework.core.Add;
import com.funambol.framework.core.Alert;
import com.funambol.framework.core.Atomic;
import com.funambol.framework.core.Authentication;
import com.funambol.framework.core.Chal;
import com.funambol.framework.core.ComplexData;
import com.funambol.framework.core.Copy;
import com.funambol.framework.core.Cred;
import com.funambol.framework.core.Data;
import com.funambol.framework.core.Delete;
import com.funambol.framework.core.Exec;
import com.funambol.framework.core.Get;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.ItemizedCommand;
import com.funambol.framework.core.Meta;
import com.funambol.framework.core.NextNonce;
import com.funambol.framework.core.Replace;
import com.funambol.framework.core.Results;
import com.funambol.framework.core.Sequence;
import com.funambol.framework.core.Source;
import com.funambol.framework.core.SourceRef;
import com.funambol.framework.core.Status;
import com.funambol.framework.core.Sync4jException;
import com.funambol.framework.core.SyncBody;
import com.funambol.framework.core.SyncHdr;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.core.Target;
import com.funambol.framework.core.TargetRef;
import com.funambol.framework.core.Util;
import com.funambol.framework.engine.dm.DeviceDMState;
import com.funambol.framework.engine.dm.ManagementCommandDescriptor;
import com.funambol.framework.engine.dm.ManagementException;
import com.funambol.framework.engine.dm.ManagementOperation;
import com.funambol.framework.engine.dm.ManagementProcessor;
import com.funambol.framework.engine.dm.SessionContext;
import com.funambol.framework.protocol.ManagementActions;
import com.funambol.framework.protocol.ManagementInitialization;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.protocol.ProtocolUtil;
import com.funambol.framework.security.Officer;
import com.funambol.framework.security.SecurityConstants;
import com.funambol.framework.security.Sync4jPrincipal;
import com.funambol.framework.server.Sync4jDevice;
import com.funambol.framework.server.SyncTimestamp;
import com.funambol.framework.server.dm.ProcessorSelector;
import com.funambol.framework.server.error.InvalidCredentialsException;
import com.funambol.framework.server.error.ServerException;
import com.funambol.framework.server.error.ServerFailureException;
import com.funambol.framework.server.session.ManagementState;
import com.funambol.framework.server.session.SessionHandler;
import com.funambol.framework.server.store.NotFoundException;
import com.funambol.framework.server.store.PersistentStoreException;
import com.funambol.framework.tools.Base64;
import com.funambol.framework.tools.CommandIdGenerator;
import com.funambol.framework.tools.SimpleIdGenerator;
import com.funambol.framework.tools.SizeCalculator;
import com.funambol.server.engine.dm.ManagementEngine;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

public class ManagementSessionHandler
implements SessionHandler,
Serializable,
SecurityConstants,
ConfigurationConstants {
    public static final int STATE_INITIALIZATION_PROCESSING = 16;
    public static final int STATE_INITIALIZATION_PROCESSED = 17;
    public static final int STATE_MANAGEMENT_PROCESSING = 18;
    public static final int STATE_MANAGEMENT_PROCESSED = 19;
    public static final int STATE_MANAGEMENT_COMPLETION = 20;
    public static final int STATE_CLIENT_UNAUTHORIZED = 22;
    public static final int STATE_WAITING_MORE_MSG = 21;
    private static final String[] MANAGEMENT_COMMANDS = new String[]{"Add", "Alert", "Copy", "Delete", "Exec", "Get", "Replace", "Atomic", "Sequence"};
    private static final double TOLLERANCE_MAX_MSG_SIZE = 0.85;
    private int currentState = 0;
    private long creationTimestamp = -1L;
    private static final transient Logger log = Logger.getLogger((String)ManagementSessionHandler.class.getName());
    private transient ManagementInitialization init = null;
    private transient ManagementActions actions = null;
    private ManagementState sessionState = null;
    private ManagementProcessor processor = null;
    private String serverAuthType = null;
    private String supportedAuthType = null;
    private String clientAuthType = null;
    private ManagementEngine engine = null;
    private String mimeType = null;
    private boolean newSession = true;
    private ArrayList<Status> addStatus = null;
    private ArrayList<Object> addAbsCmd = null;
    private long maxSizeAvailable = 0L;
    private SimpleIdGenerator msgIdGenerator = new SimpleIdGenerator();

    public int getCurrentState() {
        return this.currentState;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getSessionId() {
        return this.sessionState.getSessionId();
    }

    public Sync4jDevice getDevice() {
        return this.sessionState.device;
    }

    private void resetIdGenerator() {
        this.engine.getCommandIdGenerator().reset();
    }

    public ManagementSessionHandler() {
        this.creationTimestamp = System.currentTimeMillis();
        this.init();
    }

    public ManagementSessionHandler(String sessionId) {
        this();
        this.sessionState.sessionId = sessionId;
    }

    public void setNew(boolean newSession) {
        this.newSession = newSession;
    }

    public boolean isNew() {
        return this.newSession;
    }

    public boolean isAuthenticated() {
        return this.sessionState.authenticationState == 4;
    }

    public SyncML processMessage(SyncML message) throws ProtocolException, InvalidCredentialsException, ServerFailureException {
        Meta meta;
        String deviceId = null;
        SyncML response = null;
        this.resetIdGenerator();
        this.msgIdGenerator.next();
        this.sessionState.lastMsgIdFromClient = message.getSyncHdr().getMsgID();
        deviceId = message.getSyncHdr().getSource().getLocURI();
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("device id: " + deviceId));
            log.trace((Object)("current state: " + this.getStateName(this.currentState)));
        }
        if ((meta = message.getSyncHdr().getMeta()) != null) {
            Long maxObjSize;
            Long maxMsgSize = meta.getMaxMsgSize();
            if (maxMsgSize != null) {
                this.sessionState.setMaxMsgSize(maxMsgSize.longValue());
            }
            if ((maxObjSize = meta.getMaxObjSize()) != null) {
                this.sessionState.setMaxObjSize(maxObjSize.longValue());
            }
        }
        try {
            switch (this.currentState) {
                case 0: 
                case 1: 
                case 22: 
                case 65535: {
                    this.sessionState.reset();
                    this.sessionState.nextTimestamp = new SyncTimestamp(System.currentTimeMillis());
                    this.sessionState.device = new Sync4jDevice(deviceId);
                    this.engine.readDevice(this.sessionState.device);
                    this.sessionState.syncMLVerProto = message.getSyncHdr().getVerProto();
                    this.engine.setSyncMLVerProto(this.sessionState.syncMLVerProto.getVersion());
                    if (this.currentState != 22) {
                        this.moveTo(16);
                    }
                }
                case 16: {
                    if (!this.isAuthenticated()) {
                        Cred cred = message.getSyncHdr().getCred();
                        if (!this.checkAuthType(cred)) {
                            this.sessionState.loggedCredential = null;
                        } else {
                            this.login(cred, deviceId);
                            if (this.isAuthenticated()) {
                                try {
                                    this.engine.readPrincipal(this.sessionState.loggedPrincipal);
                                }
                                catch (NotFoundException e) {
                                    if (log.isEnabled(Logger.Level.INFO)) {
                                        log.info((Object)("Authenticated principal not found: " + this.sessionState.loggedPrincipal));
                                    }
                                    this.sessionState.authenticationState = 3;
                                    this.sessionState.loggedCredential = null;
                                }
                            }
                        }
                    }
                    boolean clientAuthenticated = this.isAuthenticated();
                    boolean chalNotRequired = false;
                    if (!clientAuthenticated && this.currentState == 22) {
                        chalNotRequired = true;
                    }
                    response = this.processInitMessage(message, chalNotRequired);
                    if (!clientAuthenticated) {
                        if (this.currentState == 22) {
                            response.setLastMessage(true);
                            this.moveTo(65535);
                            break;
                        }
                        this.moveTo(22);
                        break;
                    }
                    if (!message.getSyncBody().isFinalMsg()) break;
                    this.moveTo(17);
                }
                case 17: {
                    this.checkServerAuthentication(message);
                    if (!this.sessionState.started || this.sessionState.serverAuthenticationState != 4 && this.sessionState.serverAuthenticationState != 5) {
                        this.init.setFlag(3);
                        if (this.addAbsCmd != null) {
                            if (this.sessionState.getSplittedCommand() != null && this.addAbsCmd.contains(this.sessionState.getSplittedCommand())) {
                                this.mergeData();
                                this.sessionState.setSplittedCommand(null);
                                this.sessionState.setNextDataToSend(null);
                            }
                            this.sessionState.addCmdOut(0, this.addAbsCmd);
                        }
                        AbstractCommand[] allClientCommands = message.getSyncBody().getCommands().toArray(new AbstractCommand[0]);
                        this.init.addClientCommand(allClientCommands);
                        response = this.startManagementSession(message);
                        if (this.init.isSessionAbortRequired()) {
                            if (log.isEnabled(Logger.Level.INFO)) {
                                log.info((Object)"Session aborted by client");
                            }
                            response.setLastMessage(true);
                            this.sessionState.nextTimestamp.end = System.currentTimeMillis();
                            this.sessionState.dmstate.state = (byte)65;
                            this.endSession();
                            this.moveTo(2);
                            break;
                        }
                        this.sessionState.started = true;
                        if (ProtocolUtil.noMoreResponse((SyncML)response)) {
                            this.moveTo(20);
                            this.sessionState.nextTimestamp.end = System.currentTimeMillis();
                            this.endSession();
                            this.moveTo(1);
                        }
                        break;
                    }
                    this.moveTo(18);
                }
                case 18: {
                    response = this.processManagementMessage(message);
                    if (this.actions.isSessionAbortRequired()) {
                        if (log.isEnabled(Logger.Level.INFO)) {
                            log.info((Object)"Session aborted by client");
                        }
                        response.setLastMessage(true);
                        this.sessionState.nextTimestamp.end = System.currentTimeMillis();
                        this.sessionState.dmstate.state = (byte)65;
                        this.endSession();
                        this.moveTo(2);
                        break;
                    }
                    if (!ProtocolUtil.noMoreResponse((SyncML)response)) break;
                    this.moveTo(19);
                    this.moveTo(20);
                }
                case 20: {
                    this.sessionState.nextTimestamp.end = System.currentTimeMillis();
                    response.setLastMessage(true);
                    this.endSession();
                    this.moveTo(1);
                    break;
                }
                default: {
                    this.endSession();
                    throw new ProtocolException("Illegal state: " + this.getStateName(this.currentState) + '(' + this.currentState + ')');
                }
            }
        }
        catch (ProtocolException e) {
            if (this.sessionState.dmstate != null) {
                this.sessionState.dmstate.state = (byte)69;
            }
            this.endSession();
            log.debug((Object)"processMessage", (Throwable)e);
            this.moveTo(65535);
            throw e;
        }
        catch (NotFoundException e) {
            if (this.sessionState.dmstate != null) {
                this.sessionState.dmstate.state = (byte)69;
            }
            this.endSession();
            log.debug((Object)"processMessage", (Throwable)e);
            this.moveTo(65535);
            throw new InvalidCredentialsException("Invalid credential error", (Throwable)e);
        }
        catch (PersistentStoreException e) {
            if (this.sessionState.dmstate != null) {
                this.sessionState.dmstate.state = (byte)69;
            }
            this.endSession();
            log.debug((Object)"processMessage", (Throwable)e);
            this.moveTo(65535);
            throw new ServerFailureException("Persistent store error", (Throwable)e);
        }
        catch (ManagementException e) {
            if (this.sessionState.dmstate != null) {
                this.sessionState.dmstate.state = (byte)69;
            }
            this.endSession();
            log.debug((Object)"processMessage", (Throwable)e);
            this.moveTo(65535);
            throw new ServerFailureException("Management error", (Throwable)e);
        }
        catch (Throwable t) {
            if (this.sessionState.dmstate != null) {
                this.sessionState.dmstate.state = (byte)69;
            }
            this.endSession();
            log.debug((Object)"processMessage", t);
            this.moveTo(65535);
        }
        ArrayList commands = response.getSyncBody().getCommands();
        ProtocolUtil.updateCmdId((List)commands);
        this.storeManagementCommandDescriptorForManagementCommands(this.msgIdGenerator.current(), commands);
        return response;
    }

    public SyncML processError(SyncML msg, Throwable error) throws Sync4jException {
        SyncHdr msgHeader = msg.getSyncHdr();
        int status = 511;
        if (error instanceof ServerException) {
            status = ((ServerException)error).getStatusCode();
        }
        Item item = new Item(new Target(msgHeader.getSource().getLocURI()), new Source(msgHeader.getTarget().getLocURI()), null, new ComplexData(error.getMessage()), false);
        Status statusCommand = new Status(this.engine.getCommandIdGenerator().next(), msgHeader.getMsgID(), "0", "SyncHdr", new TargetRef(msgHeader.getTarget()), new SourceRef(msgHeader.getSource()), null, null, new Data((long)status), new Item[]{item});
        String serverURI = Configuration.getConfiguration().getStringValue("server.uri");
        SyncHdr syncHeader = new SyncHdr(msgHeader.getVerDTD(), msgHeader.getVerProto(), msgHeader.getSessionID(), this.msgIdGenerator.current(), new Target(msgHeader.getSource().getLocURI()), new Source(serverURI), null, false, null, null);
        SyncBody syncBody = new SyncBody(new AbstractCommand[]{statusCommand}, true);
        this.moveTo(65535);
        return new SyncML(syncHeader, syncBody);
    }

    public void expire() {
        this.logout();
    }

    public void abort(int statusCode) {
        if (statusCode != 20000) {
            this.moveTo(65535);
        }
    }

    public void endSession() {
        this.logout();
        if (this.sessionState.dmstate != null) {
            switch (this.sessionState.dmstate.state) {
                case 67: {
                    this.engine.deleteDeviceDMState(this.sessionState.dmstate);
                    try {
                        this.processor.endSession(67);
                    }
                    catch (ManagementException e) {
                        if (log.isEnabled(Logger.Level.FATAL)) {
                            log.fatal((Object)("Error calling endSession: " + e.getMessage()));
                        }
                        log.debug((Object)"endSession", (Throwable)e);
                    }
                    break;
                }
                case 65: {
                    try {
                        this.processor.endSession(65);
                    }
                    catch (ManagementException e) {
                        if (log.isEnabled(Logger.Level.FATAL)) {
                            log.fatal((Object)("Error calling endSession: " + e.getMessage()));
                        }
                        log.debug((Object)"endSession", (Throwable)e);
                    }
                }
                default: {
                    this.sessionState.dmstate.end = new Date(System.currentTimeMillis());
                    this.engine.storeDeviceDMState(this.sessionState.dmstate);
                }
            }
        }
    }

    public void commit() {
        this.sessionState.dmstate.end = new Date(System.currentTimeMillis());
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Committing state: " + this.sessionState.dmstate));
        }
        this.engine.storeDeviceDMState(this.sessionState.dmstate);
    }

    private void init() {
        this.sessionState = new ManagementState();
        this.engine = new ManagementEngine(Configuration.getConfiguration());
    }

    private SyncML processInitMessage(SyncML request, boolean chalNotRequired) throws ProtocolException, ManagementException {
        block19: {
            block18: {
                NextNonce nonce;
                SyncBody syncBody = request.getSyncBody();
                ArrayList allClientCommands = syncBody.getCommands();
                List replaceCommands = ProtocolUtil.filterCommands((List)allClientCommands, (String[])new String[]{"Replace"});
                if (replaceCommands.isEmpty()) {
                    if (this.sessionState.devInfReplaceCommand != null) {
                        allClientCommands.add(this.sessionState.devInfReplaceCommand);
                        syncBody.setCommands(allClientCommands.toArray(new AbstractCommand[0]));
                    }
                } else {
                    this.sessionState.devInfReplaceCommand = (Replace)replaceCommands.get(0);
                }
                this.init = new ManagementInitialization(request.getSyncHdr(), request.getSyncBody());
                this.init.setIdGenerator(this.engine.getCommandIdGenerator());
                this.init.setServerAuthType(this.serverAuthType);
                this.init.setSupportedAuthType(this.supportedAuthType);
                this.init.setClientAuthType(this.clientAuthType);
                if (request.getSyncBody().isFinalMsg()) {
                    this.init.setFlag(3);
                } else {
                    this.init.unsetFlag(3);
                }
                if (this.clientAuthType != null && !chalNotRequired && (this.clientAuthType.equalsIgnoreCase("syncml:auth-md5") || this.clientAuthType.equalsIgnoreCase("syncml:auth-MAC"))) {
                    nonce = ProtocolUtil.generateNextNonce();
                    this.sessionState.device.setClientNonce(nonce.getValue());
                    this.init.setNextNonce(nonce);
                    this.engine.storeDevice(this.sessionState.device);
                }
                if (this.isAuthenticated()) break block18;
                switch (this.sessionState.authenticationState) {
                    case 2: {
                        this.init.setAuthorizedStatusCode(407);
                        if ((this.serverAuthType.equalsIgnoreCase("syncml:auth-md5") || this.serverAuthType.equalsIgnoreCase("syncml:auth-MAC")) && !chalNotRequired) {
                            nonce = ProtocolUtil.generateNextNonce();
                            this.sessionState.device.setClientNonce(nonce.getValue());
                            this.init.setNextNonce(nonce);
                            this.engine.storeDevice(this.sessionState.device);
                            break;
                        }
                        break block19;
                    }
                    case 3: {
                        this.init.setAuthorizedStatusCode(401);
                        if ((this.serverAuthType.equalsIgnoreCase("syncml:auth-md5") || this.serverAuthType.equalsIgnoreCase("syncml:auth-MAC")) && !chalNotRequired) {
                            nonce = ProtocolUtil.generateNextNonce();
                            this.sessionState.device.setClientNonce(nonce.getValue());
                            this.init.setNextNonce(nonce);
                            this.engine.storeDevice(this.sessionState.device);
                            break;
                        }
                        break block19;
                    }
                    default: {
                        this.init.setAuthorizedStatusCode(403);
                        break;
                    }
                }
                break block19;
            }
            if ("syncml:auth-MAC".equalsIgnoreCase(this.clientAuthType)) {
                this.init.setAuthorizedStatusCode(200);
            } else {
                this.init.setAuthorizedStatusCode(212);
            }
            Alert alert = this.init.getClientAlert();
            if (alert != null) {
                this.sessionState.type = alert.getData();
            }
        }
        if (this.sessionState.serverAuthenticationState != 5) {
            this.init.setServerCredentials(this.engine.getServerCredentials(this.getChal(request), this.sessionState.device));
        }
        if (chalNotRequired) {
            this.init.setFlag(10);
        } else {
            this.init.unsetFlag(10);
        }
        SyncML response = this.init.getResponse(this.msgIdGenerator.current());
        return response;
    }

    private SyncML processManagementMessage(SyncML request) throws ProtocolException, ManagementException {
        Chal chal;
        this.storeServerNonce(ProtocolUtil.getStatusChal((SyncML)request));
        this.actions = new ManagementActions(request.getSyncHdr(), request.getSyncBody());
        this.actions.setClientAuthType(this.clientAuthType);
        this.actions.setIdGenerator(this.engine.getCommandIdGenerator());
        boolean serverAbortRequired = false;
        if ("syncml:auth-MAC".equalsIgnoreCase(this.serverAuthType) && (chal = this.getMessageChal(request)) == null) {
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"Server abort the session because the client has not sent the next nonce");
            }
            serverAbortRequired = true;
        }
        Cred clientCred = null;
        if ("syncml:auth-MAC".equalsIgnoreCase(this.clientAuthType)) {
            NextNonce nonce = ProtocolUtil.generateNextNonce();
            this.sessionState.device.setClientNonce(nonce.getValue());
            this.actions.setNextNonce(nonce);
            this.engine.storeDevice(this.sessionState.device);
            clientCred = request.getSyncHdr().getCred();
            Officer officer = this.engine.getOfficer();
            if (!officer.authenticate(clientCred)) {
                if (log.isEnabled(Logger.Level.TRACE)) {
                    log.trace((Object)"Server abort the session because the credential sent by the client is not valid");
                }
                serverAbortRequired = true;
            }
        }
        if (serverAbortRequired) {
            if (this.sessionState.serverAuthenticationState != 5) {
                this.actions.setServerCredentials(this.engine.getServerCredentials(this.getChal(request), this.sessionState.device));
            }
            this.actions.setFlag(9);
            this.actions.setFlag(3);
            this.sessionState.nextTimestamp.end = System.currentTimeMillis();
            this.sessionState.dmstate.state = (byte)65;
            this.endSession();
            this.moveTo(2);
            SyncML response = this.actions.getResponse(this.msgIdGenerator.current());
            response.setLastMessage(true);
            return response;
        }
        Alert[] alertsToCache = ProtocolUtil.searchGenericAlertCommands((SyncBody)request.getSyncBody());
        this.sessionState.addGenericAlert(alertsToCache);
        boolean alertCode1222sentFromTheClient = false;
        boolean alertCode1222requiredFromTheClient = false;
        List commandToCache = ProtocolUtil.filterCommands((List)request.getSyncBody().getCommands(), (String[])new String[]{Status.COMMAND_NAME, "Results", "Alert"});
        Alert[] removedAlerts = this.removeAlerts(commandToCache);
        this.checkForReceivedLargeObject(commandToCache);
        this.sessionState.addClientCommands(commandToCache.toArray(new AbstractCommand[0]));
        if (!request.getSyncBody().isFinalMsg()) {
            Alert alert = ProtocolUtil.searchAlertCommand((SyncBody)request.getSyncBody(), (int)1222);
            if (alert != null) {
                alertCode1222sentFromTheClient = true;
            } else {
                this.actions.setFlag(8);
                alertCode1222requiredFromTheClient = true;
                Item itemWithLargeObject = ProtocolUtil.getLargeObject((List)commandToCache);
                if (itemWithLargeObject != null) {
                    this.sessionState.setReceivedLargeObject(itemWithLargeObject.getData().getData());
                    Long size = Util.getItemSize((Item)itemWithLargeObject);
                    if (size != null) {
                        this.sessionState.setSizeOfReceivedLargeObject(size);
                    } else if (this.sessionState.getSizeOfReceivedLargeObject() == null) {
                        this.sessionState.setSizeOfReceivedLargeObject(Long.valueOf(-1L));
                    }
                } else {
                    this.sessionState.setReceivedLargeObject(null);
                    this.sessionState.setSizeOfReceivedLargeObject(null);
                }
            }
        } else {
            this.actions.setFlag(3);
            if (removedAlerts == null || removedAlerts.length == 0) {
                this.actions.setClientCommands(this.sessionState.getClientCommands());
            } else {
                AbstractCommand[] commands = new AbstractCommand[this.sessionState.getClientCommands().length + removedAlerts.length];
                System.arraycopy(this.sessionState.getClientCommands(), 0, commands, 0, this.sessionState.getClientCommands().length);
                System.arraycopy(removedAlerts, 0, commands, this.sessionState.getClientCommands().length, removedAlerts.length);
                this.actions.setClientCommands(commands);
            }
            if (this.sessionState.getCmdOut() == null || this.sessionState.getCmdOut().isEmpty()) {
                this.processor.setOperationResults(com.funambol.framework.engine.dm.Util.operationResults((AbstractCommand[])this.actions.getClientCommands(), (String)String.valueOf(213)));
                this.sessionState.clearClientCommands();
                Alert[] genericAlerts = this.sessionState.getGenericAlert();
                if (genericAlerts != null || genericAlerts.length > 0) {
                    if (log.isEnabled(Logger.Level.DEBUG)) {
                        log.debug((Object)("Call setGenericAlert with " + genericAlerts.length + " generic alerts"));
                    }
                    this.processor.setGenericAlert(genericAlerts);
                    this.sessionState.clearGenericAlert();
                }
            }
            this.sessionState.setReceivedLargeObject(null);
        }
        this.actions.setFlag(-2);
        if (!(this.actions.isSessionAbortRequired() || alertCode1222requiredFromTheClient || alertCode1222sentFromTheClient)) {
            List commandInCache = this.sessionState.getCmdOut();
            if (log.isEnabled(Logger.Level.DEBUG)) {
                log.debug((Object)("command in cache: " + commandInCache.size()));
            }
            if (!commandInCache.isEmpty()) {
                AbstractCommand[] newCommands = commandInCache.toArray(new AbstractCommand[0]);
                this.actions.setManagementCommands(newCommands);
                this.sessionState.removeCmdOut(commandInCache);
                if (log.isEnabled(Logger.Level.DEBUG)) {
                    log.debug((Object)("Num. of managementCommands in actions: " + this.actions.getManagementCommands().length));
                }
            } else {
                if (log.isEnabled(Logger.Level.DEBUG)) {
                    log.debug((Object)"Call getNextOperations for new operation");
                }
                this.actions.setManagementCommands(com.funambol.framework.engine.dm.Util.managementOperations2commands((ManagementOperation[])this.processor.getNextOperations(), (CommandIdGenerator)this.engine.getCommandIdGenerator(), (String)this.mimeType));
            }
        } else if (alertCode1222sentFromTheClient) {
            AbstractCommand previousCommand = this.sessionState.getSplittedCommand();
            if (previousCommand == null) {
                throw new ProtocolException("No more data to send");
            }
            Item item = (Item)((ItemizedCommand)previousCommand).getItems().get(0);
            item.getData().setData(this.sessionState.getNextDataToSend());
            Meta meta = item.getMeta();
            if (meta != null) {
                meta.setSize(null);
            }
            item.setMoreData(Boolean.FALSE);
            List commandInCache = this.sessionState.getCmdOut();
            commandInCache.add(0, previousCommand);
            AbstractCommand[] newCommands = commandInCache.toArray(new AbstractCommand[0]);
            this.actions.setManagementCommands(newCommands);
        }
        if (this.sessionState.serverAuthenticationState != 5) {
            this.actions.setServerCredentials(this.engine.getServerCredentials(this.getChal(request), this.sessionState.device));
        }
        this.actions.setMimeType(this.mimeType);
        SyncML response = this.actions.getResponse(this.msgIdGenerator.current());
        if (alertCode1222requiredFromTheClient) {
            return response;
        }
        this.clearCache();
        this.cacheCommands(response);
        SyncHdr syncHdr = response.getSyncHdr();
        SyncBody syncBody = response.getSyncBody();
        long sizeSyncHdr = 0L;
        long sizeSyncBody = 0L;
        if ("application/vnd.syncml.dm+wbxml".equals(this.mimeType) || "application/vnd.syncml+wbxml".equals(this.mimeType)) {
            sizeSyncHdr = SizeCalculator.getWBXMLSize((SyncHdr)syncHdr);
            sizeSyncBody = SizeCalculator.getWBXMLSize((SyncBody)syncBody);
        } else if ("application/vnd.syncml.dm+xml".equals(this.mimeType) || "application/vnd.syncml+xml".equals(this.mimeType)) {
            sizeSyncHdr = SizeCalculator.getXMLSize((SyncHdr)syncHdr);
            sizeSyncBody = SizeCalculator.getXMLSize((SyncBody)syncBody);
        }
        if (log.isEnabled(Logger.Level.DEBUG)) {
            log.debug((Object)("maxMsgSize: " + this.sessionState.getMaxMsgSize()));
            log.debug((Object)("sizeSyncHdr: " + sizeSyncHdr));
            log.debug((Object)("sizeSyncBody: " + sizeSyncBody));
        }
        this.sessionState.setOverheadHdr(sizeSyncHdr);
        this.maxSizeAvailable = (int)((double)this.sessionState.getMaxMsgSize() * 0.85);
        if ((this.maxSizeAvailable >= sizeSyncHdr + sizeSyncBody || this.maxSizeAvailable == 0L) && this.sessionState.getStatusCmdOut().isEmpty() && this.sessionState.getAlertCmdOut().isEmpty() && this.sessionState.getCmdOut().isEmpty()) {
            return response;
        }
        try {
            response = this.createNextMsg(response);
        }
        catch (Sync4jException e) {
            throw new ProtocolException((Throwable)e);
        }
        return response;
    }

    private void moveTo(int state) {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("moving to state " + this.getStateName(state)));
        }
        this.currentState = state;
    }

    private boolean login(Cred credential, String deviceId) {
        this.logout();
        if (credential == null) {
            this.sessionState.authenticationState = 2;
            return false;
        }
        this.clientAuthType = credential.getType();
        Sync4jPrincipal p = Sync4jPrincipal.fromCredential((String)credential.getData(), (String)credential.getType(), (String)deviceId);
        if (this.clientAuthType.equalsIgnoreCase("syncml:auth-md5") || this.clientAuthType.equalsIgnoreCase("syncml:auth-MAC")) {
            NextNonce nonce = new NextNonce(this.sessionState.device.getClientNonce());
            Authentication auth = credential.getAuthentication();
            auth.setNextNonce(nonce);
            auth.setDeviceId(deviceId);
        }
        try {
            Officer officer = this.engine.getOfficer();
            if (officer.authenticate(credential)) {
                if (this.clientAuthType.equalsIgnoreCase("syncml:auth-md5") || this.clientAuthType.equalsIgnoreCase("syncml:auth-MAC")) {
                    p.setUsername(credential.getAuthentication().getUsername());
                }
                if (officer.authorize((Principal)p, "funambol.management")) {
                    this.sessionState.loggedCredential = credential;
                    this.sessionState.loggedPrincipal = p;
                    this.sessionState.authenticationState = 4;
                    return true;
                }
            }
        }
        catch (Exception e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)("Unable to login due to the error: " + e.getMessage()));
            }
            log.debug((Object)"login", (Throwable)e);
        }
        return false;
    }

    private void logout() {
        this.sessionState.authenticationState = 3;
        this.sessionState.loggedCredential = null;
        this.sessionState.loggedPrincipal = null;
    }

    private SyncML startManagementSession(SyncML requestMessage) throws ProtocolException, ManagementException {
        Alert alert;
        this.storeServerNonce(ProtocolUtil.getStatusChal((SyncML)requestMessage));
        String sessionId = requestMessage.getSyncHdr().getSessionID().getSessionID();
        Configuration c = Configuration.getConfiguration();
        this.sessionState.dmstate = new DeviceDMState(this.sessionState.device.getDeviceId());
        this.sessionState.dmstate.mssid = this.init.getSessionId();
        if (!this.engine.resolveDMState(this.sessionState.dmstate, this.sessionState.device)) {
            this.sessionState.dmstate.id = null;
            this.sessionState.dmstate.mssid = this.init.getSessionId();
        }
        if (this.addAbsCmd == null) {
            ProcessorSelector selector = (ProcessorSelector)c.getBeanInstance("server.dm.selector");
            this.processor = selector.getProcessor(this.sessionState.dmstate, this.init.getDevInfo());
            if (this.processor == null) {
                throw new ManagementException("No management processor could be selected!");
            }
            if (this.sessionState.dmstate.state == 78) {
                this.sessionState.dmstate.state = (byte)80;
            }
        }
        if ((alert = this.init.getClientAlert()) != null) {
            this.sessionState.type = alert.getData();
        }
        if (this.addAbsCmd == null) {
            this.sessionState.dmstate.start = new Date(System.currentTimeMillis());
            SessionContext context = new SessionContext(sessionId, this.sessionState.loggedPrincipal, this.sessionState.type, this.init.getDevInfo(), this.sessionState.dmstate, this.sessionState.syncMLVerProto);
            this.processor.beginSession(context);
            Alert[] genericAlerts = ProtocolUtil.searchGenericAlertCommands((SyncBody)requestMessage.getSyncBody());
            if (genericAlerts != null || genericAlerts.length > 0) {
                if (log.isEnabled(Logger.Level.DEBUG)) {
                    log.debug((Object)("Start session calls setGenericAlert with " + genericAlerts.length + " generic alerts"));
                }
                this.processor.setGenericAlert(genericAlerts);
            }
            if (!this.init.isSessionAbortRequired()) {
                this.init.setManagementCommands(com.funambol.framework.engine.dm.Util.managementOperations2commands((ManagementOperation[])this.processor.getNextOperations(), (CommandIdGenerator)this.engine.getCommandIdGenerator(), (String)this.mimeType));
            }
        }
        this.init.setRequest(requestMessage);
        if (requestMessage.getSyncBody().isFinalMsg()) {
            this.init.setFlag(3);
        } else {
            this.init.unsetFlag(3);
        }
        SyncML response = this.init.getResponse(this.msgIdGenerator.current());
        SyncHdr syncHdr = response.getSyncHdr();
        SyncBody syncBody = response.getSyncBody();
        long sizeSyncHdr = 0L;
        long sizeSyncBody = 0L;
        if ("application/vnd.syncml.dm+wbxml".equals(this.mimeType) || "application/vnd.syncml+wbxml".equals(this.mimeType)) {
            sizeSyncHdr = SizeCalculator.getWBXMLSize((SyncHdr)syncHdr);
            sizeSyncBody = SizeCalculator.getWBXMLSize((SyncBody)syncBody);
        } else if ("application/vnd.syncml.dm+xml".equals(this.mimeType) || "application/vnd.syncml+xml".equals(this.mimeType)) {
            sizeSyncHdr = SizeCalculator.getXMLSize((SyncHdr)syncHdr);
            sizeSyncBody = SizeCalculator.getXMLSize((SyncBody)syncBody);
        }
        if (log.isEnabled(Logger.Level.DEBUG)) {
            log.debug((Object)("maxMsgSize: " + this.sessionState.getMaxMsgSize()));
            log.debug((Object)("sizeSyncHdr: " + sizeSyncHdr));
            log.debug((Object)("sizeSyncBody: " + sizeSyncBody));
        }
        this.sessionState.setOverheadHdr(sizeSyncHdr);
        this.maxSizeAvailable = this.sessionState.getMaxMsgSize();
        this.checkMaxMsgSize(response);
        if ((this.maxSizeAvailable >= sizeSyncHdr + sizeSyncBody || this.maxSizeAvailable == 0L) && this.sessionState.getStatusCmdOut().isEmpty() && this.sessionState.getAlertCmdOut().isEmpty() && this.sessionState.getCmdOut().isEmpty()) {
            return response;
        }
        this.clearCache();
        this.cacheCommands(response);
        try {
            response = this.createNextMsg(response);
        }
        catch (Sync4jException e) {
            throw new ProtocolException((Throwable)e);
        }
        return response;
    }

    private boolean checkAuthType(Cred cred) {
        Officer officer = this.engine.getOfficer();
        this.serverAuthType = officer.getAuthType();
        this.supportedAuthType = officer.getSupportedAuthType();
        if (cred == null) {
            this.sessionState.authenticationState = officer.isGuestEnabled() ? 4 : 2;
            return officer.isGuestEnabled();
        }
        String clientAuthType = cred.getType();
        if (this.supportedAuthType.indexOf(clientAuthType) != -1) {
            return true;
        }
        this.sessionState.authenticationState = 3;
        return false;
    }

    private Chal getMessageChal(SyncML message) {
        Status[] statusCmds = ProtocolUtil.filterCommands((List)message.getSyncBody().getCommands(), (String[])new String[]{Status.COMMAND_NAME}).toArray(new Status[0]);
        for (int i = 0; statusCmds != null && i < statusCmds.length; ++i) {
            if (!"0".equals(statusCmds[i].getCmdRef()) || !"SyncHdr".equals(statusCmds[i].getCmd())) continue;
            return statusCmds[i].getChal();
        }
        return null;
    }

    private Chal getChal(SyncML msg) {
        Chal chal = this.getMessageChal(msg);
        if (chal == null) {
            if (this.sessionState.serverAuthenticationState != 5) {
                if (this.serverAuthType.equalsIgnoreCase("none")) {
                    return null;
                }
                Meta meta = new Meta();
                meta.setType(this.serverAuthType);
                meta.setFormat("clear");
                meta.setNextNonce(new NextNonce(this.sessionState.device.getServerNonce()));
                chal = new Chal(meta);
            }
        } else if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Challenged server authentication with scheme " + chal.getType()));
        }
        return chal;
    }

    private void checkServerAuthentication(SyncML msg) throws ProtocolException {
        int headerStatusCode = ProtocolUtil.getHeaderStatusCode((SyncML)msg);
        if (headerStatusCode == -1) {
            return;
        }
        if (headerStatusCode == 401 || headerStatusCode == 407) {
            String authRequiredFromClient = null;
            Chal chal = this.getChal(msg);
            if (chal != null) {
                authRequiredFromClient = chal.getType();
            }
            if (this.serverAuthType.equalsIgnoreCase("syncml:auth-basic") && authRequiredFromClient.equalsIgnoreCase("syncml:auth-basic")) {
                throw new ProtocolException("Unable to authenticate to the client");
            }
            if (!authRequiredFromClient.equalsIgnoreCase(this.serverAuthType)) {
                this.serverAuthType = authRequiredFromClient;
                this.init.setServerCredentials(this.engine.getServerCredentials(chal, this.sessionState.device));
                this.sessionState.serverAuthenticationState = 32;
            } else if (authRequiredFromClient.equalsIgnoreCase(this.serverAuthType) && this.sessionState.serverAuthenticationState == 1) {
                this.init.setServerCredentials(this.engine.getServerCredentials(chal, this.sessionState.device));
                this.sessionState.serverAuthenticationState = 32;
            } else {
                throw new ProtocolException("Unable to authenticate to the client");
            }
            return;
        }
        if (headerStatusCode == 212) {
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"Server logged (code 212)");
            }
            this.sessionState.serverAuthenticationState = 5;
        } else {
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"Server auhenticated (code 200)");
            }
            this.sessionState.serverAuthenticationState = 4;
        }
    }

    private void storeServerNonce(Chal chal) {
        NextNonce nonce;
        if (chal == null) {
            return;
        }
        if (("syncml:auth-md5".equals(chal.getType()) || "syncml:auth-MAC".equals(chal.getType())) && (nonce = chal.getNextNonce()) != null) {
            this.sessionState.device.setServerNonce(Base64.decode((byte[])nonce.getValue()));
            this.engine.storeDevice(this.sessionState.device);
        }
    }

    private String getStateName(int state) {
        String stateName = "STATE_UNKNOWN";
        switch (state) {
            case 0: {
                stateName = "STATE_START";
                break;
            }
            case 1: {
                stateName = "STATE_END";
                break;
            }
            case 65535: {
                stateName = "STATE_ERROR";
                break;
            }
            case 16: {
                stateName = "STATE_INITIALIZATION_PROCESSING";
                break;
            }
            case 17: {
                stateName = "STATE_INITIALIZATION_PROCESSED";
                break;
            }
            case 18: {
                stateName = "STATE_MANAGEMENT_PROCESSING";
                break;
            }
            case 19: {
                stateName = "STATE_MANAGEMENT_PROCESSED";
                break;
            }
            case 20: {
                stateName = "STATE_MANAGEMENT_COMPLETION";
                break;
            }
            case 2: {
                stateName = "STATE_SESSION_ABORTED";
                break;
            }
            default: {
                stateName = "STATE_UNKNOWN";
            }
        }
        return stateName;
    }

    private void clearCache() {
        this.sessionState.getAlertCmdOut().clear();
        this.sessionState.getStatusCmdOut().clear();
        this.sessionState.getCmdOut().clear();
    }

    private void cacheCommands(SyncML response) {
        List statusCmdOut = ProtocolUtil.filterCommands((List)response.getSyncBody().getCommands(), (String[])new String[]{Status.COMMAND_NAME});
        List<Object> listStatus = Arrays.asList(ProtocolUtil.sortStatusCommand((Object[])statusCmdOut.toArray(new Status[0])));
        this.sessionState.addStatusCmdOut(listStatus);
        Status statusSyncHdr = ProtocolUtil.filterStatus((AbstractCommand[])((AbstractCommand[])listStatus.toArray(new Status[0])), Status.class, (String)"SyncHdr");
        if ("application/vnd.syncml.dm+wbxml".equals(this.mimeType) || "application/vnd.syncml+wbxml".equals(this.mimeType)) {
            this.sessionState.setSizeStatusSyncHdr(SizeCalculator.getWBXMLSize((Status)statusSyncHdr));
        } else if ("application/vnd.syncml.dm+xml".equals(this.mimeType) || "application/vnd.syncml+xml".equals(this.mimeType)) {
            this.sessionState.setSizeStatusSyncHdr(SizeCalculator.getXMLSize((Status)statusSyncHdr));
        }
        this.sessionState.setStatusSyncHdr(statusSyncHdr);
        ArrayList<Status> removeStatus = new ArrayList<Status>();
        removeStatus.add(statusSyncHdr);
        this.sessionState.removeStatusCmdOut(removeStatus);
        List cmdOut = ProtocolUtil.filterCommands((List)response.getSyncBody().getCommands(), (String[])MANAGEMENT_COMMANDS);
        List<Object> listCmd = Arrays.asList(ProtocolUtil.sortAbstractCommand((Object[])cmdOut.toArray(new AbstractCommand[0])));
        this.sessionState.addCmdOut(new LinkedList<Object>(listCmd));
    }

    private SyncML createNextMsg(SyncML syncML) throws Sync4jException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"Create Next Message");
        }
        long sizeSyncHdr = this.sessionState.getOverheadHdr();
        long sizeStatusSyncHdr = this.sessionState.getSizeStatusSyncHdr();
        this.maxSizeAvailable = this.sessionState.getMaxMsgSize() - sizeSyncHdr - sizeStatusSyncHdr;
        if ("application/vnd.syncml.dm+wbxml".equals(this.mimeType) || "application/vnd.syncml+wbxml".equals(this.mimeType)) {
            this.maxSizeAvailable -= SizeCalculator.getWBXMLOverheadSyncML();
            this.maxSizeAvailable -= SizeCalculator.getWBXMLOverheadSyncBody();
        } else if ("application/vnd.syncml.dm+xml".equals(this.mimeType) || "application/vnd.syncml+xml".equals(this.mimeType)) {
            this.maxSizeAvailable -= SizeCalculator.getXMLOverheadSyncML();
            this.maxSizeAvailable -= SizeCalculator.getXMLOverheadSyncBody();
        }
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"How many Status can I include into the response?");
        }
        this.howManyStatus(this.sessionState.getStatusCmdOut());
        this.sessionState.removeStatusCmdOut(this.addStatus);
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"How many AbstractCommand can I include into the response?");
        }
        this.howManyAbstractCommand();
        this.sessionState.removeCmdOut(this.addAbsCmd);
        int size = this.addStatus.size() + this.addAbsCmd.size();
        ArrayList<Object> commandList = new ArrayList<Object>(size);
        commandList.addAll(this.addStatus);
        commandList.addAll(this.addAbsCmd);
        AbstractCommand[] absCommands = commandList.toArray(new AbstractCommand[size]);
        boolean isFinal = this.sessionState.getNextDataToSend() == null;
        SyncBody responseBody = new SyncBody(absCommands, isFinal);
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("status in cache after creation: " + this.sessionState.getStatusCmdOut().size()));
            log.trace((Object)("alert in cache after creation: " + this.sessionState.getAlertCmdOut().size()));
            log.trace((Object)("command in cache after creation: " + this.sessionState.getCmdOut().size()));
        }
        SyncML newResponse = new SyncML(syncML.getSyncHdr(), responseBody);
        if (log.isEnabled(Logger.Level.TRACE)) {
            if ("application/vnd.syncml.dm+wbxml".equals(this.mimeType) || "application/vnd.syncml+wbxml".equals(this.mimeType)) {
                size = (int)SizeCalculator.getWBXMLSize((SyncML)newResponse);
            } else if ("application/vnd.syncml.dm+xml".equals(this.mimeType) || "application/vnd.syncml+xml".equals(this.mimeType)) {
                size = (int)SizeCalculator.getXMLSize((SyncML)newResponse);
            }
            log.trace((Object)("Response size: " + size));
        }
        return newResponse;
    }

    private void howManyStatus(List<Object> allStatus) {
        this.addStatus = new ArrayList();
        this.addStatus.add(this.sessionState.getStatusSyncHdr());
        int x = 0;
        Status status = null;
        long size = 0L;
        for (int i = 0; allStatus != null && i < allStatus.size(); ++i) {
            status = (Status)allStatus.get(i);
            size = 0L;
            if ("application/vnd.syncml.dm+wbxml".equals(this.mimeType) || "application/vnd.syncml+wbxml".equals(this.mimeType)) {
                size = SizeCalculator.getWBXMLSize((Status)status);
            } else if ("application/vnd.syncml.dm+xml".equals(this.mimeType) || "application/vnd.syncml+xml".equals(this.mimeType)) {
                size = SizeCalculator.getXMLSize((Status)status);
            }
            if (this.maxSizeAvailable - size < 0L) break;
            this.addStatus.add((Status)allStatus.get(i));
            this.maxSizeAvailable -= size;
            ++x;
        }
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Number of Status inserted: " + x));
        }
    }

    private void howManyAbstractCommand() {
        this.addAbsCmd = new ArrayList();
        boolean isCmdWithLargeObject = false;
        int x = 0;
        List allCmd = this.sessionState.getCmdOut();
        if (this.maxSizeAvailable > 0L && this.sessionState.getStatusCmdOut().isEmpty() && this.sessionState.getAlertCmdOut().isEmpty()) {
            long size = 0L;
            AbstractCommand cmd = null;
            for (int i = 0; allCmd != null && i < allCmd.size(); ++i) {
                size = 0L;
                cmd = (AbstractCommand)allCmd.get(i);
                if ("application/vnd.syncml.dm+wbxml".equals(this.mimeType) || "application/vnd.syncml+wbxml".equals(this.mimeType)) {
                    size = SizeCalculator.getCommandWBXMLSize((AbstractCommand)cmd);
                } else if ("application/vnd.syncml.dm+xml".equals(this.mimeType) || "application/vnd.syncml+xml".equals(this.mimeType)) {
                    size = SizeCalculator.getCommandXMLSize((AbstractCommand)cmd);
                }
                if (this.maxSizeAvailable - size >= 0L) {
                    this.addAbsCmd.add(cmd);
                    this.maxSizeAvailable -= size;
                    if (cmd == this.sessionState.getSplittedCommand()) {
                        this.sessionState.setSplittedCommand(null);
                        this.sessionState.setNextDataToSend(null);
                    }
                    ++x;
                    continue;
                }
                isCmdWithLargeObject = this.checkForSplitData(cmd, this.maxSizeAvailable);
                if (i == 0) {
                    if (!isCmdWithLargeObject) {
                        if (log.isEnabled(Logger.Level.INFO)) {
                            log.info((Object)("The command " + cmd + " is too large (" + size + " bytes)"));
                        }
                        this.sessionState.removeCmdOut(cmd);
                        break;
                    }
                    this.addAbsCmd.add(cmd);
                    ++x;
                    if (this.sessionState.getNextDataToSend() != null) break;
                    continue;
                }
                if (!isCmdWithLargeObject) break;
                this.addAbsCmd.add(cmd);
                ++x;
                if (this.sessionState.getNextDataToSend() != null) break;
            }
        }
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Number of AbstractCommand inserted: " + x));
        }
    }

    private boolean checkForSplitData(AbstractCommand cmd, long sizeAvailable) {
        int sizeAvailableForData;
        long maxObjSize;
        String format;
        Item itemToSplit = null;
        if (cmd instanceof ItemizedCommand) {
            if (((ItemizedCommand)cmd).getItems().size() != 1) {
                if (log.isEnabled(Logger.Level.DEBUG)) {
                    log.debug((Object)"Command with more items isn't splittable");
                }
                return false;
            }
        } else {
            if (log.isEnabled(Logger.Level.DEBUG)) {
                log.debug((Object)"Command isn't a ItemizedCommand then it isn't splittable");
            }
            return false;
        }
        itemToSplit = (Item)((ItemizedCommand)cmd).getItems().get(0);
        ComplexData data = itemToSplit.getData();
        if (data == null) {
            return false;
        }
        String dataValue = data.getData();
        if (dataValue == null) {
            return false;
        }
        Object dataToSplit = dataValue;
        boolean isBinaryData = false;
        int lengthDataToSplit = 0;
        Meta meta = itemToSplit.getMeta();
        if (("application/vnd.syncml.dm+wbxml".equals(this.mimeType) || "application/vnd.syncml+wbxml".equals(this.mimeType)) && meta != null && (format = meta.getFormat()) != null && format.equalsIgnoreCase("b64")) {
            isBinaryData = true;
            dataToSplit = Base64.decode((byte[])((String)dataToSplit).getBytes());
            lengthDataToSplit = ((byte[])dataToSplit).length;
        }
        if (!isBinaryData) {
            lengthDataToSplit = ((String)dataToSplit).length();
        }
        if ((maxObjSize = this.sessionState.getMaxObjSize()) != 0L && (long)lengthDataToSplit > maxObjSize) {
            if (log.isEnabled(Logger.Level.DEBUG)) {
                log.debug((Object)"The dimension of the data is greater of the maxObjSize");
            }
            return false;
        }
        if (!this.sessionState.getNextDataToSend().equals(dataValue)) {
            if (meta == null) {
                meta = new Meta();
                itemToSplit.setMeta(meta);
            }
            meta.setSize(Long.valueOf(lengthDataToSplit));
        }
        if ((sizeAvailableForData = this.calculateDataSizeAvailable(sizeAvailable, cmd, itemToSplit)) <= 0) {
            return false;
        }
        this.sessionState.setSplittedCommand(cmd);
        Object newData = null;
        int lengthNewData = 0;
        if (isBinaryData) {
            if (sizeAvailableForData > lengthDataToSplit) {
                sizeAvailableForData = lengthDataToSplit;
                newData = dataToSplit;
            } else {
                newData = new byte[sizeAvailableForData];
                System.arraycopy(dataToSplit, 0, newData, 0, sizeAvailableForData);
            }
            lengthNewData = sizeAvailableForData;
        } else {
            newData = ((String)dataToSplit).substring(0, sizeAvailableForData);
            lengthNewData = ((String)newData).length();
        }
        if (isBinaryData) {
            newData = new String(Base64.encode((byte[])newData));
        }
        itemToSplit.getData().setData((String)newData);
        if (sizeAvailableForData >= lengthDataToSplit) {
            this.sessionState.setNextDataToSend(null);
            itemToSplit.setMoreData(Boolean.FALSE);
        } else {
            String dataNotSent = null;
            if (isBinaryData) {
                byte[] byteNotSent = new byte[lengthDataToSplit - sizeAvailableForData];
                System.arraycopy(dataToSplit, sizeAvailableForData, byteNotSent, 0, lengthDataToSplit - sizeAvailableForData);
                dataNotSent = new String(Base64.encode((byte[])byteNotSent));
            } else {
                dataNotSent = ((String)dataToSplit).substring(sizeAvailableForData);
            }
            itemToSplit.setMoreData(Boolean.TRUE);
            this.sessionState.setNextDataToSend(dataNotSent);
        }
        return true;
    }

    private int calculateDataSizeAvailable(long commandSizeAvailable, AbstractCommand cmd, Item item) {
        ComplexData itemData = item.getData();
        item.setData(new ComplexData(""));
        long commandSize = -1L;
        if ("application/vnd.syncml.dm+wbxml".equals(this.mimeType) || "application/vnd.syncml+wbxml".equals(this.mimeType)) {
            commandSize = SizeCalculator.getCommandWBXMLSize((AbstractCommand)cmd);
        } else if ("application/vnd.syncml.dm+xml".equals(this.mimeType) || "application/vnd.syncml+xml".equals(this.mimeType)) {
            commandSize = SizeCalculator.getCommandXMLSize((AbstractCommand)cmd);
        }
        int sizeAvailableForMoreData = (int)(commandSizeAvailable - commandSize);
        item.setData(itemData);
        return sizeAvailableForMoreData;
    }

    private void checkForReceivedLargeObject(List<AbstractCommand> clientCommands) throws ProtocolException {
        String previousReceivedLargeObject = this.sessionState.getReceivedLargeObject();
        if (previousReceivedLargeObject == null) {
            return;
        }
        ArrayList results = ProtocolUtil.filterCommands((AbstractCommand[])clientCommands.toArray(new AbstractCommand[0]), Results.class);
        if (results.isEmpty()) {
            throw new ProtocolException("Error awaiting more data from the client - No Results in the request");
        }
        Results result = (Results)results.get(0);
        Item item = (Item)result.getItems().get(0);
        boolean isReceivedItemWithBinaryData = Util.isItemWithBinaryData((Item)item);
        String receivedData = null;
        if (item.getData() == null) {
            throw new ProtocolException("Error awaiting more data from the client - No Data in the first item");
        }
        receivedData = item.getData().getData();
        if (isReceivedItemWithBinaryData && ("application/vnd.syncml.dm+xml".equals(this.mimeType) || "application/vnd.syncml+xml".equals(this.mimeType))) {
            isReceivedItemWithBinaryData = false;
        }
        if (isReceivedItemWithBinaryData) {
            byte[] previousData = Base64.decode((byte[])previousReceivedLargeObject.getBytes());
            byte[] bReceivedData = Base64.decode((byte[])receivedData.getBytes());
            byte[] newData = new byte[previousData.length + bReceivedData.length];
            System.arraycopy(previousData, 0, newData, 0, previousData.length);
            System.arraycopy(bReceivedData, 0, newData, previousData.length, bReceivedData.length);
            item.getData().setData(new String(Base64.encode((byte[])newData)));
        } else {
            String newData = previousReceivedLargeObject + receivedData;
            item.getData().setData(newData);
        }
        Meta meta = item.getMeta();
        if (meta == null) {
            meta = new Meta();
            item.setMeta(meta);
        }
        meta.setSize(this.sessionState.getSizeOfReceivedLargeObject());
    }

    private void mergeData() {
        AbstractCommand cmd = this.sessionState.getSplittedCommand();
        Item itemSplitted = (Item)((ItemizedCommand)cmd).getItems().get(0);
        boolean isBinary = Util.isItemWithBinaryData((Item)itemSplitted);
        if (isBinary && ("application/vnd.syncml.dm+xml".equals(this.mimeType) || "application/vnd.syncml+xml".equals(this.mimeType))) {
            isBinary = false;
        }
        if (isBinary) {
            byte[] previousData = Base64.decode((byte[])itemSplitted.getData().getData().getBytes());
            byte[] nextData = Base64.decode((byte[])this.sessionState.getNextDataToSend().getBytes());
            byte[] newData = new byte[previousData.length + nextData.length];
            System.arraycopy(previousData, 0, newData, 0, previousData.length);
            System.arraycopy(nextData, 0, newData, previousData.length, nextData.length);
            itemSplitted.getData().setData(new String(Base64.encode((byte[])newData)));
        } else {
            String previousData = itemSplitted.getData().getData();
            String nextData = this.sessionState.getNextDataToSend();
            String newData = previousData + nextData;
            itemSplitted.getData().setData(newData);
        }
    }

    private void checkMaxMsgSize(SyncML response) {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"Check if the MaxMsgSize is larger of the minimal size of the messages of the server");
        }
        long minMsgSize = 0L;
        if (this.sessionState.getMaxMsgSize() != 0L) {
            if ("application/vnd.syncml+wbxml".equals(this.mimeType) || "application/vnd.syncml.dm+wbxml".equals(this.mimeType)) {
                minMsgSize = Long.parseLong(this.engine.getConfiguration().getStringValue("minWBXMLMaxMsgSize"));
            } else if ("application/vnd.syncml+xml".equals(this.mimeType) || "application/vnd.syncml.dm+xml".equals(this.mimeType)) {
                minMsgSize = Long.parseLong(this.engine.getConfiguration().getStringValue("minXMLMaxMsgSize"));
            }
            if (this.sessionState.getMaxMsgSize() < minMsgSize) {
                Status statusHdr = (Status)response.getSyncBody().getCommands().get(0);
                statusHdr.setData(new Data(500L));
                if (log.isEnabled(Logger.Level.INFO)) {
                    log.info((Object)"The MaxMsgSize is smaller than minimum size that the server response could have!");
                    log.info((Object)"The server will not answer to some message of the client.");
                }
            }
        }
    }

    private Alert[] removeAlerts(List<AbstractCommand> commands) {
        if (commands == null || commands.isEmpty()) {
            return new Alert[0];
        }
        ArrayList<AbstractCommand> commandsToRemove = new ArrayList<AbstractCommand>();
        Iterator<AbstractCommand> itCommands = commands.iterator();
        AbstractCommand command = null;
        while (itCommands.hasNext()) {
            command = itCommands.next();
            if (!(command instanceof Alert)) continue;
            commandsToRemove.add(command);
        }
        commands.removeAll(commandsToRemove);
        return commandsToRemove.toArray(new Alert[0]);
    }

    private void storeManagementCommandDescriptorForManagementCommands(String msgId, List commands) {
        if (commands == null) {
            return;
        }
        Iterator itCommands = commands.iterator();
        String cmdId = null;
        AbstractCommand command = null;
        ManagementCommandDescriptor commandDescriptor = null;
        while (itCommands.hasNext()) {
            command = (AbstractCommand)itCommands.next();
            if (command instanceof Atomic) {
                this.storeManagementCommandDescriptorForManagementCommands(msgId, ((Atomic)command).getCommands());
                continue;
            }
            if (command instanceof Sequence) {
                this.storeManagementCommandDescriptorForManagementCommands(msgId, ((Sequence)command).getCommands());
                continue;
            }
            cmdId = command.getCmdID().getCmdID();
            String key = this.getCommandDescriptorKey(msgId, cmdId);
            commandDescriptor = this.createManagementCommandDescriptor(msgId, command);
            this.sessionState.managementCommandDescriptors.put(key.toString(), commandDescriptor);
        }
    }

    private ManagementCommandDescriptor createManagementCommandDescriptor(String msgId, AbstractCommand command) {
        if (command instanceof Alert && !this.isAManagementAlert((Alert)command)) {
            return null;
        }
        ManagementCommandDescriptor commandDescriptor = null;
        if (command instanceof Add || command instanceof Alert || command instanceof Copy || command instanceof Delete || command instanceof Exec || command instanceof Get || command instanceof Replace) {
            commandDescriptor = new ManagementCommandDescriptor(msgId, command.getCmdID().getCmdID(), command.getName());
        }
        return commandDescriptor;
    }

    private boolean isAManagementAlert(Alert alert) {
        if (alert == null) {
            return false;
        }
        int code = alert.getData();
        switch (code) {
            case 1100: 
            case 1101: 
            case 1102: 
            case 1103: 
            case 1104: {
                return true;
            }
        }
        return false;
    }

    private AbstractCommand[] removeStatusWithoutCommandDescriptor(AbstractCommand[] commands, Map commandDescriptors) {
        if (commands == null || commands.length == 0) {
            return commands;
        }
        ArrayList<AbstractCommand> commandsToReturn = new ArrayList<AbstractCommand>(commands.length);
        String msgRef = null;
        String cmdRef = null;
        String cmd = null;
        String key = null;
        ManagementCommandDescriptor cmdDescriptor = null;
        for (int i = 0; i < commands.length; ++i) {
            if (!(commands[i] instanceof Status)) {
                commandsToReturn.add(commands[i]);
                continue;
            }
            msgRef = ((Status)commands[i]).getMsgRef();
            cmdRef = ((Status)commands[i]).getCmdRef();
            cmd = ((Status)commands[i]).getCmd();
            key = this.getCommandDescriptorKey(msgRef, cmdRef);
            cmdDescriptor = (ManagementCommandDescriptor)this.sessionState.managementCommandDescriptors.get(key);
            if (cmdDescriptor == null || !cmdDescriptor.getCommandName().equalsIgnoreCase(cmd)) continue;
            commandsToReturn.add(commands[i]);
        }
        return commandsToReturn.toArray(new AbstractCommand[commandsToReturn.size()]);
    }

    private String getCommandDescriptorKey(String msgId, String cmdId) {
        StringBuffer sb = new StringBuffer(msgId);
        sb.append('|').append(cmdId);
        return sb.toString();
    }
}

