/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.store;

import com.funambol.framework.server.Sync4jConnector;
import com.funambol.framework.server.Sync4jModule;
import com.funambol.framework.server.Sync4jSourceType;
import com.funambol.framework.server.store.BasePersistentStore;
import com.funambol.framework.server.store.Clause;
import com.funambol.framework.server.store.NotFoundException;
import com.funambol.framework.server.store.PersistentStore;
import com.funambol.framework.server.store.PersistentStoreException;
import com.funambol.framework.tools.DBTools;
import com.funambol.server.engine.Sync4jSource;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ModulesPersistentStore
extends BasePersistentStore
implements PersistentStore,
Serializable {
    public static final int SQL_SELECT_ALL_MODULES_NAME = 0;
    public static final int SQL_GET_MODULE = 1;
    public static final int SQL_SELECT_MODULE_CONNECTOR = 2;
    public static final int SQL_SELECT_CONNECTOR_SYNCSOURCETYPE = 3;
    public static final int SQL_SELECT_SYNCSOURCETYPE_SYNCSOURCE = 4;
    private String[] sql = null;

    public void setSql(String[] sql) {
        this.sql = sql;
    }

    public String[] getSql() {
        return this.sql;
    }

    public boolean delete(Object o) throws PersistentStoreException {
        return false;
    }

    public Object[] delete(Class objClass) throws PersistentStoreException {
        return new Object[0];
    }

    public boolean store(String id, Object o, String operation) throws PersistentStoreException {
        return false;
    }

    public boolean store(Object o) throws PersistentStoreException {
        return false;
    }

    public boolean read(Object o) throws PersistentStoreException {
        if (o instanceof Sync4jModule) {
            this.readModule((Sync4jModule)o);
            return true;
        }
        return false;
    }

    public Object[] read(Class objClass) throws PersistentStoreException {
        if (objClass.equals(Sync4jModule.class)) {
            return this.readModulesName();
        }
        return null;
    }

    public Object[] read(Object o, Clause clause) throws PersistentStoreException {
        if (o instanceof Sync4jSourceType) {
            return this.readSyncSource((Sync4jSourceType)o);
        }
        return null;
    }

    private Object[] readModulesName() throws PersistentStoreException {
        Object[] objectArray;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Sync4jModule> ret = new ArrayList<Sync4jModule>();
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[0]);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ret.add(new Sync4jModule(rs.getString(1), rs.getString(2), rs.getString(3)));
            }
            objectArray = ret.toArray(new Sync4jModule[ret.size()]);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading modules name", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
        return objectArray;
    }

    private void readModule(Sync4jModule module) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[1]);
            stmt.setString(1, module.getModuleId());
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new NotFoundException("Module not found for " + module.getModuleId());
            }
            module.setModuleId(rs.getString(1));
            module.setModuleName(rs.getString(2));
            module.setDescription(rs.getString(3));
            Sync4jConnector[] syncConnectors = (Sync4jConnector[])this.readModuleConnectors(module);
            module.setConnectors(syncConnectors);
            for (int i = 0; syncConnectors != null && i < syncConnectors.length; ++i) {
                Sync4jConnector sc = syncConnectors[i];
                Sync4jSourceType[] sst = (Sync4jSourceType[])this.readSyncSourceType(sc);
                sc.setSourceTypes(sst);
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading the module " + module, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
    }

    private Object[] readModuleConnectors(Sync4jModule module) throws PersistentStoreException {
        Object[] objectArray;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Sync4jConnector> ret = new ArrayList<Sync4jConnector>();
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[2]);
            stmt.setString(1, module.getModuleId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                ret.add(new Sync4jConnector(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4)));
            }
            objectArray = ret.toArray(new Sync4jConnector[ret.size()]);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading the connectors ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
        return objectArray;
    }

    private Object[] readSyncSourceType(Sync4jConnector sc) throws PersistentStoreException {
        Object[] objectArray;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Sync4jSourceType> ret = new ArrayList<Sync4jSourceType>();
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[3]);
            stmt.setString(1, sc.getConnectorId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                ret.add(new Sync4jSourceType(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4)));
            }
            objectArray = ret.toArray(new Sync4jSourceType[ret.size()]);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading the SyncSourceType ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
        return objectArray;
    }

    private Object[] readSyncSource(Sync4jSourceType sst) throws PersistentStoreException {
        Object[] objectArray;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Sync4jSource> ret = new ArrayList<Sync4jSource>();
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[4]);
            stmt.setString(1, sst.getSourceTypeId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                ret.add(new Sync4jSource(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4)));
            }
            objectArray = ret.toArray(new Sync4jSource[ret.size()]);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading the SyncSource ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
        return objectArray;
    }

    public int readCounter(String idSpace, int increment) throws PersistentStoreException {
        throw new PersistentStoreException("Function not supported");
    }
}

