/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.notification;

import com.funambol.framework.notification.BitOutputStream;
import com.funambol.framework.notification.NotificationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TriggerHeaderNotificationMessage {
    public static final byte UI_MODE_NOT_SPECIFIED = 0;
    public static final byte UI_MODE_BACKGROUND = 1;
    public static final byte UI_MODE_INFORMATIVE = 2;
    public static final byte UI_MODE_USER_INTERACTION = 3;
    public static final byte INITIATOR_CLIENT = 0;
    public static final byte INITIATOR_SERVER = 1;
    private static final float MAX_VERSION_VALUE = 102.3f;
    private static final int NUM_BIT_VERSION_FIELD = 10;
    private static final int NUM_BIT_FUTURE_USE_FIELD = 27;
    private static final int NUM_BIT_SESSION_ID_FIELD = 16;
    private static final int NUM_BIT_SERVER_ID_LENGTH_FIELD = 8;
    private float version;
    private int uiMode;
    private int initiator;
    private int sessionId;
    private String serverIdentifier;

    public TriggerHeaderNotificationMessage() {
    }

    public TriggerHeaderNotificationMessage(float version, int uiMode, int initiator, int sessionId, String serverIdentifier) {
        this.version = version;
        this.uiMode = uiMode;
        this.initiator = initiator;
        this.sessionId = sessionId;
        this.serverIdentifier = serverIdentifier;
    }

    public float getVersion() {
        return this.version;
    }

    public void setVersion(float version) throws NotificationException {
        if (version > 102.3f) {
            throw new NotificationException("Value specified for version information must be small of 102.3");
        }
        this.version = version;
    }

    public int getUiMode() {
        return this.uiMode;
    }

    public void setUiMode(int uiMode) {
        this.uiMode = uiMode;
    }

    public int getInitiator() {
        return this.initiator;
    }

    public void setInitiator(int initiator) {
        this.initiator = initiator;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public String getServerIdentifier() {
        return this.serverIdentifier;
    }

    public void setServerIdentifier(String serverIdentifier) {
        this.serverIdentifier = serverIdentifier;
    }

    public byte[] buildByteMessageValue() throws NotificationException {
        byte[] toReturn = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        BitOutputStream bout = new BitOutputStream(byteOut);
        byte[] bServerId = null;
        try {
            int i;
            int newVersion = (int)(this.version * 10.0f);
            int[] intRepresentation = this.getIntBinaryRepresentation(newVersion, 10);
            for (i = 0; i < 10; ++i) {
                bout.writeBit(intRepresentation[i]);
            }
            switch (this.uiMode) {
                case 0: {
                    bout.writeBit(0);
                    bout.writeBit(0);
                    break;
                }
                case 1: {
                    bout.writeBit(0);
                    bout.writeBit(1);
                    break;
                }
                case 2: {
                    bout.writeBit(1);
                    bout.writeBit(0);
                    break;
                }
                case 3: {
                    bout.writeBit(1);
                    bout.writeBit(1);
                    break;
                }
                default: {
                    bout.close();
                    throw new NotificationException("User interaction mode '" + this.uiMode + "' isn't valid");
                }
            }
            switch (this.initiator) {
                case 0: {
                    bout.writeBit(0);
                    break;
                }
                case 1: {
                    bout.writeBit(1);
                    break;
                }
                default: {
                    bout.close();
                    throw new NotificationException("Initiator value '" + this.uiMode + "' isn't valid");
                }
            }
            for (i = 0; i < 27; ++i) {
                bout.writeBit(0);
            }
            int[] intRepresentationSessionId = this.getIntBinaryRepresentation(this.sessionId, 16);
            for (int i2 = 0; i2 < 16; ++i2) {
                bout.writeBit(intRepresentationSessionId[i2]);
            }
            int length = this.serverIdentifier.length();
            int[] intRepresentationLength = this.getIntBinaryRepresentation(length, 8);
            for (int i3 = 0; i3 < 8; ++i3) {
                bout.writeBit(intRepresentationLength[i3]);
            }
            bServerId = this.serverIdentifier.getBytes("UTF-8");
            bout.close();
        }
        catch (IOException ex) {
            throw new NotificationException("Error during message building", ex);
        }
        byte[] tmp = byteOut.toByteArray();
        toReturn = new byte[tmp.length + this.serverIdentifier.length()];
        System.arraycopy(tmp, 0, toReturn, 0, tmp.length);
        System.arraycopy(bServerId, 0, toReturn, tmp.length, bServerId.length);
        return toReturn;
    }

    private static int[] converteBinaryRepresentation(String binaryRepresentation) {
        char[] c = binaryRepresentation.toCharArray();
        int[] intRepresentation = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            intRepresentation[i] = Integer.parseInt(String.valueOf(c[i]));
        }
        return intRepresentation;
    }

    private int[] getIntBinaryRepresentation(int value, int n) {
        String sBinaryValue = Integer.toBinaryString(value);
        sBinaryValue = TriggerHeaderNotificationMessage.paddingString(sBinaryValue, n, '0', true);
        int[] intRepresentation = TriggerHeaderNotificationMessage.converteBinaryRepresentation(sBinaryValue);
        return intRepresentation;
    }

    private static String paddingString(String s, int n, char c, boolean paddingLeft) {
        StringBuffer str = new StringBuffer(s);
        int strLength = str.length();
        if (n > 0 && n > strLength) {
            for (int i = 0; i <= n; ++i) {
                if (paddingLeft) {
                    if (i >= n - strLength) continue;
                    str.insert(0, c);
                    continue;
                }
                if (i <= strLength) continue;
                str.append(c);
            }
        }
        return str.toString();
    }
}

