/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.security.jaas;

import com.funambol.framework.security.Sync4jPrincipal;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SimpleLoginModule
implements LoginModule {
    private Subject subject = null;
    private CallbackHandler handler = null;
    private boolean loginSucceded = false;
    private boolean loginCommitted = false;
    private Principal principal = null;
    private String username = null;
    private String password = null;
    protected static final Logger log = Logger.getLogger((String)SimpleLoginModule.class.getName());

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = handler;
        this.loginCommitted = false;
        this.loginSucceded = false;
        this.username = null;
        this.password = null;
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("sharedState: " + sharedState));
            log.trace((Object)("options: " + options));
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.handler == null) {
            throw new LoginException("No CallbackHandler defined");
        }
        Callback[] callbacks = new Callback[2];
        NameCallback nameCallback = new NameCallback("Username");
        PasswordCallback passwordCallback = new PasswordCallback("Password", false);
        callbacks[0] = nameCallback;
        callbacks[1] = passwordCallback;
        try {
            this.handler.handle(callbacks);
            this.username = nameCallback.getName();
            this.password = passwordCallback.getPassword() == null ? null : new String(passwordCallback.getPassword());
            passwordCallback.clearPassword();
        }
        catch (Exception e) {
            throw new LoginException(e.toString());
        }
        this.loginSucceded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.loginSucceded) {
            return false;
        }
        this.principal = new Sync4jPrincipal(null, this.username, null);
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
        }
        this.username = null;
        this.password = null;
        this.loginCommitted = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.loginSucceded) {
            return false;
        }
        if (!this.loginCommitted) {
            this.loginSucceded = false;
            this.password = null;
            this.username = null;
            this.principal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.loginCommitted = false;
        this.loginSucceded = false;
        this.password = null;
        this.username = null;
        this.principal = null;
        return true;
    }
}

