/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.IXMLReaderFactory;
import org.jibx.runtime.impl.StAXReaderWrapper;

public class StAXReaderFactory
implements IXMLReaderFactory {
    private static final StAXReaderFactory s_instance = new StAXReaderFactory();
    private final XMLInputFactory m_factory;
    private boolean m_isNamespaceEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StAXReaderFactory() {
        XMLInputFactory factory;
        try {
            factory = XMLInputFactory.newInstance();
        }
        catch (FactoryConfigurationError e) {
            Thread thread = Thread.currentThread();
            ClassLoader cl = thread.getContextClassLoader();
            thread.setContextClassLoader(StAXReaderFactory.class.getClassLoader());
            try {
                factory = XMLInputFactory.newInstance();
            }
            finally {
                thread.setContextClassLoader(cl);
            }
        }
        this.m_factory = factory;
        this.m_isNamespaceEnabled = true;
    }

    public static StAXReaderFactory getInstance() {
        return s_instance;
    }

    private void setNamespacesState(boolean nsf) throws JiBXException {
        if (nsf != this.m_isNamespaceEnabled) {
            try {
                this.m_factory.setProperty("javax.xml.stream.isNamespaceAware", nsf ? Boolean.TRUE : Boolean.FALSE);
                this.m_isNamespaceEnabled = nsf;
            }
            catch (IllegalArgumentException e) {
                throw new JiBXException("Unable to create parser with required namespace handling");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IXMLReader createReader(InputStream is, String name, String enc, boolean nsf) throws JiBXException {
        try {
            XMLInputFactory xMLInputFactory = this.m_factory;
            synchronized (xMLInputFactory) {
                this.setNamespacesState(Boolean.FALSE);
                if (enc == null) {
                    XMLStreamReader rdr = this.m_factory.createXMLStreamReader(is);
                    return new StAXReaderWrapper(rdr, name, Boolean.FALSE);
                }
                XMLStreamReader rdr = this.m_factory.createXMLStreamReader(is, enc);
                return new StAXReaderWrapper(rdr, name, Boolean.FALSE);
            }
        }
        catch (XMLStreamException e) {
            throw new JiBXException("Error creating parser", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IXMLReader createReader(Reader rdr, String name, boolean nsf) throws JiBXException {
        try {
            XMLInputFactory xMLInputFactory = this.m_factory;
            synchronized (xMLInputFactory) {
                this.setNamespacesState(nsf);
                return new StAXReaderWrapper(this.m_factory.createXMLStreamReader(rdr), name, nsf);
            }
        }
        catch (XMLStreamException e) {
            throw new JiBXException("Error creating parser", e);
        }
    }

    @Override
    public IXMLReader recycleReader(IXMLReader old, InputStream is, String name, String enc) throws JiBXException {
        return this.createReader(is, name, enc, old.isNamespaceAware());
    }

    @Override
    public IXMLReader recycleReader(IXMLReader old, Reader rdr, String name) throws JiBXException {
        return this.createReader(rdr, name, old.isNamespaceAware());
    }
}

